/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.resources;

import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.ResourcePrototype;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.onebusaway.presentation.impl.resources.ClientBundleContext;
import org.onebusaway.presentation.impl.resources.ClientBundleImpl;
import org.onebusaway.presentation.impl.resources.CssResourceImpl;
import org.onebusaway.presentation.impl.resources.ImageResourceImpl;
import org.onebusaway.presentation.impl.resources.LocalResource;
import org.onebusaway.presentation.impl.resources.ResourcePrototypeImpl;
import org.onebusaway.presentation.impl.resources.ResourceWithUrl;
import org.onebusaway.presentation.services.resources.WebappSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBundleFactory {
    private static final String PREFIX_CLASSPATH = "classpath:";
    private static Logger _log = LoggerFactory.getLogger(ClientBundleFactory.class);
    private Map<String, Object> _bundlesByNamePath = new HashMap<String, Object>();
    private Map<Class<?>, ClientBundle> _bundlesByType = new HashMap();
    private Map<LocalResource, String> _resourceToUrl = new HashMap<LocalResource, String>();
    private Map<String, LocalResource> _urlToResource = new HashMap<String, LocalResource>();
    private String _prefix;
    private String _pattern;
    private File _tempDir;
    private ContextImpl _context = new ContextImpl();
    private ServletContext _servletContext;
    private String _contextPath;

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
        this._contextPath = this.getContextPath(this._servletContext);
        File tmpDir = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
        if (tmpDir == null) {
            _log.warn("NO ServletContext TEMP DIR!");
            tmpDir = new File(System.getProperty("java.io.tmpdir"));
        }
        this._tempDir = new File(tmpDir, "ClientBundles");
        if (!this._tempDir.exists()) {
            this._tempDir.mkdirs();
        }
        this._servletContext.setAttribute("resources", this._bundlesByNamePath);
    }

    public void setResources(List<Class<?>> resources) throws IOException {
        for (Class<?> bundleType : resources) {
            try {
                this.addResource(bundleType);
            }
            catch (Exception ex) {
                _log.error("error adding resource of type: " + bundleType.getName(), (Throwable)ex);
                throw new IllegalStateException("error adding resource of type: " + bundleType.getName(), ex);
            }
        }
    }

    public void addResource(Class<?> bundleType) throws IOException {
        if (!ClientBundle.class.isAssignableFrom(bundleType)) {
            throw new IllegalArgumentException("class is not assignable to " + ClientBundle.class + ": " + bundleType);
        }
        if (this._bundlesByType.containsKey(bundleType)) {
            return;
        }
        ClientBundleImpl bundle = new ClientBundleImpl(bundleType);
        List<ResourcePrototypeImpl> resources = this.processBundleMethods(bundleType, bundle);
        for (ResourcePrototypeImpl resource : resources) {
            resource.refresh();
        }
        ClientBundle bundleProxy = (ClientBundle)Proxy.newProxyInstance(bundleType.getClassLoader(), new Class[]{bundleType}, (InvocationHandler)bundle);
        this._bundlesByType.put(bundleType, bundleProxy);
        this.addBundleToResourcePath(bundleType, bundleProxy);
    }

    public Map<String, Object> getBundles() {
        return this._bundlesByNamePath;
    }

    public LocalResource getResourceForExternalUrl(String externalUrl) {
        return this._urlToResource.get(externalUrl);
    }

    public <T extends ClientBundle> T getBundleForType(Class<T> bundleType) {
        ClientBundle bundle = this._bundlesByType.get(bundleType);
        return (T)bundle;
    }

    private List<ResourcePrototypeImpl> processBundleMethods(Class<?> bundleType, ClientBundleImpl bundle) throws MalformedURLException {
        ArrayList<ResourcePrototypeImpl> resources = new ArrayList<ResourcePrototypeImpl>();
        for (Method method : bundleType.getMethods()) {
            ResourcePrototypeImpl resourceImpl;
            String methodName = method.getName();
            WebappSource source = method.getAnnotation(WebappSource.class);
            if (source == null) {
                _log.warn("no Resource annotation found: " + methodName);
                continue;
            }
            String[] values = source.value();
            if (values == null || values.length != 1) {
                throw new IllegalStateException("@WebappSource has no value: " + bundleType.getName() + "#" + methodName);
            }
            String resourceName = values[0];
            Class<?> returnType = method.getReturnType();
            URL localURL = this.getBundleResourceAsLocalUrl(bundleType, resourceName);
            if (localURL == null) {
                _log.warn("could not find ClientBundle resource for " + bundleType.getName() + "#" + methodName + " source=" + resourceName);
                continue;
            }
            File localFile = this.getBundleResourceAsLocalFile(resourceName, localURL);
            String name = this.getMethodNameAsPropertyName(methodName);
            if (name == null) {
                _log.warn("invalid resource name: " + bundleType.getName() + "#" + methodName);
                continue;
            }
            if (CssResource.class.isAssignableFrom(returnType)) {
                resourceImpl = new CssResourceImpl(this._context, bundle, methodName, localURL);
                if (localFile != null) {
                    resourceImpl.setLocalFile(localFile);
                }
                resources.add(resourceImpl);
                ResourcePrototype resourceProxy = (ResourcePrototype)Proxy.newProxyInstance(bundleType.getClassLoader(), new Class[]{returnType, ResourceWithUrl.class}, (InvocationHandler)((Object)resourceImpl));
                bundle.addResource(resourceProxy);
                continue;
            }
            if (!ImageResource.class.isAssignableFrom(returnType)) continue;
            resourceImpl = new ImageResourceImpl(this._context, bundle, methodName, localURL);
            bundle.addResource(resourceImpl);
            resources.add(resourceImpl);
        }
        return resources;
    }

    private URL getBundleResourceAsLocalUrl(Class<?> bundleType, String resourceName) throws MalformedURLException {
        if (resourceName.startsWith(PREFIX_CLASSPATH)) {
            URL resource = bundleType.getResource(resourceName = resourceName.substring(PREFIX_CLASSPATH.length()));
            if (resource == null) {
                _log.warn("unknown classpath resource: name=" + resourceName + " bundleType=" + bundleType.getName());
            }
            return resource;
        }
        return this._servletContext.getResource(resourceName);
    }

    private File getBundleResourceAsLocalFile(String resourceName, URL resourceUrl) {
        String protocol = resourceUrl.getProtocol();
        if ("file".equals(protocol)) {
            return new File(resourceUrl.getPath());
        }
        File path = new File(this._servletContext.getRealPath(resourceName));
        if (path.exists()) {
            return path;
        }
        return null;
    }

    private String construct(String bundleName, String resourceName, String resourceKey, String resourceExtension) {
        StringBuilder b = new StringBuilder();
        b.append(bundleName);
        b.append('-');
        if (resourceName.startsWith("get")) {
            resourceName = resourceName.substring(3);
        }
        b.append(resourceName);
        b.append('-');
        b.append(resourceKey);
        b.append(".cache");
        if (resourceExtension != null && resourceExtension.length() > 0) {
            b.append('.').append(resourceExtension);
        }
        return b.toString();
    }

    private String addContext(String url) {
        if (this._contextPath != null && this._contextPath.length() > 0) {
            url = this._contextPath + (String)url;
        }
        return url;
    }

    private String getContextPath(ServletContext context) {
        String contextPath = "";
        try {
            String path = context.getResource("/").getPath();
            contextPath = path.substring(0, path.lastIndexOf("/"));
            contextPath = contextPath.substring(contextPath.lastIndexOf("/"));
            if (contextPath.equals("/localhost")) {
                contextPath = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contextPath;
    }

    private String getMethodNameAsPropertyName(String methodName) {
        if (!methodName.startsWith("get")) {
            return methodName;
        }
        String name = methodName.substring(3);
        if (name.length() == 0) {
            return null;
        }
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    private void addBundleToResourcePath(Class<?> bundleType, ClientBundle bundleProxy) {
        List<String> keys = this.getKeysForBundleType(bundleType);
        for (String key : keys) {
            Map current = this._bundlesByNamePath;
            String[] tokens = key.split("\\.");
            for (int i = 0; i < tokens.length - 1; ++i) {
                HashMap obj = current.get(tokens[i]);
                if (obj == null) {
                    obj = new HashMap();
                }
                if (!(obj instanceof Map)) {
                    throw new IllegalStateException("name collision: " + key + " bundleType=" + bundleType.getName());
                }
                current = obj;
            }
            current.put((String)tokens[tokens.length - 1], (Object)bundleProxy);
        }
    }

    private List<String> getKeysForBundleType(Class<?> bundleType) {
        ArrayList<String> names = new ArrayList<String>();
        String name = bundleType.getName();
        names.add(name);
        int index = name.lastIndexOf(".");
        if (index != -1 && (name = name.substring(index + 1)).length() > 0) {
            names.add(name);
        }
        return names;
    }

    private class ContextImpl
    implements ClientBundleContext {
        private ContextImpl() {
        }

        @Override
        public String addContext(String url) {
            return ClientBundleFactory.this.addContext(url);
        }

        @Override
        public String handleResource(String bundleName, String resourceName, String resourceKey, String resourceExtension, LocalResource resource) {
            Object url = ClientBundleFactory.this.construct(bundleName, resourceName, resourceKey, resourceExtension);
            String existingUrl = ClientBundleFactory.this._resourceToUrl.get(resource);
            if (existingUrl != null) {
                ClientBundleFactory.this._urlToResource.remove(existingUrl);
            }
            ClientBundleFactory.this._resourceToUrl.put(resource, (String)url);
            ClientBundleFactory.this._urlToResource.put((String)url, resource);
            if (ClientBundleFactory.this._pattern != null) {
                url = ClientBundleFactory.this._pattern.replaceAll("\\{\\}", (String)url);
            }
            if (ClientBundleFactory.this._prefix != null) {
                url = ClientBundleFactory.this._prefix + (String)url;
            }
            if (ClientBundleFactory.this._contextPath != null) {
                url = ClientBundleFactory.this._contextPath + (String)url;
            }
            return url;
        }

        @Override
        public File getTempDir() {
            return ClientBundleFactory.this._tempDir;
        }
    }
}

