/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.onebusaway.presentation.impl.resources.ClientBundleFactory;
import org.onebusaway.presentation.impl.resources.LocalResource;

public class ClientBundleServlet
extends HttpServlet {
    private static final String INIT_PARAM_RESOURCE = "resource:";
    private static final String INIT_PARAM_PREFIX = "prefix";
    private static final long serialVersionUID = 1L;
    private ClientBundleFactory _factory = new ClientBundleFactory();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.loadResources(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String remoteURL = req.getServletPath() + req.getPathInfo();
        LocalResource resource = this._factory.getResourceForExternalUrl(remoteURL);
        if (resource != null) {
            this.writeResponseFromResource(resp, resource);
        } else {
            resp.sendError(404);
        }
    }

    private void loadResources(ServletConfig config) {
        ServletContext servletContext = config.getServletContext();
        this._factory.setServletContext(servletContext);
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = config.getInitParameter(name);
            if (INIT_PARAM_PREFIX.equals(name)) {
                this._factory.setPrefix(value);
                continue;
            }
            if (!name.startsWith(INIT_PARAM_RESOURCE)) continue;
            String resourceName = name.substring(INIT_PARAM_RESOURCE.length());
            try {
                Class<?> resourceType = Class.forName(value);
                this._factory.addResource(resourceType);
            }
            catch (ClassNotFoundException ex) {
                servletContext.log("error loading resource name=" + resourceName + " type=" + value, (Throwable)ex);
            }
            catch (IOException ex) {
                servletContext.log("error creating resource name=" + resourceName + " type=" + value, (Throwable)ex);
            }
        }
        servletContext.setAttribute("resources", this._factory.getBundles());
    }

    private void writeResponseFromResource(HttpServletResponse resp, LocalResource resource) throws IOException {
        int rc;
        resp.setDateHeader("Last-Modified", resource.getLastModifiedTime());
        ServletOutputStream out = resp.getOutputStream();
        URL localUrl = resource.getLocalUrl();
        InputStream in = localUrl.openStream();
        byte[] buffer = new byte[1024];
        while ((rc = in.read(buffer)) != -1) {
            out.write(buffer, 0, rc);
        }
        in.close();
        out.close();
    }
}

