/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.resources;

import com.google.gwt.resources.client.CssResource;
import com.steadystate.css.parser.SACParserCSS2;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.regex.Pattern;
import org.onebusaway.presentation.impl.resources.ClientBundleContext;
import org.onebusaway.presentation.impl.resources.ClientBundleImpl;
import org.onebusaway.presentation.impl.resources.CssDocumentHandlerImpl;
import org.onebusaway.presentation.impl.resources.LocalResource;
import org.onebusaway.presentation.impl.resources.ResourcePrototypeImpl;
import org.onebusaway.presentation.impl.resources.ResourceSupport;
import org.onebusaway.presentation.impl.resources.ResourceWithUrl;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;

public class CssResourceImpl
extends ResourcePrototypeImpl
implements CssResource,
ResourceWithUrl,
LocalResource,
InvocationHandler {
    static Pattern URL_PATTERN = Pattern.compile("^@url (\\w+) (\\w+);$");
    private URL _cssUrl;
    private File _outputFile;
    private String _outputText;
    private String _outputUrl;

    public CssResourceImpl(ClientBundleContext context, ClientBundleImpl parentBundle, String name, URL cssUrl) {
        super(context, parentBundle, name);
        this._cssUrl = cssUrl;
    }

    public boolean ensureInjected() {
        return false;
    }

    public String getText() {
        this.refresh();
        return this._outputText;
    }

    @Override
    public String getUrl() {
        this.refresh();
        return this._outputUrl;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<CssResourceImpl> declaringClass = method.getDeclaringClass();
        if (declaringClass.isAssignableFrom(CssResourceImpl.class)) {
            return method.invoke((Object)this, args);
        }
        String name = method.getName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    @Override
    protected synchronized void refresh() {
        if (this.isUpToDate()) {
            return;
        }
        System.out.println("refreshing resource: " + this._cssUrl);
        try {
            this._outputText = this.parse();
            String key = ResourceSupport.getHash(this._outputText);
            this._outputUrl = this.constructURL(key, "css", this);
            this._outputFile = new File(this._context.getTempDir(), this.cleanUrlForPath(this._outputUrl));
            this._localUrl = this._outputFile.toURI().toURL();
            File parent = this._outputFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(this._outputFile));
            writer.write(this._outputText);
            writer.close();
            this.setUpToDate();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String parse() throws IOException {
        InputStreamReader reader2 = new InputStreamReader(this._cssUrl.openStream());
        InputSource source2 = new InputSource((Reader)reader2);
        SACParserCSS2 p = new SACParserCSS2();
        CssDocumentHandlerImpl handler = new CssDocumentHandlerImpl(this._context, this._parentBundle);
        p.setDocumentHandler((DocumentHandler)handler);
        p.parseStyleSheet(source2);
        reader2.close();
        return handler.getResults();
    }

    private String cleanUrlForPath(String url) {
        url = url.replace('?', '_');
        return url;
    }
}

