/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.resources;

import com.steadystate.css.parser.SACParserCSS2;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import java.util.regex.Pattern;
import org.onebusaway.presentation.impl.resources.CssDocumentHandler;
import org.onebusaway.presentation.impl.resources.ResourceTransformationStrategy;
import org.onebusaway.presentation.services.resources.ResourceService;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;

public class CssResourceTransformationStrategy
implements ResourceTransformationStrategy {
    static Pattern URL_PATTERN = Pattern.compile("^@url (\\w+) (\\w+);$");
    private Locale _locale;

    public CssResourceTransformationStrategy(Locale locale) {
        this._locale = locale;
    }

    @Override
    public boolean requiresTransformation() {
        return true;
    }

    @Override
    public void transformResource(ResourceService resourceService, URL sourceResource, File targetResource) {
        try {
            String outputText = this.parse(resourceService, sourceResource);
            BufferedWriter writer = new BufferedWriter(new FileWriter(targetResource));
            writer.write(outputText);
            writer.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String parse(ResourceService resourceService, URL url) throws IOException {
        InputStreamReader reader2 = new InputStreamReader(url.openStream());
        InputSource source2 = new InputSource((Reader)reader2);
        SACParserCSS2 p = new SACParserCSS2();
        CssDocumentHandler handler = new CssDocumentHandler(resourceService, this._locale);
        p.setDocumentHandler((DocumentHandler)handler);
        p.parseStyleSheet(source2);
        reader2.close();
        return handler.getResults();
    }
}

