/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.resources;

import com.opensymphony.xwork2.ActionSupport;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.onebusaway.presentation.services.resources.Resource;
import org.onebusaway.presentation.services.resources.ResourceService;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(type="stream"), @Result(type="httpheader", name={"NotFound"}, params={"status", "404"})})
public class ResourceAction
extends ActionSupport {
    private static final long serialVersionUID = 1L;
    private ResourceService _resourceService;
    protected String _id;
    private Resource _resource;

    @Autowired
    public void setResourceService(ResourceService resourceService) {
        this._resourceService = resourceService;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public InputStream getInputStream() throws IOException {
        if (this._resource == null) {
            return null;
        }
        URL localUrl = this._resource.getLocalUrl();
        return localUrl.openStream();
    }

    public String getContentType() {
        if (this._resource == null) {
            return null;
        }
        URL localUrl = this._resource.getLocalUrl();
        String path = localUrl.getPath();
        if (path.endsWith(".png")) {
            return "image/png";
        }
        if (path.endsWith(".css")) {
            return "text/css";
        }
        if (path.endsWith(".js")) {
            return "text/javascript";
        }
        if (path.endsWith(".mp3")) {
            return "audio/mpeg";
        }
        return null;
    }

    public long getContentLength() {
        if (this._resource == null) {
            return -1L;
        }
        return this._resource.getContentLength();
    }

    public String getContentDisposition() {
        return "";
    }

    public Date getLastModified() {
        this.ensureResource();
        if (this._resource == null) {
            return null;
        }
        return new Date(this._resource.getLastModifiedTime());
    }

    public String execute() throws Exception {
        this.ensureResource();
        if (this._resource == null) {
            return "NotFound";
        }
        return "success";
    }

    protected void ensureResource() {
        if (this._resource == null) {
            if (this._id == null) {
                HttpServletRequest request = ServletActionContext.getRequest();
                this._id = request.getParameter("id");
            }
            this._resource = this._resourceService.getLocalResourceForExternalId(this._id, this.getLocale());
        }
    }
}

