/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.routes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onebusaway.presentation.impl.AgencyAndRouteComparator;
import org.onebusaway.presentation.impl.RouteComparator;
import org.onebusaway.presentation.services.routes.RouteListService;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.util.services.configuration.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RouteListServiceImpl
implements RouteListService {
    @Autowired
    private ConfigurationService _configurationService;
    @Autowired
    private TransitDataService _transitDataService;

    @Override
    public boolean getShowAgencyNames() {
        return Boolean.parseBoolean(this._configurationService.getConfigurationValueAsString("display.showAgencyNames", "false"));
    }

    @Override
    public boolean getUseAgencyId() {
        return Boolean.parseBoolean(this._configurationService.getConfigurationValueAsString("display.useAgencyId", "false"));
    }

    @Override
    public List<RouteBean> getFilteredRoutes(String agencyFilter) {
        ArrayList<RouteBean> filteredRoutes = new ArrayList<RouteBean>();
        List agencies = this._transitDataService.getAgenciesWithCoverage();
        for (AgencyWithCoverageBean agency : agencies) {
            if (!agencyFilter.equals(agency.getAgency().getId())) continue;
            filteredRoutes.addAll(this._transitDataService.getRoutesForAgencyId(agency.getAgency().getId()).getList());
        }
        return filteredRoutes;
    }

    @Override
    public List<RouteBean> getRoutes() {
        ArrayList<RouteBean> allRoutes = new ArrayList<RouteBean>();
        List agencies = this._transitDataService.getAgenciesWithCoverage();
        for (AgencyWithCoverageBean agency : agencies) {
            allRoutes.addAll(this._transitDataService.getRoutesForAgencyId(agency.getAgency().getId()).getList());
        }
        Collections.sort(allRoutes, this.getShowAgencyNames() ? new AgencyAndRouteComparator() : new RouteComparator());
        return allRoutes;
    }
}

