/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.search;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.presentation.services.search.SearchResultFactory;
import org.onebusaway.transit_data.model.service_alerts.NaturalLanguageStringBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;

public abstract class AbstractSearchResultFactoryImpl
implements SearchResultFactory {
    protected void populateServiceAlerts(Set<String> serviceAlertDescriptions, List<ServiceAlertBean> serviceAlertBeans) {
        this.populateServiceAlerts(serviceAlertDescriptions, serviceAlertBeans, true);
    }

    protected void populateServiceAlerts(Set<String> serviceAlertDescriptions, List<ServiceAlertBean> serviceAlertBeans, boolean htmlizeNewlines) {
        if (serviceAlertBeans == null) {
            return;
        }
        for (ServiceAlertBean serviceAlertBean : serviceAlertBeans) {
            boolean descriptionsAdded = false;
            descriptionsAdded = this.setDescription(serviceAlertDescriptions, serviceAlertBean.getSummaries(), serviceAlertBean.getDescriptions(), serviceAlertBean.getUrls(), htmlizeNewlines) || this.setDescription(serviceAlertDescriptions, serviceAlertBean.getSummaries(), serviceAlertBean.getUrls(), htmlizeNewlines);
            if (descriptionsAdded) continue;
            serviceAlertDescriptions.add("(no description)");
        }
    }

    protected void populateServiceAlerts(List<NaturalLanguageStringBean> serviceAlertDescriptions, List<ServiceAlertBean> serviceAlertBeans, boolean htmlizeNewlines) {
        HashSet<String> d = new HashSet<String>();
        this.populateServiceAlerts(d, serviceAlertBeans, htmlizeNewlines);
        for (String s : d) {
            serviceAlertDescriptions.add(new NaturalLanguageStringBean(s, "EN"));
        }
    }

    protected void populateServiceAlerts(List<NaturalLanguageStringBean> serviceAlertDescriptions, List<ServiceAlertBean> serviceAlertBeans) {
        this.populateServiceAlerts(serviceAlertDescriptions, serviceAlertBeans, true);
    }

    private boolean setDescription(Set<String> serviceAlertDescriptions, List<NaturalLanguageStringBean> descriptions, List<NaturalLanguageStringBean> urls, boolean htmlizeNewlines) {
        boolean descriptionsAdded = false;
        if (descriptions != null) {
            for (int i = 0; i < descriptions.size(); ++i) {
                NaturalLanguageStringBean description = descriptions.get(i);
                if (description.getValue() == null || description.getValue().isEmpty()) continue;
                StringBuffer text = new StringBuffer();
                if (htmlizeNewlines) {
                    if (urls != null && urls.size() > i) {
                        text.append("<a href='");
                        text.append(urls.get(i).getValue());
                        text.append("' target='_blank'>");
                    }
                    text.append(description.getValue().replace("\n", "<br/>"));
                    if (urls != null && urls.size() > i) {
                        text.append("</a>");
                    }
                } else {
                    text.append(description.getValue());
                }
                serviceAlertDescriptions.add(text.toString());
                descriptionsAdded = true;
            }
        }
        return descriptionsAdded;
    }

    private boolean setDescription(Set<String> serviceAlertDescriptions, List<NaturalLanguageStringBean> summaries, List<NaturalLanguageStringBean> descriptions, List<NaturalLanguageStringBean> urls, boolean htmlizeNewlines) {
        int i;
        boolean descriptionsAdded = false;
        if (summaries != null) {
            if (summaries.size() > 0 && descriptions != null && descriptions.size() == summaries.size()) {
                for (i = 0; i < summaries.size(); ++i) {
                    StringBuffer text = new StringBuffer();
                    boolean foundSummary = false;
                    NaturalLanguageStringBean summary = summaries.get(0);
                    NaturalLanguageStringBean description = descriptions.get(0);
                    if (urls != null && urls.size() > i) {
                        text.append("<a href='");
                        text.append(urls.get(i).getValue());
                        text.append("' target='_blank'>");
                    }
                    if (summary.getValue() != null && !summary.getValue().isEmpty()) {
                        foundSummary = true;
                        text.append("<strong>");
                        if (htmlizeNewlines) {
                            text.append(summary.getValue());
                        }
                    }
                    if (description.getValue() != null && !description.getValue().isEmpty()) {
                        if (foundSummary && htmlizeNewlines) {
                            text.append("</strong><br/><br/>");
                        }
                        text.append(description.getValue());
                    } else if (foundSummary && htmlizeNewlines) {
                        text.append("</strong>");
                    }
                    if (urls != null && urls.size() > i) {
                        text.append("</a>");
                    }
                    serviceAlertDescriptions.add(htmlizeNewlines ? text.toString().replace("\n", "<br/>") : text.toString());
                    descriptionsAdded = true;
                }
            }
            if (descriptionsAdded) {
                return descriptionsAdded;
            }
            for (i = 0; i < summaries.size(); ++i) {
                NaturalLanguageStringBean summary = summaries.get(i);
                if (summary.getValue() == null || summary.getValue().isEmpty()) continue;
                StringBuilder text = new StringBuilder();
                if (urls != null && urls.size() > i) {
                    text.append("<a href='");
                    text.append(urls.get(i).getValue());
                    text.append("' target='_blank'>");
                }
                text.append(summary.getValue());
                if (urls != null && urls.size() > i) {
                    text.append("</a>");
                }
                serviceAlertDescriptions.add((String)(htmlizeNewlines ? "<strong>" + summary.getValue().replace("\n", "<br/>") + "</strong>" : text.toString()));
                descriptionsAdded = true;
            }
        }
        if (descriptions != null) {
            for (i = 0; i < descriptions.size(); ++i) {
                NaturalLanguageStringBean description = descriptions.get(i);
                if (description.getValue() == null || description.getValue().isEmpty()) continue;
                StringBuilder text = new StringBuilder();
                if (urls != null && urls.size() > i) {
                    text.append("<a href='");
                    text.append(urls.get(i).getValue());
                    text.append("' target='_blank'>");
                }
                text.append(description.getValue());
                if (urls != null && urls.size() > i) {
                    text.append("</a>");
                }
                serviceAlertDescriptions.add(htmlizeNewlines ? description.getValue().replace("\n", "<br/>") : text.toString());
                descriptionsAdded = true;
            }
        }
        return descriptionsAdded;
    }
}

