/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.service_alerts;

import java.util.Comparator;
import java.util.List;
import org.onebusaway.collections.CollectionsLibrary;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.TimeRangeBean;

public class RecentSituationComparator
implements Comparator<ServiceAlertBean> {
    @Override
    public int compare(ServiceAlertBean o1, ServiceAlertBean o2) {
        long t1 = this.getTimeForSituation(o1);
        long t2 = this.getTimeForSituation(o2);
        return Double.compare(t1, t2);
    }

    private long getTimeForSituation(ServiceAlertBean bean) {
        long t = this.getFirstTime(bean.getPublicationWindows());
        if (t != Long.MAX_VALUE) {
            return t;
        }
        t = this.getFirstTime(bean.getActiveWindows());
        if (t != Long.MAX_VALUE) {
            return t;
        }
        return bean.getCreationTime();
    }

    private long getFirstTime(List<TimeRangeBean> windows) {
        long min = Long.MAX_VALUE;
        if (!CollectionsLibrary.isEmpty(windows)) {
            for (TimeRangeBean window : windows) {
                if (window.getFrom() == 0L) continue;
                min = Math.min(min, window.getFrom());
            }
        }
        return min;
    }
}

