/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.onebusaway.presentation.services.text.TextModification;

public class ReplacementTextModification
implements TextModification {
    private String _from;
    private String _to;
    private boolean _atWordBoundary = true;
    private Pattern _pattern;
    private boolean _caseSensistive = false;

    public void setFrom(String from) {
        this._from = from;
        this.buildPattern();
    }

    public void setTo(String to) {
        this._to = to;
    }

    public void setAtWordBoundary(boolean atWordBoundary) {
        this._atWordBoundary = atWordBoundary;
        this.buildPattern();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensistive = caseSensitive;
        this.buildPattern();
    }

    @Override
    public String modify(String input) {
        Matcher matcher = this._pattern.matcher(input);
        return matcher.replaceAll(this._to);
    }

    private void buildPattern() {
        if (this._from == null) {
            return;
        }
        try {
            Object from = this._from;
            if (this._atWordBoundary) {
                from = "\\b" + (String)from + "\\b";
            }
            int flags = this._caseSensistive ? 0 : 2;
            this._pattern = Pattern.compile((String)from, flags);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("invalid replacement regular expression: " + this._from, ex);
        }
    }
}

