/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.transit_data;

import javax.annotation.PostConstruct;
import net.sf.ehcache.Cache;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.onebusaway.container.cache.CacheableMethodManager;
import org.onebusaway.container.cache.CacheableObjectKeyFactory;
import org.onebusaway.presentation.impl.transit_data.ArrivalsAndDeparturesQueryBeanCacheableObjectKeyFactory;
import org.onebusaway.transit_data.model.ArrivalsAndDeparturesQueryBean;

@Aspect
public class TransitDataServiceCachingInterceptor
extends CacheableMethodManager {
    private int _arrivalAndDepartureCacheWindow = 30;
    private int _arrivalAndDepartureCacheSize = 5000;

    @PostConstruct
    public void setup() {
        this._cacheableMethodKeyFactoryManager.addCacheableObjectKeyFactory(ArrivalsAndDeparturesQueryBean.class, (CacheableObjectKeyFactory)new ArrivalsAndDeparturesQueryBeanCacheableObjectKeyFactory(this._arrivalAndDepartureCacheWindow));
    }

    public void setArrivalAndDepartureCacheWindow(int arrivalAndDepartureCacheWindow) {
        this._arrivalAndDepartureCacheWindow = arrivalAndDepartureCacheWindow;
    }

    public void setArrivalAndDepartureCacheSize(int arrivalAndDepartureCacheSize) {
        this._arrivalAndDepartureCacheSize = arrivalAndDepartureCacheSize;
    }

    @Around(value="execution(* org.onebusaway.transit_data.services.TransitDataService.getRoute(..))")
    public Object getRoute(ProceedingJoinPoint pjp) throws Throwable {
        return this.evaluate(pjp);
    }

    @Around(value="execution(* org.onebusaway.transit_data.services.TransitDataService.getStop(..))")
    public Object getStop(ProceedingJoinPoint pjp) throws Throwable {
        return this.evaluate(pjp);
    }

    @Around(value="execution(* org.onebusaway.transit_data.services.TransitDataService.getStopsForRoute(..))")
    public Object getStopsForRoute(ProceedingJoinPoint pjp) throws Throwable {
        return this.evaluate(pjp);
    }

    @Around(value="execution(* org.onebusaway.transit_data.services.TransitDataService.getSingleTripDetails(..))")
    public Object getSingleTripDetails(ProceedingJoinPoint pjp) throws Throwable {
        return this.evaluate(pjp);
    }

    @Around(value="execution(* org.onebusaway.transit_data.services.TransitDataService.getStopWithArrivalsAndDepartures(..))")
    public Object getStopWithArrivalsAndDepartures(ProceedingJoinPoint pjp) throws Throwable {
        return this.evaluate(pjp);
    }

    protected Cache createCache(ProceedingJoinPoint pjp, String name) {
        if (name.equals("org.onebusaway.transit_data.services.TransitDataService.getStopWithArrivalsAndDepartures")) {
            return new Cache(name, this._arrivalAndDepartureCacheSize, true, false, (long)this._arrivalAndDepartureCacheWindow, (long)this._arrivalAndDepartureCacheWindow);
        }
        return new Cache(name, 1000, true, false, 3600L, 3600L);
    }
}

