/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.users;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.util.UUID;
import org.onebusaway.presentation.impl.users.XWorkRequestAttributes;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class RequestContextInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private static final String KEY_SESSION_ID = RequestContextInterceptor.class.getName() + ".sessionId";

    public String intercept(ActionInvocation invocation) throws Exception {
        ActionContext context = invocation.getInvocationContext();
        String id = this.getSessionId(context);
        XWorkRequestAttributes attributes = new XWorkRequestAttributes(context, id);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        String result = invocation.invoke();
        RequestContextHolder.resetRequestAttributes();
        attributes.requestCompleted();
        return result;
    }

    private String getSessionId(ActionContext context) {
        String id = (String)context.getSession().get(KEY_SESSION_ID);
        if (id == null) {
            UUID uuid = UUID.randomUUID();
            id = uuid.toString();
            context.getSession().put(KEY_SESSION_ID, id);
        }
        return id;
    }
}

