/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onebusaway.presentation.model.SearchResult;
import org.onebusaway.transit_data.model.RouteBean;

public class SearchResultCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Class<? extends SearchResult> _resultType = null;
    private List<SearchResult> _matches = new ArrayList<SearchResult>();
    private List<SearchResult> _suggestions = new ArrayList<SearchResult>();
    private Set<RouteBean> _routeFilter = new HashSet<RouteBean>();
    private Double _queryLat = null;
    private Double _queryLon = null;
    private Boolean _isGeocode = false;
    private String _hint = "not set";

    public void addMatch(SearchResult thing) throws IllegalArgumentException {
        if (this._resultType == null) {
            this._resultType = thing.getClass();
        }
        if (!this._resultType.isInstance(thing)) {
            throw new IllegalArgumentException("All results must be of type " + this._resultType);
        }
        this._matches.add(thing);
    }

    public void addSuggestion(SearchResult thing) throws IllegalArgumentException {
        if (this._resultType == null) {
            this._resultType = thing.getClass();
        }
        if (!this._resultType.isInstance(thing)) {
            throw new IllegalArgumentException("All results must be of type " + this._resultType);
        }
        this._suggestions.add(thing);
    }

    public void addRouteFilter(RouteBean route) {
        this._routeFilter.add(route);
    }

    public void addRouteFilters(Set<RouteBean> routes) {
        this._routeFilter.addAll(routes);
    }

    public boolean isEmpty() {
        return this._matches.size() + this._suggestions.size() == 0;
    }

    public List<SearchResult> getMatches() {
        return this._matches;
    }

    public Set<RouteBean> getRouteFilter() {
        return this._routeFilter;
    }

    public List<SearchResult> getSuggestions() {
        return this._suggestions;
    }

    public String getResultType() {
        if (this._resultType != null) {
            return this._resultType.getSimpleName();
        }
        return null;
    }

    public Double getQueryLat() {
        return this._queryLat;
    }

    public void setQueryLat(Double queryLat) {
        this._queryLat = queryLat;
    }

    public Double getQueryLon() {
        return this._queryLon;
    }

    public void setQueryLon(Double queryLon) {
        this._queryLon = queryLon;
    }

    public void setGeocode(Boolean isGeocode) {
        this._isGeocode = isGeocode;
    }

    public Boolean getIsGeocode() {
        return this._isGeocode;
    }

    public void setHint(String hint) {
        this._hint = hint;
    }

    public String getHint() {
        return this._hint;
    }

    public String toString() {
        return "{matches=" + this._matches + ", suggestions=" + this._suggestions + ", routeFilter=" + this._routeFilter + "}";
    }
}

