/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.transit_data.model.NameBean;
import org.onebusaway.transit_data.model.StopBean;

public class StopSelectionTreeBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StopBean _stop = null;
    private Map<NameBean, StopSelectionTreeBean> _branches = new LinkedHashMap<NameBean, StopSelectionTreeBean>();

    public void setStop(StopBean stop) {
        if (this._stop != null && !this._stop.equals((Object)stop)) {
            throw new IllegalStateException("Stop bean already set!");
        }
        this._stop = stop;
    }

    public Set<NameBean> getNames() {
        return this._branches.keySet();
    }

    public boolean hasStop() {
        return this._stop != null;
    }

    public StopBean getStop() {
        return this._stop;
    }

    public StopSelectionTreeBean getSubTree(NameBean name) {
        StopSelectionTreeBean tree = this._branches.get(name);
        if (tree == null) {
            tree = new StopSelectionTreeBean();
            this._branches.put(name, tree);
        }
        return tree;
    }

    public void moveSubTreeToBack(NameBean name) {
        if (this._branches.containsKey(name)) {
            StopSelectionTreeBean branch = this._branches.remove(name);
            this._branches.put(name, branch);
        }
    }

    public List<StopBean> getAllStops() {
        ArrayList<StopBean> stops = new ArrayList<StopBean>();
        this.getAllStopsRecursive(stops);
        return stops;
    }

    public String toString() {
        return this.toStringRecursive("");
    }

    private void getAllStopsRecursive(List<StopBean> stops) {
        if (this._stop != null) {
            stops.add(this._stop);
        }
        for (StopSelectionTreeBean tree : this._branches.values()) {
            tree.getAllStopsRecursive(stops);
        }
    }

    private String toStringRecursive(String prefix) {
        if (this.hasStop()) {
            return prefix + this.getStop().getName();
        }
        StringBuilder b = new StringBuilder();
        for (NameBean name : this.getNames()) {
            if (b.length() > 0) {
                b.append('\n');
            }
            b.append(prefix).append(name.getName()).append('\n');
            b.append(this.getSubTree(name).toStringRecursive(prefix + "  "));
        }
        return b.toString();
    }
}

