/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.services.cachecontrol;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.struts2.ServletActionContext;
import org.onebusaway.presentation.services.cachecontrol.CacheControl;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheControlInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private static Logger _log = LoggerFactory.getLogger(CacheControlInterceptor.class);

    public String intercept(ActionInvocation invocation) throws Exception {
        String modifiedSinceValue;
        CacheControl cacheControl = this.getCacheControlAnnotation(invocation);
        if (cacheControl == null) {
            return invocation.invoke();
        }
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.applyCacheControlHeader(invocation, cacheControl, request, response);
        this.applyExpiresHeader(invocation, cacheControl, request, response);
        this.applyETagHeader(invocation, cacheControl, request, response);
        Date lastModifiedTime = this.applyLastModifiedHeader(invocation, cacheControl, request, response);
        Map<String, String> requestCacheControl = this.parseRequestCacheControl(request);
        boolean bypassCache = this.bypassCache(requestCacheControl);
        if (lastModifiedTime != null && !bypassCache && (modifiedSinceValue = request.getHeader("if-modified-since")) != null) {
            try {
                Date modifiedSince = DateUtil.parseDate((String)modifiedSinceValue);
                if (!lastModifiedTime.after(modifiedSince)) {
                    response.setStatus(304);
                    return null;
                }
            }
            catch (DateParseException dateParseException) {
                // empty catch block
            }
        }
        String method = request.getMethod();
        if (cacheControl.shortCircuit() && "HEAD".equals(method)) {
            return null;
        }
        return invocation.invoke();
    }

    private boolean bypassCache(Map<String, String> requestCacheControl) {
        return requestCacheControl.containsKey("no-cache");
    }

    private Map<String, String> parseRequestCacheControl(HttpServletRequest request) {
        String value = request.getHeader("cache-control");
        if (value == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> m = new HashMap<String, String>();
        for (String kvp : value.split(",")) {
            if ((kvp = kvp.trim()).length() == 0) continue;
            int index = kvp.indexOf(61);
            if (index == -1) {
                m.put(kvp.toLowerCase(), null);
                continue;
            }
            String key = kvp.substring(0, index).toLowerCase();
            m.put(key, kvp.substring(index + 1));
        }
        return m;
    }

    private void applyCacheControlHeader(ActionInvocation invocation, CacheControl cacheControl, HttpServletRequest request, HttpServletResponse response) {
        StringBuilder b = new StringBuilder();
        if (cacheControl.isPublic()) {
            CacheControlInterceptor.delimiter(b);
            b.append("public");
        }
        if (cacheControl.isPrivate()) {
            CacheControlInterceptor.delimiter(b);
            b.append("private");
        }
        if (cacheControl.noCache()) {
            CacheControlInterceptor.delimiter(b);
            b.append("no-cache");
        }
        if (cacheControl.noStore()) {
            CacheControlInterceptor.delimiter(b);
            b.append("no-store");
        }
        if (cacheControl.noTransform()) {
            CacheControlInterceptor.delimiter(b);
            b.append("no-transform");
        }
        if (cacheControl.maxAge() != -1) {
            CacheControlInterceptor.delimiter(b);
            b.append("max-age=").append(cacheControl.maxAge());
        }
        if (cacheControl.sharedMaxAge() != -1) {
            CacheControlInterceptor.delimiter(b);
            b.append("s-maxage=").append(cacheControl.sharedMaxAge());
        }
        if (b.length() > 0) {
            response.setHeader("Cache-Control", b.toString());
        }
    }

    private void applyExpiresHeader(ActionInvocation invocation, CacheControl cacheControl, HttpServletRequest request, HttpServletResponse response) {
        Date expiresTime = null;
        expiresTime = cacheControl.expiresOffset() > 0L ? new Date(SystemTime.currentTimeMillis() + cacheControl.expiresOffset()) : this.invokeDateMethod(invocation, cacheControl.expiresMethod());
        if (expiresTime == null) {
            return;
        }
        String expiresTimeAsString = DateUtil.formatDate((Date)expiresTime);
        response.setHeader("Expires", expiresTimeAsString);
    }

    private Date applyLastModifiedHeader(ActionInvocation invocation, CacheControl cacheControl, HttpServletRequest request, HttpServletResponse response) {
        Date lastModifiedTime = this.invokeDateMethod(invocation, cacheControl.lastModifiedMethod());
        if (lastModifiedTime == null) {
            return null;
        }
        String lastModifiedTimeAsString = DateUtil.formatDate((Date)lastModifiedTime);
        response.setHeader("Last-Modified", lastModifiedTimeAsString);
        return lastModifiedTime;
    }

    private void applyETagHeader(ActionInvocation invocation, CacheControl cacheControl, HttpServletRequest request, HttpServletResponse response) {
        String etagMethod = cacheControl.etagMethod();
        if (etagMethod == null || "".equals(etagMethod)) {
            return;
        }
        Object action = invocation.getAction();
        Class<?> actionClass = action.getClass();
        Method m = this.getMethod(actionClass, etagMethod, new Class[0]);
        if (m == null) {
            _log.warn("etagMethod=\"" + etagMethod + "\" not found for actionClass=\"" + actionClass.getName() + "\"");
            return;
        }
        Object result = this.invokeMethod(m, action, new Object[0]);
        if (result == null) {
            return;
        }
        response.setHeader("ETag", result.toString());
    }

    private CacheControl getCacheControlAnnotation(ActionInvocation invocation) {
        Object action = invocation.getAction();
        Class<?> actionClass = action.getClass();
        ActionProxy proxy = invocation.getProxy();
        String methodName = proxy.getMethod();
        if (methodName != null) {
            try {
                CacheControl methodCacheControl;
                Method m = actionClass.getMethod(methodName, new Class[0]);
                if (m != null && (methodCacheControl = m.getAnnotation(CacheControl.class)) != null) {
                    return methodCacheControl;
                }
            }
            catch (Exception ex) {
                _log.warn("error searching for action method=\"" + methodName + "\" on action class=\"" + actionClass.getName() + "\"", (Throwable)ex);
            }
        }
        return actionClass.getAnnotation(CacheControl.class);
    }

    private Date invokeDateMethod(ActionInvocation invocation, String methodName) {
        if (methodName == null || "".equals(methodName)) {
            return null;
        }
        Object action = invocation.getAction();
        Class<?> actionClass = action.getClass();
        Method m = this.getMethod(actionClass, methodName, new Class[0]);
        if (m == null) {
            _log.warn("method=\"" + methodName + "\" not found for actionClass=\"" + actionClass.getName() + "\"");
            return null;
        }
        Object result = this.invokeMethod(m, action, new Object[0]);
        if (result == null) {
            return null;
        }
        if (result instanceof Date) {
            return (Date)result;
        }
        if (result instanceof Long) {
            return new Date((Long)result);
        }
        _log.warn("unknown date value: " + result + " from method=\"" + methodName + "\" in actionClass=" + actionClass.getName());
        return null;
    }

    private static final void delimiter(StringBuilder b) {
        if (b.length() > 0) {
            b.append(", ");
        }
    }

    private Method getMethod(Class<?> actionClass, String methodName, Class<?> ... parameterTypes) {
        try {
            return actionClass.getMethod(methodName, parameterTypes);
        }
        catch (Exception ex) {
            _log.warn("error searching for action method=\"" + methodName + "\" on action class=\"" + actionClass.getName() + "\"", (Throwable)ex);
            return null;
        }
    }

    private Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            _log.warn("error invoking method", (Throwable)ex);
            return null;
        }
    }
}

