/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.services.cachecontrol;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.TimerTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public abstract class CacheService<K, V> {
    private static final int DEFAULT_CACHE_TIMEOUT = 30;
    private static final int STATUS_INTERVAL_MINUTES = 1;
    protected static Logger _log = LoggerFactory.getLogger(CacheService.class);
    protected Cache<K, V> _cache;
    private ScheduledFuture<StatusThread> _statusTask = null;
    @Autowired
    private ThreadPoolTaskScheduler _taskScheduler;
    String addr = "sessions-memcache:11211";
    MemcachedClient memcache;
    protected boolean useMemcached = false;
    protected boolean _disabled = false;

    protected abstract void refreshCache();

    public abstract K hash(Object ... var1);

    public void setUseMemcached(boolean useIt) {
        this.useMemcached = useIt;
    }

    public synchronized void setDisabled(boolean disable) {
        this._disabled = disable;
    }

    public Cache<K, V> getCache() {
        return this.getCache(30, "GENERIC");
    }

    public Cache<K, V> getCache(int timeout, String type) {
        if (this._cache == null) {
            _log.info("creating initial " + type + " cache with timeout " + timeout + "...");
            this._cache = CacheBuilder.newBuilder().expireAfterWrite((long)timeout, TimeUnit.SECONDS).build();
            _log.info("done");
        }
        if (this.memcache == null && this.useMemcached) {
            try {
                this.memcache = new MemcachedClient((ConnectionFactory)new BinaryConnectionFactory(), AddrUtil.getAddresses((String)this.addr));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._disabled) {
            this._cache.invalidateAll();
        }
        return this._cache;
    }

    public V retrieve(K key) {
        if (this._disabled) {
            return null;
        }
        if (this.useMemcached) {
            try {
                return (V)this.memcache.get(key.toString());
            }
            catch (Exception e) {
                this.toggleCache(false);
            }
        }
        return (V)(this.getCache() != null ? this.getCache().getIfPresent(key) : null);
    }

    public void store(K key, V value) {
        this.store(key, value, 30);
    }

    public void store(K key, V value, int timeout) {
        if (this._disabled) {
            return;
        }
        if (this.useMemcached) {
            try {
                this.memcache.set(key.toString(), timeout, value);
                return;
            }
            catch (Exception e) {
                this.toggleCache(false);
            }
        }
        this.getCache().put(key, value);
    }

    public boolean containsKey(K key) {
        if (this._disabled) {
            return false;
        }
        Cache<K, V> cache = this.getCache();
        if (this.useMemcached) {
            try {
                return this.memcache.get(key.toString()) != null;
            }
            catch (Exception e) {
                this.toggleCache(false);
            }
        }
        if (!cache.asMap().containsKey(key)) {
            if (this.memcache != null && !this.memcache.getAvailableServers().isEmpty()) {
                this.toggleCache(true);
            }
            return false;
        }
        return true;
    }

    public boolean hashContainsKey(Object ... factors) {
        return this.containsKey(this.hash(factors));
    }

    public void hashStore(V value, Object ... factors) {
        this.getCache().put(this.hash(factors), value);
    }

    @PostConstruct
    private void startStatusTask() {
        if (this._statusTask == null) {
            if (!this._disabled) {
                this._statusTask = this._taskScheduler.scheduleWithFixedDelay((Runnable)new StatusThread(), 60000L);
            } else {
                this.logStatus();
            }
        }
    }

    public void logStatus() {
        _log.debug(this.getCache().stats().toString() + "; disabled=" + this._disabled + "; useMemcached=" + this.useMemcached + "; Local Size=" + this._cache.size() + "; Memcached Size=" + (this.memcache == null ? "[null]" : this.memcache.getStats("sizes")));
    }

    private void toggleCache(boolean useMemcached) {
        this.useMemcached = useMemcached;
        _log.info("Caching with " + (useMemcached ? "Memcached" : "Local Cache"));
    }

    private class StatusThread
    extends TimerTask {
        private StatusThread() {
        }

        @Override
        public void run() {
            CacheService.this.logStatus();
        }
    }
}

