/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.tags;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.struts2.components.ContextBean;
import org.onebusaway.util.SystemTime;

public class DateComponent
extends ContextBean {
    private static final Logger LOG = LoggerFactory.getLogger(DateComponent.class);
    private String _format;
    private String _dateStyle;
    private String _timeStyle;
    private String _value;
    private String _timeZone;

    public DateComponent(ValueStack stack) {
        super(stack);
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public void setDateStyle(String dateStyle) {
        this._dateStyle = dateStyle;
    }

    public void setTimeStyle(String timeStyle) {
        this._timeStyle = timeStyle;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void setTimeZone(String timeZone) {
        this._timeZone = timeZone;
    }

    public boolean usesBody() {
        return false;
    }

    public boolean end(Writer writer, String body) {
        String v;
        Object obj;
        String format = this.getFormat();
        String dateStyle = this.getDateStyle();
        String timeStyle = this.getTimeStyle();
        if (format == null && dateStyle == null && timeStyle == null) {
            LOG.debug("no \"format\", \"dateStyle\", or \"timeStyle\" property specified for oba:date component", new String[0]);
            return super.end(writer, "");
        }
        if (this._value == null) {
            this._value = "top";
        }
        if ((obj = this.findValue(this._value)) instanceof Long) {
            obj = new Date((Long)obj);
        } else if (obj instanceof String && (v = (String)obj).equals("now")) {
            obj = new Date(SystemTime.currentTimeMillis());
        }
        if (obj instanceof Date) {
            try {
                Date date = (Date)obj;
                DateFormat sdf = this.getFormat(format, dateStyle, timeStyle);
                TimeZone timeZone = this.getTimeZone();
                sdf.setTimeZone(timeZone);
                String name = sdf.format(date);
                writer.write(name);
            }
            catch (Exception e) {
                LOG.error("Could not write out Text tag", (Throwable)e, new String[0]);
            }
        }
        return super.end(writer, "");
    }

    private DateFormat getFormat(String format, String dateStyle, String timeStyle) {
        Locale locale = ActionContext.getContext().getLocale();
        if (format != null) {
            return new SimpleDateFormat(format, locale);
        }
        if (dateStyle != null && timeStyle != null) {
            return DateFormat.getDateTimeInstance(this.getStyleAsValue(dateStyle), this.getStyleAsValue(timeStyle), locale);
        }
        if (dateStyle != null) {
            return DateFormat.getDateInstance(this.getStyleAsValue(dateStyle), locale);
        }
        if (timeStyle != null) {
            return DateFormat.getTimeInstance(this.getStyleAsValue(timeStyle), locale);
        }
        throw new IllegalStateException("no format, dateStyle, or timeStyle specified");
    }

    private int getStyleAsValue(String style) {
        if ("medium".equals(style = style.toLowerCase())) {
            return 2;
        }
        if ("long".equals(style)) {
            return 1;
        }
        return 3;
    }

    private String getFormat() {
        if (this._format == null) {
            return null;
        }
        return this.findStringIfAltSyntax(this._format);
    }

    private String getDateStyle() {
        if (this._dateStyle == null) {
            return null;
        }
        return this.findStringIfAltSyntax(this._dateStyle);
    }

    private String getTimeStyle() {
        if (this._timeStyle == null) {
            return null;
        }
        return this.findStringIfAltSyntax(this._timeStyle);
    }

    private TimeZone getTimeZone() {
        TimeZone tz = null;
        if (this._timeZone != null) {
            tz = this.getTimeZoneForExpression(this._timeZone);
        }
        if (tz == null) {
            tz = this.getTimeZoneForExpression("timeZone");
        }
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        return tz;
    }

    private TimeZone getTimeZoneForExpression(String expression) {
        TimeZone tz;
        Object timeZone = this.findValue(expression);
        if (timeZone instanceof TimeZone) {
            return (TimeZone)timeZone;
        }
        if (timeZone instanceof String && (tz = TimeZone.getTimeZone((String)timeZone)) != null) {
            return tz;
        }
        return null;
    }
}

