/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.tags;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import org.apache.struts2.components.ContextBean;
import org.onebusaway.users.impl.PhoneNumberLibrary;

public class PhoneNumberComponent
extends ContextBean {
    private static final Logger LOG = LoggerFactory.getLogger(PhoneNumberComponent.class);
    private String _value;

    public PhoneNumberComponent(ValueStack stack) {
        super(stack);
    }

    public void setValue(String value) {
        this._value = value;
    }

    public boolean usesBody() {
        return false;
    }

    public boolean end(Writer writer, String body) {
        Object obj;
        if (this._value == null) {
            this._value = "top";
        }
        if ((obj = this.findValue(this._value)) instanceof String) {
            String number = this.formatPhoneNumber((String)obj);
            try {
                writer.write(number);
            }
            catch (IOException e) {
                LOG.error("Could not write out Text tag", (Throwable)e, new String[0]);
            }
        }
        return super.end(writer, "");
    }

    private String formatPhoneNumber(String number) {
        String[] segments = PhoneNumberLibrary.segmentPhoneNumber((String)number);
        StringBuilder b = new StringBuilder();
        for (String segment : segments) {
            if (b.length() > 0) {
                b.append('-');
            }
            b.append(segment);
        }
        return b.toString();
    }
}

