/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.tags;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.apache.struts2.components.ContextBean;
import org.onebusaway.presentation.services.resources.ResourceService;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourceUrlComponent
extends ContextBean {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUrlComponent.class);
    private ResourceService _resourceService;
    private String _value;

    public ResourceUrlComponent(ValueStack stack) {
        super(stack);
    }

    @Autowired
    public void setResourceService(ResourceService resourceService) {
        this._resourceService = resourceService;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public boolean end(Writer writer, String body) {
        String url;
        if (this._value == null) {
            this._value = "top";
        }
        String value = this.findStringIfAltSyntax(this._value);
        Locale locale = Locale.getDefault();
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null) {
            locale = ctx.getLocale();
        }
        if ((url = this._resourceService.getExternalUrlForResource(value, locale)) != null) {
            if (this.getVar() != null) {
                this.putInContext(url);
            } else {
                try {
                    writer.write(url);
                }
                catch (IOException e) {
                    LOG.error("Could not write out resource-url tag", (Throwable)e, new String[0]);
                }
            }
        }
        return super.end(writer, "");
    }
}

