/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.tags;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import org.apache.struts2.components.ContextBean;
import org.onebusaway.presentation.client.RoutePresenter;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.trips.TripBean;

public class RouteNameComponent
extends ContextBean {
    private static final Logger LOG = LoggerFactory.getLogger(RouteNameComponent.class);
    private String _value;

    public RouteNameComponent(ValueStack stack) {
        super(stack);
    }

    public void setValue(String value) {
        this._value = value;
    }

    public boolean usesBody() {
        return false;
    }

    public boolean end(Writer writer, String body) {
        Object obj;
        if (this._value == null) {
            this._value = "top";
        }
        if ((obj = this.findValue(this._value)) instanceof TripBean) {
            TripBean trip = (TripBean)obj;
            String routeShortName = trip.getRouteShortName();
            if (routeShortName != null) {
                try {
                    writer.write(routeShortName);
                }
                catch (IOException e) {
                    LOG.error("Could not write out Text tag", (Throwable)e, new String[0]);
                }
            } else {
                obj = trip.getRoute();
            }
        }
        if (obj instanceof RouteBean) {
            RouteBean route = (RouteBean)obj;
            String name = RoutePresenter.getNameForRoute(route);
            try {
                writer.write(name);
            }
            catch (IOException e) {
                LOG.error("Could not write out Text tag", (Throwable)e, new String[0]);
            }
        }
        return super.end(writer, "");
    }
}

