/**
 * Copyright (C) 2011 Brian Ferris <bdferris@onebusaway.org>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * 
 */
package org.onebusaway.presentation.impl;

import java.util.Comparator;

import org.onebusaway.presentation.client.RoutePresenter;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.utility.text.NaturalStringOrder;

public class RouteNameComparator implements Comparator<RouteBean> {
  @Override
  public int compare(RouteBean o1, RouteBean o2) {
    String n1 = RoutePresenter.getNameForRoute(o1);
    String n2 = RoutePresenter.getNameForRoute(o2);
    return NaturalStringOrder.compareNatural(n1, n2);
  }
}