/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.client;

import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class UrlBuilder {
    public static final int PORT_UNSPECIFIED = Integer.MIN_VALUE;
    private Map<String, String[]> listParamMap = new HashMap<String, String[]>();
    private String protocol = "http";
    private String host = null;
    private int port = Integer.MIN_VALUE;
    private String path = null;
    private String hash = null;

    public static UrlBuilder createFromLocation() {
        String port;
        String hash;
        UrlBuilder builder = new UrlBuilder();
        builder.setProtocol(Window.Location.getProtocol());
        builder.setHost(Window.Location.getHost());
        String path = Window.Location.getPath();
        if (path != null && path.length() > 0) {
            builder.setPath(path);
        }
        if ((hash = Window.Location.getHash()) != null && hash.length() > 0) {
            builder.setHash(hash);
        }
        if ((port = Window.Location.getPort()) != null && port.length() > 0) {
            builder.setPort(Integer.parseInt(port));
        }
        Map params = Window.Location.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            ArrayList values = new ArrayList((Collection)entry.getValue());
            builder.setParameter((String)entry.getKey(), values.toArray(new String[values.size()]));
        }
        return builder;
    }

    public String buildString() {
        StringBuilder url = new StringBuilder();
        url.append(this.protocol).append("://");
        if (this.host != null) {
            url.append(this.host);
        }
        if (this.port != Integer.MIN_VALUE) {
            url.append(":").append(this.port);
        }
        if (this.path != null && !"".equals(this.path)) {
            url.append("/").append(URL.encode((String)this.path));
        }
        int prefix = 63;
        for (Map.Entry<String, String[]> entry : this.listParamMap.entrySet()) {
            String key = URL.encodeComponent((String)entry.getKey());
            for (String val : entry.getValue()) {
                url.append((char)prefix).append(key).append('=');
                if (val != null) {
                    url.append(URL.encodeComponent((String)val));
                }
                prefix = 38;
            }
        }
        if (this.hash != null) {
            url.append("#").append(this.hash);
        }
        return url.toString();
    }

    public UrlBuilder removeParameter(String name) {
        this.listParamMap.remove(name);
        return this;
    }

    public UrlBuilder setHash(String hash) {
        if (hash != null && hash.startsWith("#")) {
            hash = hash.substring(1);
        }
        this.hash = hash;
        return this;
    }

    public UrlBuilder setHost(String host) {
        if (host != null && host.contains(":")) {
            String[] parts = host.split(":");
            if (parts.length > 2) {
                throw new IllegalArgumentException("Host contains more than one colon: " + host);
            }
            try {
                this.setPort(Integer.parseInt(parts[1]));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse port out of host: " + host);
            }
            host = parts[0];
        }
        this.host = host;
        return this;
    }

    public UrlBuilder setParameter(String key, String ... values) {
        this.assertNotNullOrEmpty(key, "Key cannot be null or empty", false);
        this.assertNotNull(values, "Values cannot null. Try using removeParameter instead.");
        if (values.length == 0) {
            throw new IllegalArgumentException("Values cannot be empty.  Try using removeParameter instead.");
        }
        this.listParamMap.put(key, values);
        return this;
    }

    public UrlBuilder setPath(String path) {
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path;
        return this;
    }

    public UrlBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public UrlBuilder setProtocol(String protocol) {
        this.assertNotNull(protocol, "Protocol cannot be null");
        if (protocol.endsWith("://")) {
            protocol = protocol.substring(0, protocol.length() - 3);
        } else if (protocol.endsWith(":/")) {
            protocol = protocol.substring(0, protocol.length() - 2);
        } else if (protocol.endsWith(":")) {
            protocol = protocol.substring(0, protocol.length() - 1);
        }
        if (protocol.contains(":")) {
            throw new IllegalArgumentException("Invalid protocol: " + protocol);
        }
        this.assertNotNullOrEmpty(protocol, "Protocol cannot be empty", false);
        this.protocol = protocol;
        return this;
    }

    private void assertNotNull(Object value, String message) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private void assertNotNullOrEmpty(String value, String message, boolean isState) throws IllegalArgumentException {
        if (value == null || value.length() == 0) {
            if (isState) {
                throw new IllegalStateException(message);
            }
            throw new IllegalArgumentException(message);
        }
    }
}

