/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onebusaway.presentation.impl.RouteNameComparator;
import org.onebusaway.presentation.model.BookmarkWithStopsBean;
import org.onebusaway.presentation.services.BookmarkPresentationService;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.users.client.model.BookmarkBean;
import org.onebusaway.users.client.model.RouteFilterBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BookmarkPresentationServiceImpl
implements BookmarkPresentationService {
    private TransitDataService _transitDataService;

    @Autowired
    public void setTransitDataService(TransitDataService transitDataService) {
        this._transitDataService = transitDataService;
    }

    @Override
    public List<BookmarkWithStopsBean> getBookmarksWithStops(List<BookmarkBean> bookmarks) {
        ArrayList<BookmarkWithStopsBean> beans = new ArrayList<BookmarkWithStopsBean>(bookmarks.size());
        for (BookmarkBean bookmark : bookmarks) {
            BookmarkWithStopsBean bean = new BookmarkWithStopsBean();
            bean.setId(bookmark.getId());
            bean.setName(bookmark.getName());
            bean.setStops(this.getStopsForStopIds(bookmark.getStopIds()));
            bean.setRoutes(this.getRoutesForRouteFilter(bookmark.getRouteFilter()));
            beans.add(bean);
        }
        return beans;
    }

    @Override
    public String getNameForStopIds(List<String> stopIds) {
        List<StopBean> stops = this.getStopsForStopIds(stopIds);
        return this.getNameForStops(stops);
    }

    @Override
    public String getNameForStops(List<StopBean> stops) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < stops.size(); ++i) {
            if (i > 0) {
                if (i < stops.size() - 1) {
                    b.append(", ");
                } else {
                    b.append(" and ");
                }
            }
            StopBean stop = stops.get(i);
            b.append(stop.getName());
        }
        return b.toString();
    }

    @Override
    public String getNameForBookmark(BookmarkWithStopsBean bookmark) {
        String name = bookmark.getName();
        if (name != null) {
            return name;
        }
        return this.getNameForStops(bookmark.getStops());
    }

    private List<StopBean> getStopsForStopIds(List<String> stopIds) {
        ArrayList<StopBean> stops = new ArrayList<StopBean>(stopIds.size());
        for (String stopId : stopIds) {
            StopBean stop = this._transitDataService.getStop(stopId);
            if (stop == null) continue;
            stops.add(stop);
        }
        return stops;
    }

    private List<RouteBean> getRoutesForRouteFilter(RouteFilterBean routeFilter) {
        ArrayList<RouteBean> routes = new ArrayList<RouteBean>();
        for (String routeId : routeFilter.getRouteIds()) {
            RouteBean route = this._transitDataService.getRouteForId(routeId);
            if (route == null) continue;
            routes.add(route);
        }
        Collections.sort(routes, new RouteNameComparator());
        return routes;
    }
}

