/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl;

import java.util.List;
import javax.annotation.PostConstruct;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.presentation.model.DefaultSearchLocation;
import org.onebusaway.presentation.services.DefaultSearchLocationService;
import org.onebusaway.presentation.services.ServiceAreaService;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceAreaServiceImpl
implements ServiceAreaService {
    private static Logger _log = LoggerFactory.getLogger(ServiceAreaServiceImpl.class);
    private static final double DEFAULT_SEARCH_RADIUS = 20000.0;
    private TransitDataService _transitDataService;
    private DefaultSearchLocationService _defaultSearchLocationService;
    private double _searchRadius = 20000.0;
    private CoordinateBounds _defaultBounds;
    private boolean _calculateDefaultBoundsFromAgencyCoverage = true;

    @Autowired
    public void setTransitDataService(TransitDataService transitDataService) {
        this._transitDataService = transitDataService;
    }

    @Autowired
    public void setDefaultSearchLocationService(DefaultSearchLocationService defaultSearchLocationService) {
        this._defaultSearchLocationService = defaultSearchLocationService;
    }

    public double getSearchRadius() {
        return this._searchRadius;
    }

    public void setSearchRadius(double searchRadius) {
        this._searchRadius = searchRadius;
    }

    public CoordinateBounds getDefaultBounds() {
        return this._defaultBounds;
    }

    public void setDefaultBounds(CoordinateBounds bounds) {
        this._defaultBounds = bounds;
    }

    public void setCalculateDefaultBoundsFromAgencyCoverage(boolean calculateDefaultBoundsFromAgencyCoverage) {
        this._calculateDefaultBoundsFromAgencyCoverage = calculateDefaultBoundsFromAgencyCoverage;
    }

    @PostConstruct
    public void setup() {
        if (this._calculateDefaultBoundsFromAgencyCoverage) {
            BackgroundThread bt = new BackgroundThread(this._transitDataService, this);
            new Thread(bt).start();
        }
    }

    @Override
    public boolean hasDefaultServiceArea() {
        return this._defaultBounds != null;
    }

    @Override
    public CoordinateBounds getServiceArea() {
        DefaultSearchLocation location = this._defaultSearchLocationService.getDefaultSearchLocationForCurrentUser();
        if (location != null) {
            double lat = location.getLat();
            double lon = location.getLon();
            return SphericalGeometryLibrary.bounds((double)lat, (double)lon, (double)this._searchRadius);
        }
        return this._defaultBounds;
    }

    private static class BackgroundThread
    implements Runnable {
        private TransitDataService _tds;
        private ServiceAreaServiceImpl _sas;

        public BackgroundThread(TransitDataService tds, ServiceAreaServiceImpl sas) {
            this._tds = tds;
            this._sas = sas;
        }

        @Override
        public void run() {
            List agenciesWithCoverage = this._tds.getAgenciesWithCoverage();
            CoordinateBounds bounds = new CoordinateBounds();
            for (AgencyWithCoverageBean bean : agenciesWithCoverage) {
                double lat = bean.getLat();
                double lon = bean.getLon();
                double latSpan = bean.getLatSpan() / 2.0;
                double lonSpan = bean.getLonSpan() / 2.0;
                bounds.addPoint(lat - latSpan, lon - lonSpan);
                bounds.addPoint(lat + latSpan, lon + lonSpan);
            }
            if (!bounds.isEmpty()) {
                _log.info("setting default agency bounds to " + bounds);
                this._sas.setDefaultBounds(bounds);
            }
        }
    }
}

