/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl;

import java.util.List;
import org.onebusaway.geocoder.model.GeocoderResult;
import org.onebusaway.geocoder.model.GeocoderResults;
import org.onebusaway.geocoder.services.GeocoderService;
import org.onebusaway.presentation.impl.GeocoderResultPresentationServiceImpl;
import org.onebusaway.presentation.services.DefaultSearchLocationService;
import org.onebusaway.presentation.services.GeocoderResultPresentationService;
import org.onebusaway.presentation.services.SetUserDefaultSearchFromGeocoderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetUserDefaultSearchFromGeocoderServiceImpl
implements SetUserDefaultSearchFromGeocoderService {
    private GeocoderService _geocoderService;
    private DefaultSearchLocationService _searchLocationService;
    private GeocoderResultPresentationService _geocoderResultPresentationService = new GeocoderResultPresentationServiceImpl();

    @Autowired
    public void setGeocoderService(GeocoderService geocoderService) {
        this._geocoderService = geocoderService;
    }

    @Autowired
    public void setSearchLocationService(DefaultSearchLocationService searchLocationService) {
        this._searchLocationService = searchLocationService;
    }

    public void setGeocoderResultPresentationService(GeocoderResultPresentationService service) {
        this._geocoderResultPresentationService = service;
    }

    @Override
    public GeocoderResults setUserDefaultSearchFromGeocoderService(String location) {
        GeocoderResults results = this._geocoderService.geocode(location);
        List records = results.getResults();
        if (records.size() == 1) {
            GeocoderResult result = (GeocoderResult)records.get(0);
            String name = this._geocoderResultPresentationService.getGeocoderResultAsString(result);
            if (name == null || name.length() == 0) {
                name = location;
            }
            this._searchLocationService.setDefaultLocationForCurrentUser(name, result.getLatitude(), result.getLongitude());
        }
        return results;
    }
}

