/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.ValueStack;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;

public class StackInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;

    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        Class<?> actionType = action.getClass();
        AddToStack addToStackAnnotation = actionType.getAnnotation(AddToStack.class);
        if (addToStackAnnotation != null) {
            ValueStack stack = invocation.getStack();
            ArrayList<Object> toPush = new ArrayList<Object>();
            for (String name : addToStackAnnotation.value()) {
                Object value = stack.findValue(name);
                if (value == null) continue;
                toPush.add(value);
            }
            for (Object e : toPush) {
                stack.push(e);
            }
        }
        return invocation.invoke();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface AddToStack {
        public String[] value();
    }
}

