/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.configuration;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.onebusaway.presentation.services.configuration.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigurationInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private ConfigurationService _configurationService;

    @Autowired
    public void setConfigurationService(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        ValueStack stack = invocation.getStack();
        boolean forceRefresh = false;
        Object v = stack.findValue("refreshConfiguration");
        if (v != null) {
            forceRefresh = Boolean.parseBoolean(v.toString());
        }
        HttpServletRequest request = ServletActionContext.getRequest();
        Map<String, Object> configuration = this._configurationService.getConfiguration(forceRefresh, request.getContextPath());
        stack.setValue("#configuration", configuration);
        return invocation.invoke();
    }
}

