/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onebusaway.container.ConfigurationParameter;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.presentation.services.ServiceAreaService;
import org.onebusaway.presentation.services.configuration.ConfigurationSource;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultWebappConfigurationSource
implements ConfigurationSource {
    private TransitDataService _transitDataService;
    private ServiceAreaService _serviceAreaService;
    private String _googleMapsApiKey = "ABQIAAAA1R_R0bUhLYRwbQFpKHVowhR6ggDNEO1rwvdlk5egWeAHsl3o5xT2ki4Fn-LXLHIrJfb8VmKQeIMh5g";
    private String _googleAnalyticsAnalyticsKey = "UA-2423527-7";

    @Autowired
    public void setTransitDataService(TransitDataService transitDataService) {
        this._transitDataService = transitDataService;
    }

    @Autowired
    public void setServiceAreaService(ServiceAreaService serviceAreaService) {
        this._serviceAreaService = serviceAreaService;
    }

    @ConfigurationParameter
    public void setGoogleMapsApiKey(String googleMapsApiKey) {
        this._googleMapsApiKey = googleMapsApiKey;
    }

    @ConfigurationParameter
    public void setGoogleAnalyticsKey(String clientKey) {
        this._googleAnalyticsAnalyticsKey = clientKey;
    }

    @Override
    public Map<String, Object> getConfiguration(String contextPath) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("apiKey", "web");
        config.put("baseUrl", contextPath);
        config.put("apiUrl", contextPath + "/api");
        List agenciesWithCoverage = this._transitDataService.getAgenciesWithCoverage();
        CoordinateBounds bounds = new CoordinateBounds();
        for (AgencyWithCoverageBean awc : agenciesWithCoverage) {
            if (awc.getLatSpan() <= 0.0 || awc.getLonSpan() <= 0.0) continue;
            bounds.addPoint(awc.getLat() + awc.getLatSpan() / 2.0, awc.getLon() + awc.getLonSpan() / 2.0);
            bounds.addPoint(awc.getLat() - awc.getLatSpan() / 2.0, awc.getLon() - awc.getLonSpan() / 2.0);
        }
        if (bounds.isEmpty()) {
            config.put("centerLat", 0.0);
            config.put("centerLon", 0.0);
            config.put("spanLat", 180.0);
            config.put("spanLon", 180.0);
        } else {
            config.put("centerLat", (bounds.getMinLat() + bounds.getMaxLat()) / 2.0);
            config.put("centerLon", (bounds.getMinLon() + bounds.getMaxLon()) / 2.0);
            config.put("spanLat", bounds.getMaxLat() - bounds.getMinLat());
            config.put("spanLon", bounds.getMaxLon() - bounds.getMinLon());
        }
        config.put("hasDefaultServiceArea", this._serviceAreaService.hasDefaultServiceArea());
        config.put("googleMapsApiKey", this._googleMapsApiKey);
        config.put("tracker", this._googleAnalyticsAnalyticsKey);
        return config;
    }
}

