/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.conversion;

import com.opensymphony.xwork2.conversion.TypeConversionException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.struts2.util.StrutsTypeConverter;

public class DateTimeConverter
extends StrutsTypeConverter {
    private static SimpleDateFormat _format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");

    public Object convertFromString(Map context, String[] values, Class toClass) {
        if (values != null && values.length > 0 && values[0] != null && values[0].length() > 0) {
            String value = values[0];
            return this.parse(value, toClass);
        }
        return null;
    }

    public long parse(String value) {
        return (Long)this.parse(value, Long.class);
    }

    private Object parse(String value, Class toClass) {
        if (value.matches("^(\\d+)$")) {
            long v = Long.parseLong(value);
            if (toClass == Long.TYPE || toClass == Long.class) {
                return v;
            }
            return new Date(v);
        }
        try {
            Date d = _format.parse(value);
            if (toClass == Long.TYPE || toClass == Long.class) {
                return d.getTime();
            }
            return d;
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new TypeConversionException((Throwable)e);
        }
    }

    public String convertToString(Map context, Object o) {
        if (o instanceof Date) {
            return _format.format((Date)o);
        }
        return "";
    }
}

