/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.realtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.presentation.impl.realtime.PresentationServiceImpl;
import org.onebusaway.presentation.impl.realtime.SiriSupport;
import org.onebusaway.presentation.services.realtime.PresentationService;
import org.onebusaway.presentation.services.realtime.RealtimeService;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ArrivalsAndDeparturesQueryBean;
import org.onebusaway.transit_data.model.FilterChain;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.SituationQueryBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data.model.trips.TripDetailsBean;
import org.onebusaway.transit_data.model.trips.TripDetailsInclusionBean;
import org.onebusaway.transit_data.model.trips.TripDetailsQueryBean;
import org.onebusaway.transit_data.model.trips.TripForVehicleQueryBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;
import org.onebusaway.transit_data.model.trips.TripsForRouteQueryBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.siri.SiriExtensionWrapper;
import org.onebusaway.transit_data_federation.siri.SiriJsonSerializer;
import org.onebusaway.transit_data_federation.siri.SiriXmlSerializer;
import org.onebusaway.util.SystemTime;
import org.onebusaway.util.services.configuration.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import uk.org.siri.siri.MonitoredCallStructure;
import uk.org.siri.siri.MonitoredStopVisitStructure;
import uk.org.siri.siri.MonitoredVehicleJourneyStructure;
import uk.org.siri.siri.VehicleActivityStructure;

@Component
public class RealtimeServiceImpl
implements RealtimeService {
    private TransitDataService _transitDataService;
    private ConfigurationService _configurationService;
    private PresentationService _presentationService;
    private FilterChain _filterChain;
    private SiriXmlSerializer _siriXmlSerializer = new SiriXmlSerializer();
    private SiriJsonSerializer _siriJsonSerializer = new SiriJsonSerializer();
    private static Logger _log = LoggerFactory.getLogger(PresentationServiceImpl.class);
    private static final long MILLISECONDS_IN_YEAR = 31536000000L;
    private Long _now = null;
    private Boolean _useApc = null;

    @Override
    public void setTime(long time) {
        this._now = time;
        this._presentationService.setTime(time);
    }

    public long getTime() {
        if (this._now != null) {
            return this._now;
        }
        return SystemTime.currentTimeMillis();
    }

    @Autowired
    public void setTransitDataService(TransitDataService transitDataService) {
        this._transitDataService = transitDataService;
    }

    @Autowired
    public void setConfigurationService(ConfigurationService configService) {
        this._configurationService = configService;
    }

    @Autowired
    public void setPresentationService(PresentationService presentationService) {
        this._presentationService = presentationService;
    }

    @Override
    public PresentationService getPresentationService() {
        return this._presentationService;
    }

    @Override
    public SiriJsonSerializer getSiriJsonSerializer() {
        return this._siriJsonSerializer;
    }

    @Override
    public SiriXmlSerializer getSiriXmlSerializer() {
        return this._siriXmlSerializer;
    }

    @Autowired(required=false)
    public void setFilterChain(FilterChain chain) {
        this._filterChain = chain;
    }

    @Override
    public List<VehicleActivityStructure> getVehicleActivityForRoute(String routeId, String directionId, int maximumOnwardCalls, long currentTime, boolean showRawLocation) {
        ArrayList<VehicleActivityStructure> output = new ArrayList<VehicleActivityStructure>();
        ListBean<TripDetailsBean> trips = this.getAllTripsForRoute(routeId, currentTime);
        for (TripDetailsBean tripDetails : trips.getList()) {
            if (tripDetails == null || routeId != null && !tripDetails.getTrip().getRoute().getId().equals(routeId) || tripDetails.getTrip().getDirectionId() != null && directionId != null && !tripDetails.getTrip().getDirectionId().equals(directionId) || !this._presentationService.include(tripDetails.getStatus())) continue;
            VehicleActivityStructure activity = new VehicleActivityStructure();
            if (!tripDetails.getStatus().isPredicted()) {
                activity.setRecordedAtTime(new Date(this.getTime()));
            } else {
                activity.setRecordedAtTime(new Date(tripDetails.getStatus().getLastUpdateTime()));
            }
            List timePredictionRecords = null;
            timePredictionRecords = this._transitDataService.getPredictionRecordsForTrip(AgencyAndId.convertFromString((String)routeId).getAgencyId(), tripDetails.getStatus());
            boolean showApc = this.useApc();
            if ("CANCELED".equals(tripDetails.getStatus().getStatus())) continue;
            activity.setMonitoredVehicleJourney(new VehicleActivityStructure.MonitoredVehicleJourney());
            SiriSupport.fillMonitoredVehicleJourney((MonitoredVehicleJourneyStructure)activity.getMonitoredVehicleJourney(), tripDetails.getTrip(), null, tripDetails.getStatus(), null, SiriSupport.OnwardCallsMode.VEHICLE_MONITORING, this._presentationService, this._transitDataService, maximumOnwardCalls, timePredictionRecords, tripDetails.getStatus().isPredicted(), currentTime, showRawLocation, showApc);
            output.add(activity);
        }
        Collections.sort(output, new Comparator<VehicleActivityStructure>(){

            @Override
            public int compare(VehicleActivityStructure arg0, VehicleActivityStructure arg1) {
                try {
                    SiriExtensionWrapper wrapper0 = (SiriExtensionWrapper)arg0.getMonitoredVehicleJourney().getMonitoredCall().getExtensions().getAny();
                    SiriExtensionWrapper wrapper1 = (SiriExtensionWrapper)arg1.getMonitoredVehicleJourney().getMonitoredCall().getExtensions().getAny();
                    return wrapper0.getDistances().getDistanceFromCall().compareTo(wrapper1.getDistances().getDistanceFromCall());
                }
                catch (Exception e) {
                    return -1;
                }
            }
        });
        return output;
    }

    @Override
    public VehicleActivityStructure getVehicleActivityForVehicle(String vehicleId, int maximumOnwardCalls, long currentTime, String tripId) {
        TripForVehicleQueryBean query = new TripForVehicleQueryBean();
        query.setTime(new Date(currentTime));
        query.setVehicleId(vehicleId);
        TripDetailsInclusionBean inclusion = new TripDetailsInclusionBean();
        inclusion.setIncludeTripStatus(true);
        inclusion.setIncludeTripBean(true);
        query.setInclusion(inclusion);
        TripDetailsBean tripDetailsForCurrentTrip = this._transitDataService.getTripDetailsForVehicleAndTime(query);
        if (tripDetailsForCurrentTrip == null) {
            TripDetailsQueryBean detailsQuery = new TripDetailsQueryBean();
            detailsQuery.setTime(currentTime);
            detailsQuery.setTripId(tripId);
            tripDetailsForCurrentTrip = this._transitDataService.getSingleTripDetails(detailsQuery);
        }
        if (tripDetailsForCurrentTrip == null || !this._presentationService.include(tripDetailsForCurrentTrip.getStatus())) {
            return null;
        }
        VehicleActivityStructure output = new VehicleActivityStructure();
        if (!tripDetailsForCurrentTrip.getStatus().isPredicted()) {
            output.setRecordedAtTime(new Date(this.getTime()));
        } else {
            output.setRecordedAtTime(new Date(tripDetailsForCurrentTrip.getStatus().getLastUpdateTime()));
        }
        List timePredictionRecords = null;
        timePredictionRecords = this._transitDataService.getPredictionRecordsForTrip(AgencyAndId.convertFromString((String)vehicleId).getAgencyId(), tripDetailsForCurrentTrip.getStatus());
        boolean showApc = this.useApc();
        if (!"CANCELED".equals(tripDetailsForCurrentTrip.getStatus())) {
            output.setMonitoredVehicleJourney(new VehicleActivityStructure.MonitoredVehicleJourney());
            SiriSupport.fillMonitoredVehicleJourney((MonitoredVehicleJourneyStructure)output.getMonitoredVehicleJourney(), tripDetailsForCurrentTrip.getTrip(), null, tripDetailsForCurrentTrip.getStatus(), null, SiriSupport.OnwardCallsMode.VEHICLE_MONITORING, this._presentationService, this._transitDataService, maximumOnwardCalls, timePredictionRecords, tripDetailsForCurrentTrip.getStatus().isPredicted(), currentTime, false, showApc);
            return output;
        }
        return null;
    }

    @Override
    public List<MonitoredStopVisitStructure> getMonitoredStopVisitsForStop(String stopId, int maximumOnwardCalls, long currentTime) {
        ArrayList<MonitoredStopVisitStructure> output = new ArrayList<MonitoredStopVisitStructure>();
        for (ArrivalAndDepartureBean adBean : this.getArrivalsAndDeparturesForStop(stopId, currentTime)) {
            TripStatusBean statusBeanForCurrentTrip = adBean.getTripStatus();
            TripBean tripBeanForAd = adBean.getTrip();
            RouteBean routeBean = tripBeanForAd.getRoute();
            if (statusBeanForCurrentTrip == null) {
                _log.debug("status drop");
                continue;
            }
            if (!this._presentationService.include(statusBeanForCurrentTrip) || !this._presentationService.include(adBean, statusBeanForCurrentTrip)) {
                _log.debug("presentation drop for vehicle=" + statusBeanForCurrentTrip.getVehicleId());
                continue;
            }
            if (!this._transitDataService.stopHasRevenueServiceOnRoute(routeBean.getAgency() != null ? routeBean.getAgency().getId() : null, stopId, routeBean.getId(), adBean.getTrip().getDirectionId()).booleanValue()) {
                _log.debug("non reveunue drop");
                continue;
            }
            if (statusBeanForCurrentTrip.isPredicted() && !adBean.hasPredictedArrivalTime() && !adBean.hasPredictedDepartureTime()) {
                _log.debug("no realtime drop");
                continue;
            }
            if (statusBeanForCurrentTrip.getVehicleId() != null) {
                _log.debug("valid vehicle " + statusBeanForCurrentTrip.getVehicleId());
            }
            MonitoredStopVisitStructure stopVisit = new MonitoredStopVisitStructure();
            if (!statusBeanForCurrentTrip.isPredicted()) {
                stopVisit.setRecordedAtTime(new Date(this.getTime()));
            } else {
                stopVisit.setRecordedAtTime(new Date(statusBeanForCurrentTrip.getLastUpdateTime()));
            }
            List timePredictionRecords = null;
            timePredictionRecords = this._transitDataService.getPredictionRecordsForTrip(AgencyAndId.convertFromString((String)stopId).getAgencyId(), statusBeanForCurrentTrip);
            boolean showApc = this.useApc();
            if ("CANCELED".equals(statusBeanForCurrentTrip.getStatus())) continue;
            stopVisit.setMonitoredVehicleJourney(new MonitoredVehicleJourneyStructure());
            SiriSupport.fillMonitoredVehicleJourney(stopVisit.getMonitoredVehicleJourney(), tripBeanForAd, adBean, adBean.getTripStatus(), adBean.getStop(), SiriSupport.OnwardCallsMode.STOP_MONITORING, this._presentationService, this._transitDataService, maximumOnwardCalls, timePredictionRecords, statusBeanForCurrentTrip.isPredicted(), currentTime, false, showApc);
            output.add(stopVisit);
        }
        Collections.sort(output, new Comparator<MonitoredStopVisitStructure>(){

            @Override
            public int compare(MonitoredStopVisitStructure arg0, MonitoredStopVisitStructure arg1) {
                try {
                    Date prediction0 = this.bestDate(arg0.getMonitoredVehicleJourney().getMonitoredCall());
                    Date prediction1 = this.bestDate(arg1.getMonitoredVehicleJourney().getMonitoredCall());
                    return prediction0.compareTo(prediction1);
                }
                catch (Exception e) {
                    return -1;
                }
            }

            private Date bestDate(MonitoredCallStructure monitoredCall) {
                if (monitoredCall.getExpectedDepartureTime() != null) {
                    if (monitoredCall.getExpectedArrivalTime() != null && monitoredCall.getExpectedArrivalTime() != monitoredCall.getExpectedDepartureTime()) {
                        return monitoredCall.getExpectedArrivalTime();
                    }
                    return monitoredCall.getExpectedDepartureTime();
                }
                return monitoredCall.getExpectedArrivalTime();
            }
        });
        return output;
    }

    @Override
    public boolean getVehiclesInServiceForRoute(String routeId, String directionId, long currentTime) {
        ListBean<TripDetailsBean> trips = this.getAllTripsForRoute(routeId, currentTime);
        for (TripDetailsBean tripDetails : trips.getList()) {
            if (tripDetails == null || routeId != null && !tripDetails.getTrip().getRoute().getId().equals(routeId) || directionId != null && tripDetails.getTrip().getDirectionId() != null && !tripDetails.getTrip().getDirectionId().equals(directionId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getVehiclesInServiceForStopAndRoute(String stopId, String routeId, long currentTime) {
        for (ArrivalAndDepartureBean adBean : this.getArrivalsAndDeparturesForStop(stopId, currentTime)) {
            TripStatusBean statusBean = adBean.getTripStatus();
            if (!this._presentationService.include(statusBean) || !this._presentationService.include(adBean, statusBean) || routeId != null && !adBean.getTrip().getRoute().getId().equals(routeId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ServiceAlertBean> getServiceAlertsForAgency(String agencyId) {
        SituationQueryBean query = new SituationQueryBean();
        query.setTime(this.getTime());
        SituationQueryBean.AffectsBean affects = new SituationQueryBean.AffectsBean();
        query.getAffects().add(affects);
        affects.setAgencyId(agencyId);
        ListBean serviceAlerts = this._transitDataService.getServiceAlerts(query);
        return serviceAlerts.getList();
    }

    @Override
    public List<ServiceAlertBean> getServiceAlertsForRoute(String routeId) {
        return this.getServiceAlertsForRouteAndDirection(routeId, null);
    }

    @Override
    public List<ServiceAlertBean> getServiceAlertsForRouteAndDirection(String routeId, String directionId) {
        SituationQueryBean query = new SituationQueryBean();
        query.setTime(this.getTime());
        SituationQueryBean.AffectsBean affects = new SituationQueryBean.AffectsBean();
        query.getAffects().add(affects);
        affects.setRouteId(routeId);
        if (directionId != null) {
            affects.setDirectionId(directionId);
        } else {
            SituationQueryBean.AffectsBean affects1 = new SituationQueryBean.AffectsBean();
            query.getAffects().add(affects1);
            affects1.setRouteId(routeId);
            affects1.setDirectionId("0");
            SituationQueryBean.AffectsBean affects2 = new SituationQueryBean.AffectsBean();
            query.getAffects().add(affects2);
            affects2.setRouteId(routeId);
            affects2.setDirectionId("1");
        }
        ListBean serviceAlerts = this._transitDataService.getServiceAlerts(query);
        return serviceAlerts.getList();
    }

    @Override
    public List<ServiceAlertBean> getServiceAlertsForRouteAndStop(String routeId, String stopId) {
        SituationQueryBean query = new SituationQueryBean();
        query.setTime(this.getTime());
        SituationQueryBean.AffectsBean affects = new SituationQueryBean.AffectsBean();
        query.getAffects().add(affects);
        affects.setRouteId(routeId);
        if (stopId != null) {
            affects.setStopId(stopId);
        }
        ListBean serviceAlerts = this._transitDataService.getServiceAlerts(query);
        return serviceAlerts.getList();
    }

    @Override
    public List<ServiceAlertBean> getServiceAlertsGlobal() {
        SituationQueryBean query = new SituationQueryBean();
        SituationQueryBean.AffectsBean affects = new SituationQueryBean.AffectsBean();
        query.setTime(this.getTime());
        affects.setAgencyId("__ALL_OPERATORS__");
        query.getAffects().add(affects);
        ListBean serviceAlerts = this._transitDataService.getServiceAlerts(query);
        return serviceAlerts.getList();
    }

    @Override
    public boolean showApc() {
        return this.useApc();
    }

    private ListBean<TripDetailsBean> getAllTripsForRoute(String routeId, long currentTime) {
        TripsForRouteQueryBean tripRouteQueryBean = new TripsForRouteQueryBean();
        tripRouteQueryBean.setRouteId(routeId);
        tripRouteQueryBean.setTime(currentTime);
        TripDetailsInclusionBean inclusionBean = new TripDetailsInclusionBean();
        inclusionBean.setIncludeTripBean(true);
        inclusionBean.setIncludeTripStatus(true);
        tripRouteQueryBean.setInclusion(inclusionBean);
        return this._transitDataService.getTripsForRoute(tripRouteQueryBean);
    }

    private List<ArrivalAndDepartureBean> getArrivalsAndDeparturesForStop(String stopId, long currentTime) {
        ArrivalsAndDeparturesQueryBean query = new ArrivalsAndDeparturesQueryBean();
        query.setTime(currentTime);
        query.setMinutesBefore(5);
        query.setMinutesAfter(65);
        if (this._filterChain != null) {
            query.setSystemFilterChain(this._filterChain);
        }
        StopWithArrivalsAndDeparturesBean stopWithArrivalsAndDepartures = this._transitDataService.getStopWithArrivalsAndDepartures(stopId, query, new AgencyServiceInterval(currentTime));
        return stopWithArrivalsAndDepartures.getArrivalsAndDepartures();
    }

    private boolean useApc() {
        if (this._useApc == null) {
            this._useApc = this._configurationService.getConfigurationValueAsBoolean("tds.useApc", Boolean.TRUE);
        }
        return this._useApc;
    }
}

