/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.resources;

import com.steadystate.css.sac.DocumentHandlerExt;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.onebusaway.presentation.services.resources.ResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

class CssDocumentHandler
implements DocumentHandlerExt {
    private static Logger _log = LoggerFactory.getLogger(CssDocumentHandler.class);
    private static final Pattern _obaResourcePattern = Pattern.compile("^oba-resource\\((.*)\\)$");
    private StringBuilder _buffer = new StringBuilder();
    private ResourceService _resourceService;
    private Locale _locale;

    public CssDocumentHandler(ResourceService resourceService, Locale locale) {
        this._resourceService = resourceService;
        this._locale = locale;
    }

    public String getResults() {
        return this._buffer.toString();
    }

    public void startDocument(InputSource source) throws CSSException {
    }

    public void endDocument(InputSource source) throws CSSException {
    }

    public void comment(String comment) throws CSSException {
    }

    public void startFontFace() throws CSSException {
        _log.debug("start font face");
    }

    public void endFontFace() throws CSSException {
        _log.debug("end font face");
    }

    public void importStyle(String uri, SACMediaList media, String defaultNamespaceUri) throws CSSException {
    }

    public void ignorableAtRule(String atRule) throws CSSException {
    }

    public void namespaceDeclaration(String arg0, String arg1) throws CSSException {
    }

    public void startMedia(SACMediaList media) throws CSSException {
    }

    public void endMedia(SACMediaList media) throws CSSException {
    }

    public void startPage(String name, String pseudoPage) throws CSSException {
    }

    public void endPage(String name, String pseudoPage) throws CSSException {
    }

    public void startSelector(SelectorList selectors) throws CSSException {
        for (int i = 0; i < selectors.getLength(); ++i) {
            Selector selector = selectors.item(i);
            if (i > 0) {
                this._buffer.append(',');
            }
            this._buffer.append(selector.toString());
        }
        this._buffer.append("{");
    }

    public void property(String name, LexicalUnit unit, boolean important) throws CSSException {
        this._buffer.append(name);
        this._buffer.append(':');
        int index = 0;
        while (unit != null) {
            if (index > 0) {
                this._buffer.append(" ");
            }
            String v = unit.toString();
            v = this.substitute(v);
            this._buffer.append(v);
            unit = unit.getNextLexicalUnit();
            ++index;
        }
        this._buffer.append(';');
    }

    public void endSelector(SelectorList selectors) throws CSSException {
        this._buffer.append('}').append('\n');
    }

    public void charset(String characterEncoding) throws CSSException {
    }

    private String substitute(String id) {
        Matcher m;
        if (id.startsWith("oba-") && (m = _obaResourcePattern.matcher(id)).matches()) {
            String url = m.group(1);
            if (url.startsWith("\"") && url.endsWith("\"")) {
                url = url.substring(1, url.length() - 1);
            } else if (url.startsWith("'") && url.endsWith("'")) {
                url = url.substring(1, url.length() - 1);
            }
            String externalUrl = this._resourceService.getExternalUrlForResource(url, this._locale);
            if (externalUrl == null) {
                _log.warn("unknown resource: " + url);
                externalUrl = "";
            }
            return "url(\"" + externalUrl + "\")";
        }
        return id;
    }
}

