/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.resources;

import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.ResourcePrototype;
import com.steadystate.css.parser.SACParserCSS2;
import com.steadystate.css.sac.DocumentHandlerExt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.onebusaway.presentation.impl.resources.ClientBundleContext;
import org.onebusaway.presentation.impl.resources.ClientBundleImpl;
import org.onebusaway.presentation.impl.resources.ResourceWithUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

class CssDocumentHandlerImpl
implements DocumentHandlerExt {
    private static Logger _log = LoggerFactory.getLogger(CssDocumentHandlerImpl.class);
    private static final String AT_RULE_URL = "@url";
    private static final String AT_RULE_SPRITE = "@sprite";
    private Map<String, String> _substitutions = new HashMap<String, String>();
    private StringBuilder _buffer = new StringBuilder();
    private ClientBundleContext _context;
    private ClientBundleImpl _parentBundle;

    public CssDocumentHandlerImpl(ClientBundleContext context, ClientBundleImpl parentBundle) {
        this._context = context;
        this._parentBundle = parentBundle;
    }

    public String getResults() {
        return this._buffer.toString();
    }

    public void startDocument(InputSource source) throws CSSException {
    }

    public void endDocument(InputSource source) throws CSSException {
    }

    public void comment(String comment) throws CSSException {
    }

    public void startFontFace() throws CSSException {
        _log.debug("start font face");
    }

    public void endFontFace() throws CSSException {
        _log.debug("end font face");
    }

    public void importStyle(String uri, SACMediaList media, String defaultNamespaceUri) throws CSSException {
    }

    public void ignorableAtRule(String atRule) throws CSSException {
        if (atRule.startsWith(AT_RULE_SPRITE)) {
            String snippet = atRule.substring(AT_RULE_SPRITE.length());
            snippet = snippet.trim();
            this.parse(snippet);
        } else if (atRule.startsWith(AT_RULE_URL)) {
            String snippet = atRule.substring(AT_RULE_URL.length());
            snippet = snippet.trim();
            Pattern pattern = Pattern.compile("^(\\w+)\\s+(\\w+);$");
            Matcher matcher = pattern.matcher(snippet);
            if (matcher.matches()) {
                String name = matcher.group(1);
                String resource = matcher.group(2);
                this.handleUrl(name, resource);
            }
        }
    }

    public void namespaceDeclaration(String arg0, String arg1) throws CSSException {
    }

    public void startMedia(SACMediaList media) throws CSSException {
    }

    public void endMedia(SACMediaList media) throws CSSException {
    }

    public void startPage(String name, String pseudoPage) throws CSSException {
    }

    public void endPage(String name, String pseudoPage) throws CSSException {
    }

    public void startSelector(SelectorList selectors) throws CSSException {
        for (int i = 0; i < selectors.getLength(); ++i) {
            Selector selector = selectors.item(i);
            if (i > 0) {
                this._buffer.append(',');
            }
            this._buffer.append(selector.toString());
        }
        this._buffer.append("{");
    }

    public void property(String name, LexicalUnit unit, boolean important) throws CSSException {
        if (name.equals("gwt-image")) {
            String v = unit.toString();
            ResourcePrototype resource = this._parentBundle.getResource(v);
            if (resource == null) {
                _log.warn("unknown resource: " + v);
                return;
            }
            if (!(resource instanceof ImageResource)) {
                _log.warn("expected ImageResource");
                return;
            }
            ImageResource img = (ImageResource)resource;
            this._buffer.append("background-image:url(" + img.getURL() + ");");
        } else {
            this._buffer.append(name);
            this._buffer.append(':');
            int index = 0;
            while (unit != null) {
                if (index > 0) {
                    this._buffer.append(" ");
                }
                String v = unit.toString();
                v = this.substitute(v);
                this._buffer.append(v);
                unit = unit.getNextLexicalUnit();
                ++index;
            }
            this._buffer.append(';');
        }
    }

    public void endSelector(SelectorList selectors) throws CSSException {
        this._buffer.append('}').append('\n');
    }

    public void charset(String characterEncoding) throws CSSException {
    }

    private void handleUrl(String name, String value) {
        ResourcePrototype resource = this._parentBundle.getResource(value);
        if (resource == null) {
            throw new IllegalStateException("unknown resource name=" + name + " value: " + value);
        }
        if (!(resource instanceof ResourceWithUrl)) {
            throw new IllegalStateException("resource is not instance of ResourceWithUrl: name=" + value + " value=" + resource);
        }
        ResourceWithUrl data = (ResourceWithUrl)resource;
        String url = data.getUrl();
        url = this._context.addContext(url);
        this._substitutions.put(name, "url(\"" + url + "\")");
    }

    private String substitute(String id) {
        if (this._substitutions.containsKey(id)) {
            id = this._substitutions.get(id);
        }
        return id;
    }

    private void parse(String snippet) throws CSSException {
        try {
            BufferedReader reader = new BufferedReader(new StringReader(snippet));
            InputSource source = new InputSource((Reader)reader);
            SACParserCSS2 p = new SACParserCSS2();
            p.setDocumentHandler((DocumentHandler)this);
            p.parseStyleSheet(source);
            reader.close();
        }
        catch (IOException ex) {
            throw new CSSException((Exception)ex);
        }
    }
}

