/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.resources;

import java.io.File;
import java.net.URL;
import org.onebusaway.presentation.impl.resources.AbstractResource;
import org.onebusaway.presentation.impl.resources.ResourceTransformationStrategy;
import org.onebusaway.util.SystemTime;

class ResourceEntry
extends AbstractResource {
    private final String resourcePath;
    private final URL sourceResource;
    private final File sourceFile;
    private final ResourceTransformationStrategy transformationStrategy;

    public ResourceEntry(String resourcePath, URL sourceResource, File sourceFile, ResourceTransformationStrategy transformationStrategy) {
        this.resourcePath = resourcePath;
        this.sourceResource = sourceResource;
        this.sourceFile = sourceFile;
        this.transformationStrategy = transformationStrategy;
        if (sourceFile != null) {
            this.setLastModifiedTime(sourceFile.lastModified());
        } else {
            this.setLastModifiedTime(SystemTime.currentTimeMillis());
        }
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public URL getSourceResource() {
        return this.sourceResource;
    }

    public ResourceTransformationStrategy getTransformationStrategy() {
        return this.transformationStrategy;
    }

    public String toString() {
        return "ResourceEntry(path=" + this.resourcePath + ")";
    }
}

