/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.resources;

import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.StrutsTextProviderFactory;
import com.opensymphony.xwork2.TextProvider;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.json.JSONObject;
import org.onebusaway.presentation.impl.ServletLibrary;
import org.onebusaway.presentation.impl.resources.CssResourceTransformationStrategy;
import org.onebusaway.presentation.impl.resources.DefaultResourceTransformationStrategy;
import org.onebusaway.presentation.impl.resources.ResourceEntry;
import org.onebusaway.presentation.impl.resources.ResourceSupport;
import org.onebusaway.presentation.impl.resources.ResourceTransformationStrategy;
import org.onebusaway.presentation.impl.resources.ResourcesEntry;
import org.onebusaway.presentation.services.resources.Resource;
import org.onebusaway.presentation.services.resources.ResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class ResourceServiceImpl
implements ResourceService {
    public static final String DEBUG_PROPERTY = ResourceServiceImpl.class.getName() + ".debug";
    private static final String PREFIX_CLASSPATH = "classpath:";
    private static final String PREFIX_COLLECTION = "collection:";
    private static final String PREFIX_COLLECTION_ENTRY = "collection-entry:";
    private static final String PREFIX_MESSAGES = "messages:";
    private static final String PREFIX_MESSAGES_DATE_LIBRARY = "DateLibrary";
    private static final String PREFIX_FILE = "file:";
    private static final Pattern _resourcePattern = Pattern.compile("^(.*)-\\w+\\.cache(\\.\\w+){0,1}$");
    private static Logger _log = LoggerFactory.getLogger(ResourceServiceImpl.class);
    private static StrutsTextProviderFactory _textProviderFactory = new StrutsTextProviderFactory();
    private ConcurrentMap<String, Resource> _resourceEntriesByResourcePath = new ConcurrentHashMap<String, Resource>();
    private ConcurrentMap<String, Resource> _resourceEntriesByExternalId = new ConcurrentHashMap<String, Resource>();
    private ConcurrentMap<String, List<String>> _resourcePathsById = new ConcurrentHashMap<String, List<String>>();
    private String _prefix;
    private String _pattern;
    private File _tempDir;
    private ServletContext _servletContext;
    private String _contextPath;
    private boolean _debug = false;

    public void setPrefix(String prefix) {
        this._prefix = prefix;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    @Autowired
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
        this._contextPath = ServletLibrary.getContextPath(this._servletContext);
        File tmpDir = (File)this._servletContext.getAttribute("javax.servlet.context.tempdir");
        if (tmpDir == null) {
            _log.warn("NO ServletContext TEMP DIR!");
            tmpDir = new File(System.getProperty("java.io.tmpdir"));
        }
        this._tempDir = new File(tmpDir, "OneBusAwayResources");
        if (!this._tempDir.exists()) {
            this._tempDir.mkdirs();
        }
    }

    @PostConstruct
    public void setup() {
        String value = System.getProperty(DEBUG_PROPERTY, "false");
        if (value != null && value.toLowerCase().equals("true")) {
            this._debug = true;
        }
    }

    @Override
    public String getExternalUrlForResource(String resourcePath, Locale locale) {
        LocaleProviderImpl localeProvider = new LocaleProviderImpl(locale);
        Resource resource = this.getResourceForPath(resourcePath, localeProvider, null);
        if (resource == null) {
            _log.warn("resource not found: " + resourcePath);
            return null;
        }
        if (this._debug) {
            this.refreshResource(resource);
        }
        return resource.getExternalUrl();
    }

    @Override
    public String getExternalUrlForResources(List<String> resourcePaths, Locale locale) {
        return this.getExternalUrlForResources(null, resourcePaths, locale);
    }

    @Override
    public String getExternalUrlForResources(String resourceId, List<String> resourcePaths, Locale locale) {
        LocaleProviderImpl localeProvider = new LocaleProviderImpl(locale);
        Resource resource = this.getResourceForPaths(resourceId, resourcePaths, localeProvider);
        if (resource == null) {
            _log.warn("resource not found: " + resourceId);
            return null;
        }
        if (this._debug) {
            this.refreshResource(resource);
        }
        return resource.getExternalUrl();
    }

    @Override
    public Resource getLocalResourceForExternalId(String externalId, Locale locale) {
        String resourcePath;
        Resource resource = (Resource)this._resourceEntriesByExternalId.get(externalId);
        if (resource == null && (resourcePath = this.getExternalIdAsResourcePath(externalId)) != null) {
            LocaleProviderImpl localeProvider = new LocaleProviderImpl(locale);
            if (this._resourcePathsById.containsKey(resourcePath)) {
                List paths = (List)this._resourcePathsById.get(resourcePath);
                resource = this.getResourceForPaths(resourcePath, paths, localeProvider);
            }
            if (resource == null) {
                resource = this.getResourceForPath(resourcePath, localeProvider, null);
            }
        }
        if (resource == null) {
            _log.warn("resource not found for external id: " + externalId);
            return null;
        }
        return resource;
    }

    private String getResourcePathAsKey(String resourcePath, LocaleProvider localeProvider) {
        if (resourcePath.startsWith(PREFIX_MESSAGES)) {
            Locale locale = localeProvider.getLocale();
            return resourcePath + "-" + locale.toString();
        }
        return resourcePath;
    }

    private Resource getResourceForPath(String resourcePath, LocaleProvider localeProvider, URL sourceUrl) {
        String resourcePathKey = this.getResourcePathAsKey(resourcePath, localeProvider);
        Resource resource = (Resource)this._resourceEntriesByResourcePath.get(resourcePathKey);
        if (resource == null) {
            resource = this.createResourceForPath(resourcePath, sourceUrl, localeProvider);
            if (resource == null) {
                return null;
            }
            Resource existingResource = this._resourceEntriesByResourcePath.putIfAbsent(resourcePathKey, resource);
            if (existingResource != null) {
                return existingResource;
            }
        }
        return resource;
    }

    private ResourceEntry createResourceForPath(String resourcePath, URL sourceUrl, LocaleProvider localeProvider) {
        if (sourceUrl == null) {
            sourceUrl = this.getResourceAsSourceUrl(resourcePath, localeProvider);
        }
        if (sourceUrl == null) {
            return null;
        }
        File localFile = this.getBundleResourceAsLocalFile(resourcePath, sourceUrl);
        ResourceTransformationStrategy strategy = this.getResourceTransformationStrategyForResource(resourcePath, localeProvider);
        ResourceEntry resource = new ResourceEntry(resourcePath, sourceUrl, localFile, strategy);
        this.generateLocalResourceAndExternalUrl(resource);
        return resource;
    }

    private URL getResourceAsSourceUrl(String resourceName, LocaleProvider localeProvider) {
        if (resourceName.startsWith(PREFIX_COLLECTION)) {
            resourceName = resourceName.substring(PREFIX_COLLECTION.length());
            return this.getCollectionResourceAsSourceUrl(resourceName, localeProvider);
        }
        if (resourceName.startsWith(PREFIX_MESSAGES)) {
            if (PREFIX_MESSAGES_DATE_LIBRARY.equals(resourceName = resourceName.substring(PREFIX_MESSAGES.length()))) {
                return this.getDateLibraryMessagesResourceAsSourceUrl(localeProvider);
            }
            return this.getMessagesResourceAsSourceUrl(resourceName, localeProvider);
        }
        if (resourceName.startsWith(PREFIX_CLASSPATH)) {
            resourceName = resourceName.substring(PREFIX_CLASSPATH.length());
            ClassLoader loader = this.getClass().getClassLoader();
            URL resource = loader.getResource(resourceName);
            if (resource == null) {
                _log.warn("unknown classpath resource: name=" + resourceName);
            }
            return resource;
        }
        if (resourceName.startsWith(PREFIX_FILE)) {
            resourceName = resourceName.substring(PREFIX_FILE.length());
            File file = new File(resourceName);
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("error requesting file url: " + resourceName);
            }
        }
        try {
            return this._servletContext.getResource(resourceName);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("error requesting servlet url: " + resourceName, ex);
        }
    }

    private URL getCollectionResourceAsSourceUrl(String resourceName, LocaleProvider localeProvider) {
        int index = resourceName.indexOf(61);
        if (index == -1) {
            throw new IllegalStateException("invalid resource collection specifier: " + resourceName);
        }
        String collectionPrefix = resourceName.substring(0, index);
        String collectionResourcePath = resourceName.substring(index + 1);
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        HashMap<String, String> resourceMapping = new HashMap<String, String>();
        try {
            org.springframework.core.io.Resource[] resources;
            for (org.springframework.core.io.Resource resource : resources = resolver.getResources(collectionResourcePath)) {
                URL url = resource.getURL();
                String name = this.getLocalUrlAsResourceName(url);
                Resource r = this.getResourceForPath(name, localeProvider, url);
                if (r == null) continue;
                String path = url.getPath();
                int sepIndex = path.lastIndexOf(File.separator);
                if (sepIndex != -1) {
                    path = path.substring(sepIndex + 1);
                }
                resourceMapping.put(path, r.getExternalUrl());
                String alternateId = PREFIX_COLLECTION_ENTRY + collectionPrefix + ":" + path;
                this._resourceEntriesByResourcePath.put(alternateId, r);
            }
            File file = this.getOutputFile(PREFIX_COLLECTION + collectionPrefix + ".js");
            PrintWriter out = new PrintWriter(file);
            JSONObject obj = new JSONObject(resourceMapping);
            out.println("var OBA = window.OBA || {};");
            out.println("if(!OBA.Resources) { OBA.Resources = {}; }");
            out.println("OBA.Resources." + collectionPrefix + " = " + obj.toString() + ";");
            out.close();
            return this.getFileAsUrl(file);
        }
        catch (IOException ex) {
            throw new IllegalStateException("error loading resources", ex);
        }
    }

    private URL getMessagesResourceAsSourceUrl(String resourceName, LocaleProvider localeProvider) {
        int index = resourceName.indexOf(61);
        if (index == -1) {
            throw new IllegalStateException("invalid resource messages specifier: " + resourceName);
        }
        String messagesPrefix = resourceName.substring(0, index);
        String messagesResourceClassName = resourceName.substring(index + 1);
        Class<?> messagesResourceClass = null;
        try {
            messagesResourceClass = Class.forName(messagesResourceClassName);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("error loading messages resource class " + messagesResourceClassName, ex);
        }
        TextProvider provider = _textProviderFactory.createInstance(messagesResourceClass);
        ResourceBundle bundle = provider.getTexts();
        HashMap<String, String> resourceMapping = new HashMap<String, String>();
        Enumeration<String> en = bundle.getKeys();
        while (en.hasMoreElements()) {
            String key = en.nextElement();
            String value = bundle.getString(key);
            resourceMapping.put(key, value);
        }
        try {
            File file = this.getOutputFile(PREFIX_MESSAGES + messagesPrefix + ".js");
            PrintWriter out = new PrintWriter(file);
            JSONObject obj = new JSONObject(resourceMapping);
            out.println("var OBA = window.OBA || {};");
            out.println("if(!OBA.Resources) { OBA.Resources = {}; }");
            out.println("OBA.Resources." + messagesPrefix + " = " + obj.toString() + ";");
            out.close();
            return this.getFileAsUrl(file);
        }
        catch (IOException ex) {
            throw new IllegalStateException("error loading resources", ex);
        }
    }

    private URL getDateLibraryMessagesResourceAsSourceUrl(LocaleProvider localeProvider) {
        String messagesPrefix = PREFIX_MESSAGES_DATE_LIBRARY;
        DateFormatSymbols symbols = DateFormatSymbols.getInstance(localeProvider.getLocale());
        HashMap<String, List<String>> resourceMapping = new HashMap<String, List<String>>();
        resourceMapping.put("amPm", Arrays.asList(symbols.getAmPmStrings()));
        resourceMapping.put("eras", Arrays.asList(symbols.getEras()));
        resourceMapping.put("months", Arrays.asList(symbols.getMonths()));
        resourceMapping.put("shortMonths", Arrays.asList(symbols.getShortMonths()));
        resourceMapping.put("weekdays", Arrays.asList(symbols.getWeekdays()));
        resourceMapping.put("shortWeekdays", Arrays.asList(symbols.getShortWeekdays()));
        try {
            File file = this.getOutputFile(PREFIX_MESSAGES + messagesPrefix + ".js");
            PrintWriter out = new PrintWriter(file);
            JSONObject obj = new JSONObject(resourceMapping);
            out.println("var OBA = window.OBA || {};");
            out.println("if(!OBA.Resources) { OBA.Resources = {}; }");
            out.println("OBA.Resources." + messagesPrefix + " = " + obj.toString() + ";");
            out.close();
            return this.getFileAsUrl(file);
        }
        catch (IOException ex) {
            throw new IllegalStateException("error loading resources", ex);
        }
    }

    private File getBundleResourceAsLocalFile(String resourcePath, URL resourceUrl) {
        Object path;
        String protocol = resourceUrl.getProtocol();
        if ("file".equals(protocol)) {
            return new File(resourceUrl.getPath());
        }
        if ("jar".equals(protocol)) {
            path = resourceUrl.getPath();
            int index = ((String)path).indexOf(33);
            if (index != -1) {
                path = ((String)path).substring(0, index);
            }
            try {
                URL jarResourceUrl = new URL((String)path);
                File file = new File(jarResourceUrl.getPath());
                if (file.exists()) {
                    return file;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (((File)(path = new File(this._servletContext.getRealPath(resourcePath)))).exists()) {
            return path;
        }
        return null;
    }

    private ResourceTransformationStrategy getResourceTransformationStrategyForResource(String resourcePath, LocaleProvider localeProvider) {
        if (resourcePath.endsWith(".css")) {
            return new CssResourceTransformationStrategy(localeProvider.getLocale());
        }
        return new DefaultResourceTransformationStrategy();
    }

    private boolean refreshResource(Resource resource) {
        if (resource instanceof ResourceEntry) {
            return this.refreshResourceEntry((ResourceEntry)resource);
        }
        if (resource instanceof ResourcesEntry) {
            return this.refreshResourcesEntry((ResourcesEntry)resource);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshResourceEntry(ResourceEntry resource) {
        File sourceFile = resource.getSourceFile();
        if (sourceFile == null) {
            return false;
        }
        ResourceEntry resourceEntry = resource;
        synchronized (resourceEntry) {
            long lastModifiedTime = resource.getLastModifiedTime();
            if (lastModifiedTime >= sourceFile.lastModified()) {
                return false;
            }
            String existingId = resource.getExternalId();
            this._resourceEntriesByExternalId.remove(existingId);
            this.generateLocalResourceAndExternalUrl(resource);
            return true;
        }
    }

    private void generateLocalResourceAndExternalUrl(ResourceEntry resource) {
        ResourceTransformationStrategy strategy = resource.getTransformationStrategy();
        URL localUrl = resource.getSourceResource();
        long contentLength = -1L;
        if (strategy.requiresTransformation()) {
            File outputFile = this.getOutputFile(resource.getResourcePath());
            strategy.transformResource(this, localUrl, outputFile);
            localUrl = this.getFileAsUrl(outputFile);
            contentLength = outputFile.length();
        }
        if (contentLength == -1L) {
            contentLength = this.computeContentLengthForLocalUrl(localUrl);
        }
        resource.setLocalUrl(localUrl);
        resource.setContentLength(contentLength);
        String key = this.getResourceKey(localUrl);
        String externalId = this.constructExternalId(resource.getResourcePath(), key);
        String externalUrl = this.constructExternalUrl(externalId);
        resource.setExternalId(externalId);
        resource.setExternalUrl(externalUrl);
        this._resourceEntriesByExternalId.put(externalId, resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long computeContentLengthForLocalUrl(URL localUrl) {
        InputStream in = null;
        try {
            in = localUrl.openStream();
            long contentLength = 0L;
            byte[] buffer = new byte[1024];
            while (true) {
                int rc;
                if ((rc = in.read(buffer)) == -1) {
                    long l = contentLength;
                    return l;
                }
                contentLength += (long)rc;
                continue;
                break;
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("error reading local url " + localUrl, ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    _log.warn("error closing local url " + localUrl, (Throwable)ex);
                }
            }
        }
    }

    private String getResourceKey(URL localResource) {
        try {
            InputStream in = localResource.openStream();
            return ResourceSupport.getHash(in);
        }
        catch (IOException ex) {
            throw new IllegalStateException("error constructing key for resource: " + localResource, ex);
        }
    }

    private String constructExternalId(String resourcePath, String resourceKey) {
        String resourceExtension = null;
        int index = resourcePath.lastIndexOf(46);
        if (index != -1) {
            resourceExtension = resourcePath.substring(index + 1);
            resourcePath = resourcePath.substring(0, index);
        }
        StringBuilder b = new StringBuilder();
        b.append(resourcePath);
        if (!this._debug) {
            b.append('-');
            b.append(resourceKey);
            b.append(".cache");
        }
        if (resourceExtension != null && resourceExtension.length() > 0) {
            b.append('.').append(resourceExtension);
        }
        String url = b.toString();
        return url;
    }

    private String getExternalIdAsResourcePath(String externalId) {
        if (this._debug) {
            return externalId;
        }
        Matcher m = _resourcePattern.matcher(externalId);
        if (!m.matches()) {
            return null;
        }
        Object resourcePath = m.group(1);
        if (m.groupCount() > 1) {
            resourcePath = (String)resourcePath + m.group(2);
        }
        return resourcePath;
    }

    private String constructExternalUrl(String externalId) {
        externalId = externalId.replaceAll("/", "%2f");
        externalId = externalId.replaceAll("\\*", "%2a");
        externalId = externalId.replaceAll(":", "%3a");
        Object url = externalId;
        if (this._pattern != null) {
            url = this._pattern.replaceAll("\\{\\}", (String)url);
        }
        if (this._prefix != null) {
            url = this._prefix + (String)url;
        }
        if (this._contextPath != null) {
            url = this._contextPath + (String)url;
        }
        return url;
    }

    private Resource getResourceForPaths(String resourceId, List<String> resourcePaths, LocaleProvider localeProvider) {
        if (resourceId == null) {
            resourceId = this.getResourceIdForResourcePaths(resourcePaths);
        } else {
            this._resourcePathsById.putIfAbsent(resourceId, resourcePaths);
        }
        String resourceIdKey = this.getResourcePathAsKey(resourceId, localeProvider);
        Resource resource = (Resource)this._resourceEntriesByResourcePath.get(resourceIdKey);
        if (resource == null) {
            resource = this.createResourceForPaths(resourceId, resourcePaths, localeProvider);
            if (resource == null) {
                return null;
            }
            Resource existingResource = this._resourceEntriesByResourcePath.putIfAbsent(resourceIdKey, resource);
            if (existingResource != null) {
                return existingResource;
            }
        }
        return resource;
    }

    private Resource createResourceForPaths(String resourceId, List<String> resourcePaths, LocaleProvider localeProvider) {
        ArrayList<Resource> resources = new ArrayList<Resource>(resourcePaths.size());
        String extension = null;
        for (String resourcePath : resourcePaths) {
            int index;
            Resource resource = this.getResourceForPath(resourcePath, localeProvider, null);
            if (resource == null) {
                return null;
            }
            resources.add(resource);
            if (extension != null || (index = resourcePath.lastIndexOf(46)) == -1) continue;
            extension = resourcePath.substring(index + 1);
        }
        if (extension != null) {
            resourceId = (String)resourceId + "." + extension;
        }
        ResourcesEntry entry = new ResourcesEntry((String)resourceId, resources);
        this.generateLocalResourcesAndExternalUrl(entry);
        return entry;
    }

    private String getResourceIdForResourcePaths(List<String> resourcePaths) {
        StringBuilder resourcePathIds = new StringBuilder();
        for (String resourcePath : resourcePaths) {
            if (resourcePathIds.length() > 0) {
                resourcePathIds.append(File.pathSeparator);
            }
            resourcePathIds.append(resourcePath);
        }
        return ResourceSupport.getHash(resourcePathIds.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshResourcesEntry(ResourcesEntry resources) {
        boolean isRefreshed = false;
        ResourcesEntry resourcesEntry = resources;
        synchronized (resourcesEntry) {
            for (Resource resource : resources.getResources()) {
                if (!this.refreshResource(resource)) continue;
                isRefreshed = true;
            }
            if (isRefreshed) {
                this.generateLocalResourcesAndExternalUrl(resources);
            }
        }
        return isRefreshed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateLocalResourcesAndExternalUrl(ResourcesEntry entry) {
        File outputFile = this.getOutputFile(entry.getResourceId());
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
            Iterator<Resource> iterator = entry.getResources().iterator();
            while (iterator.hasNext()) {
                Resource resource;
                Resource resource2 = resource = iterator.next();
                synchronized (resource2) {
                    URL url = resource.getLocalUrl();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        out.write(line);
                        out.write(10);
                    }
                    reader.close();
                }
            }
            out.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("error constructing resource", ex);
        }
        URL localUrl = this.getFileAsUrl(outputFile);
        entry.setLocalUrl(localUrl);
        entry.setContentLength(outputFile.length());
        String key = this.getResourceKey(localUrl);
        String externalId = this.constructExternalId(entry.getResourceId(), key);
        String externalUrl = this.constructExternalUrl(externalId);
        entry.setExternalId(externalId);
        entry.setExternalUrl(externalUrl);
        this._resourceEntriesByExternalId.put(externalId, entry);
    }

    private String getLocalUrlAsResourceName(URL url) {
        String name = url.toExternalForm();
        int index = name.lastIndexOf(33);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    private File getOutputFile(String path) {
        path.replace(':', File.separatorChar);
        File file = new File(this._tempDir, path);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return file;
    }

    private URL getFileAsUrl(File outputFile) {
        try {
            URI uri = outputFile.toURI();
            return uri.toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("couldn't make url from file: " + outputFile, ex);
        }
    }

    private static class LocaleProviderImpl
    implements LocaleProvider {
        private final Locale _locale;

        public LocaleProviderImpl(Locale locale) {
            this._locale = locale;
        }

        public Locale getLocale() {
            return this._locale;
        }

        public boolean isValidLocaleString(String s) {
            return "en".equalsIgnoreCase(s);
        }

        public boolean isValidLocale(Locale locale) {
            return locale.getDisplayName().equalsIgnoreCase("en");
        }
    }
}

