/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.resources;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class ResourceSupport {
    ResourceSupport() {
    }

    public static String getHash(InputStream in) throws IOException {
        int rc;
        MessageDigest digester = ResourceSupport.getDigester();
        byte[] buffer = new byte[1024];
        while ((rc = in.read(buffer)) != -1) {
            digester.update(buffer, 0, rc);
        }
        return ResourceSupport.getDistestAsKey(digester);
    }

    public static String getHash(String value) {
        MessageDigest digester = ResourceSupport.getDigester();
        digester.update(value.getBytes());
        return ResourceSupport.getDistestAsKey(digester);
    }

    private static MessageDigest getDigester() {
        MessageDigest digester = null;
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return digester;
    }

    private static String getDistestAsKey(MessageDigest digester) {
        byte[] digest = digester.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }
}

