/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.search;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.exceptions.NoSuchStopServiceException;
import org.onebusaway.exceptions.OutOfServiceAreaServiceException;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.geocoder.enterprise.services.EnterpriseGeocoderResult;
import org.onebusaway.geocoder.enterprise.services.EnterpriseGeocoderService;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.presentation.impl.RouteComparator;
import org.onebusaway.presentation.model.SearchResult;
import org.onebusaway.presentation.model.SearchResultCollection;
import org.onebusaway.presentation.services.search.SearchResultFactory;
import org.onebusaway.presentation.services.search.SearchService;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.RoutesBean;
import org.onebusaway.transit_data.model.SearchQueryBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopGroupBean;
import org.onebusaway.transit_data.model.StopGroupingBean;
import org.onebusaway.transit_data.model.StopsBean;
import org.onebusaway.transit_data.model.StopsForRouteBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.util.services.configuration.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchServiceImpl
implements SearchService {
    private static final Logger _log = LoggerFactory.getLogger(SearchServiceImpl.class);
    private static final Pattern leftOverMatchPattern = Pattern.compile("^([A-Z]|-)+$");
    private static final Pattern latLonPattern = Pattern.compile("^([-+]?)([1-8]?\\d(\\.\\d+)?|90(\\.0+)?),\\s*([-+]?)(180(\\.0+)?|((1[0-7]\\d)|([1-9]?\\d))(\\.\\d+)?)$");
    private static final double DISTANCE_TO_ROUTES = 600.0;
    private static final int MAX_ROUTES = 10;
    private static final int DISTANCE_TO_STOPS = 600;
    private static final int MAX_STOPS = 10;
    @Autowired
    private ConfigurationService _configurationService;
    @Autowired
    private EnterpriseGeocoderService _geocoderService;
    @Autowired
    private TransitDataService _transitDataService;
    private Map<String, List<RouteBean>> _routeShortNameToRouteBeanMap = new HashMap<String, List<RouteBean>>();
    private Map<String, RouteBean> _routeIdToRouteBeanMap = new HashMap<String, RouteBean>();
    private Map<String, List<RouteBean>> _routeLongNameToRouteBeanMap = new HashMap<String, List<RouteBean>>();
    private Map<String, String> _stopCodeToStopIdMap = new HashMap<String, String>();
    private Map<String, Set<String>> _unqualifiedStopIdToStopIdMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> _stopNameToStopIdMap = new HashMap<String, Set<String>>();
    private String _bundleIdForCaches = null;
    private Boolean _agencyIdHasSpaces = null;
    private List<String> _agencyIds = null;

    public void refreshCachesIfNecessary() {
        String currentBundleId = this._transitDataService.getActiveBundleId();
        if (this._bundleIdForCaches != null && this._bundleIdForCaches.equals(currentBundleId) || currentBundleId == null) {
            return;
        }
        this._bundleIdForCaches = this._transitDataService.getActiveBundleId();
        this.refreshCaches();
    }

    private synchronized void refreshCaches() {
        this._routeShortNameToRouteBeanMap.clear();
        this._routeIdToRouteBeanMap.clear();
        this._routeLongNameToRouteBeanMap.clear();
        this._stopCodeToStopIdMap.clear();
        this._unqualifiedStopIdToStopIdMap.clear();
        this._stopNameToStopIdMap.clear();
        for (AgencyWithCoverageBean agency : this._transitDataService.getAgenciesWithCoverage()) {
            for (RouteBean routeBean : this._transitDataService.getRoutesForAgencyId(agency.getAgency().getId()).getList()) {
                if (routeBean.getShortName() != null) {
                    if (this._routeShortNameToRouteBeanMap.containsKey(routeBean.getShortName().toUpperCase())) {
                        this._routeShortNameToRouteBeanMap.get(routeBean.getShortName().toUpperCase()).add(routeBean);
                    } else {
                        this._routeShortNameToRouteBeanMap.put(routeBean.getShortName().toUpperCase(), new ArrayList<RouteBean>(Arrays.asList(routeBean)));
                    }
                }
                if (routeBean.getLongName() != null) {
                    if (this._routeLongNameToRouteBeanMap.containsKey(routeBean.getLongName())) {
                        this._routeLongNameToRouteBeanMap.get(routeBean.getLongName()).add(routeBean);
                    } else {
                        this._routeLongNameToRouteBeanMap.put(routeBean.getLongName(), new ArrayList<RouteBean>(Arrays.asList(routeBean)));
                    }
                }
                this._routeIdToRouteBeanMap.put(routeBean.getId(), routeBean);
            }
            List stopsList = this._transitDataService.getAllRevenueStops(agency);
            for (StopBean stop : stopsList) {
                String unqualifiedId = AgencyAndIdLibrary.convertFromString((String)stop.getId()).getId();
                if (!this._unqualifiedStopIdToStopIdMap.containsKey(unqualifiedId)) {
                    this._unqualifiedStopIdToStopIdMap.put(unqualifiedId, new HashSet());
                }
                this._unqualifiedStopIdToStopIdMap.get(unqualifiedId).add(stop.getId());
                this._stopCodeToStopIdMap.put(agency.getAgency().getId() + "_" + stop.getCode().toUpperCase(), stop.getId());
                if (!this._stopNameToStopIdMap.containsKey(stop.getName())) {
                    this._stopNameToStopIdMap.put(stop.getName(), new HashSet());
                }
                this._stopNameToStopIdMap.get(stop.getName()).add(stop.getId());
            }
        }
    }

    @Override
    public SearchResultCollection findStopsNearPoint(Double latitude, Double longitude, SearchResultFactory resultFactory, Set<RouteBean> routeFilter) {
        CoordinateBounds bounds = SphericalGeometryLibrary.bounds((double)latitude, (double)longitude, (double)600.0);
        SearchQueryBean queryBean = new SearchQueryBean();
        queryBean.setType(SearchQueryBean.EQueryType.BOUNDS_OR_CLOSEST);
        queryBean.setBounds(bounds);
        queryBean.setMaxCount(100);
        StopsBean stops = this._transitDataService.getStops(queryBean);
        Collections.sort(stops.getStops(), new StopDistanceFromPointComparator(latitude, longitude));
        ArrayList<StopBean> stopsForResults = new ArrayList<StopBean>();
        HashMap routesByDirectionAlreadyInResults = new HashMap();
        HashMap<String, StopsForRouteBean> stopsForRouteLookup = new HashMap<String, StopsForRouteBean>();
        for (StopBean stopBean : stops.getStops()) {
            String agencyId = AgencyAndIdLibrary.convertFromString((String)stopBean.getId()).getAgencyId();
            if (!this._transitDataService.stopHasRevenueService(agencyId, stopBean.getId()).booleanValue()) continue;
            HashMap routesByDirection = new HashMap();
            for (RouteBean route : stopBean.getRoutes()) {
                StopsForRouteBean stopsForRoute = (StopsForRouteBean)stopsForRouteLookup.get(route.getId());
                if (stopsForRoute == null) {
                    stopsForRoute = this._transitDataService.getStopsForRoute(route.getId());
                    stopsForRouteLookup.put(route.getId(), stopsForRoute);
                }
                for (StopGroupingBean stopGrouping : stopsForRoute.getStopGroupings()) {
                    for (StopGroupBean stopGroup : stopGrouping.getStopGroups()) {
                        String directionId = stopGroup.getId();
                        if (!stopGroup.getStopIds().contains(stopBean.getId())) continue;
                        if (!routesByDirection.containsKey(directionId)) {
                            routesByDirection.put(directionId, new ArrayList());
                        }
                        ((List)routesByDirection.get(directionId)).add(route);
                    }
                }
            }
            boolean shouldAddStopToResults = false;
            for (Map.Entry entry : routesByDirection.entrySet()) {
                List additionalRoutes;
                String directionId = (String)entry.getKey();
                List routesForThisDirection = (List)entry.getValue();
                if (!routesByDirectionAlreadyInResults.containsKey(directionId)) {
                    routesByDirectionAlreadyInResults.put(directionId, new ArrayList());
                }
                if ((additionalRoutes = ListUtils.subtract((List)routesForThisDirection, (List)((List)routesByDirectionAlreadyInResults.get(directionId)))).size() <= 0) continue;
                ((List)routesByDirectionAlreadyInResults.get(directionId)).addAll(additionalRoutes);
                shouldAddStopToResults = true;
            }
            if (shouldAddStopToResults) {
                stopsForResults.add(stopBean);
            }
            if (stopsForResults.size() < 10) continue;
            break;
        }
        SearchResultCollection results = new SearchResultCollection();
        results.setHint("findStopsNearPoint");
        results.setGeocode(true);
        results.addRouteFilters(routeFilter);
        for (StopBean stop : stopsForResults) {
            SearchResult result = resultFactory.getStopResult(stop, routeFilter);
            results.addMatch(result);
        }
        return results;
    }

    @Override
    public SearchResultCollection findRoutesStoppingWithinRegion(CoordinateBounds bounds, SearchResultFactory resultFactory) {
        SearchResultCollection results = new SearchResultCollection();
        results.setHint("findRoutesStoppingWithinRegion");
        results.setGeocode(true);
        SearchQueryBean queryBean = new SearchQueryBean();
        queryBean.setType(SearchQueryBean.EQueryType.BOUNDS_OR_CLOSEST);
        queryBean.setBounds(bounds);
        queryBean.setMaxCount(100);
        RoutesBean routes = null;
        try {
            routes = this._transitDataService.getRoutes(queryBean);
        }
        catch (OutOfServiceAreaServiceException e) {
            return results;
        }
        Collections.sort(routes.getRoutes(), new RouteComparator());
        for (RouteBean route : routes.getRoutes()) {
            results.addMatch(resultFactory.getRouteResultForRegion(route));
        }
        return results;
    }

    @Override
    public SearchResultCollection findRoutesStoppingNearPoint(Double latitude, Double longitude, SearchResultFactory resultFactory) {
        CoordinateBounds bounds = SphericalGeometryLibrary.bounds((double)latitude, (double)longitude, (double)600.0);
        SearchResultCollection results = new SearchResultCollection();
        results.setHint("findRoutesStoppingNearPoint");
        SearchQueryBean queryBean = new SearchQueryBean();
        queryBean.setType(SearchQueryBean.EQueryType.BOUNDS_OR_CLOSEST);
        queryBean.setBounds(bounds);
        queryBean.setMaxCount(100);
        RoutesBean routes = null;
        try {
            routes = this._transitDataService.getRoutes(queryBean);
        }
        catch (OutOfServiceAreaServiceException e) {
            return results;
        }
        Collections.sort(routes.getRoutes(), new RouteDistanceFromPointComparator(latitude, longitude));
        for (RouteBean route : routes.getRoutes()) {
            SearchResult result = resultFactory.getRouteResult(route);
            results.addMatch(result);
            if (results.getMatches().size() <= 10) continue;
            break;
        }
        return results;
    }

    @Override
    public SearchResultCollection getSearchResults(String query, SearchResultFactory resultFactory) {
        return this.getSearchResultsForServiceDate(query, resultFactory, null);
    }

    @Override
    public SearchResultCollection getSearchResultsForServiceDate(String query, SearchResultFactory resultFactory, AgencyServiceInterval serviceInterval) {
        this.refreshCachesIfNecessary();
        SearchResultCollection results = new SearchResultCollection();
        boolean hasComma = query.indexOf(44) > 0;
        boolean hasSemiColon = query.indexOf(59) > 0;
        boolean hasHint = query.indexOf(91) > 0;
        String hint = null;
        if (hasHint) {
            hint = query.substring(query.indexOf(91) + 1, query.length() - 1).replace(']', ' ').trim();
            query = query.substring(0, query.indexOf(91));
        }
        this.tryAsLatLon(results, query, resultFactory);
        String normalizedQuery = this.normalizeQuery(results, query, serviceInterval);
        if (results.isEmpty() && hasHint) {
            this.tryAsExactRoute(results, normalizedQuery, hint, resultFactory, serviceInterval);
        }
        if (results.isEmpty() && hasHint) {
            this.tryAsExactStopName(results, hint, resultFactory);
        }
        if (results.isEmpty() && !hasComma) {
            this.tryAsExactRoute(results, null, query.toUpperCase().trim(), resultFactory, serviceInterval);
        }
        if (results.isEmpty() && !hasComma) {
            this.tryAsRoute(results, normalizedQuery, resultFactory, serviceInterval);
        }
        if (results.isEmpty() && hasSemiColon) {
            this.tryAsRoutes(results, normalizedQuery, resultFactory);
        }
        if (results.isEmpty() && !hasComma && (StringUtils.isNumeric((String)normalizedQuery) || normalizedQuery.contains("_"))) {
            this.tryAsStop(results, normalizedQuery, resultFactory, serviceInterval);
        }
        if (results.isEmpty() && !hasComma && StringUtils.isNumeric((String)query)) {
            this.tryAsStop(results, query, resultFactory, serviceInterval);
        }
        if (!"true".equalsIgnoreCase(this._configurationService.getConfigurationValueAsString("display.skipStopNameSearch", "false")) && results.isEmpty() && !hasComma) {
            this.tryAsStopName(results, query, resultFactory);
        }
        if (results.isEmpty() && !hasComma) {
            this.tryAsUnqualifiedStopId(results, query, resultFactory);
        }
        if (results.isEmpty()) {
            this.tryAsGeocode(results, query, resultFactory);
        }
        return results;
    }

    private void tryAsExactStopName(SearchResultCollection results, String stopQuery, SearchResultFactory resultFactory) {
        Set<String> stopIdSet;
        StopBean testStopBean = null;
        try {
            testStopBean = this._transitDataService.getStop(stopQuery);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (testStopBean != null) {
            results.addMatch(resultFactory.getStopResult(testStopBean, results.getRouteFilter()));
            results.setHint("tryAsStop");
            return;
        }
        if (this._stopNameToStopIdMap.containsKey(stopQuery) && (stopIdSet = this._stopNameToStopIdMap.get(stopQuery)).size() == 1) {
            StopBean stopBean = this._transitDataService.getStop(stopIdSet.iterator().next());
            results.addMatch(resultFactory.getStopResult(stopBean, results.getRouteFilter()));
            results.setHint("tryAsStop");
            return;
        }
    }

    private void tryAsStopName(SearchResultCollection results, String q, SearchResultFactory resultFactory) {
        StopsBean beans = this._transitDataService.getStopsByName(q);
        int count = 0;
        if (beans == null || beans.getStops() == null) {
            return;
        }
        for (StopBean stopBean : beans.getStops()) {
            String agencyId = AgencyAndIdLibrary.convertFromString((String)stopBean.getId()).getAgencyId();
            if (this._transitDataService.stopHasRevenueService(agencyId, stopBean.getId()).booleanValue()) {
                results.addSuggestion(resultFactory.getStopResult(stopBean, results.getRouteFilter()));
                results.setHint("tryAsStopName");
                ++count;
            }
            if (count <= 10) continue;
            break;
        }
    }

    private void tryAsUnqualifiedStopId(SearchResultCollection results, String q, SearchResultFactory resultFactory) {
        Set<String> potentialStops = this._unqualifiedStopIdToStopIdMap.get(q);
        if (potentialStops != null && potentialStops.size() == 1) {
            StopBean stopBean = this._transitDataService.getStop(potentialStops.iterator().next());
            results.addMatch(resultFactory.getStopResult(stopBean, results.getRouteFilter()));
            results.setHint("tryAsUnqualifiedStopId");
        }
    }

    private String normalizeQuery(SearchResultCollection results, String q, AgencyServiceInterval serviceInterval) {
        String agencyMatch;
        if (q == null) {
            return null;
        }
        q = URLDecoder.decode(q);
        q = q.trim();
        q = q.replace(",", " ");
        q = q.replace(";", " ");
        ArrayList<Object> tokens = new ArrayList<Object>();
        if (Boolean.TRUE.equals(this.configuredAgencyIdHasSpaces()) && (agencyMatch = this.matchAgencyIds(q)) != null) {
            q = q.replace(agencyMatch, "");
            tokens.add(agencyMatch);
        }
        StringTokenizer tokenizer = new StringTokenizer(q, " +", true);
        if (this.configuredAgencyIdHasSpaces().booleanValue() && !tokens.isEmpty() && tokenizer.hasMoreTokens()) {
            String peek = tokenizer.nextToken().trim();
            if (peek.contains("_")) {
                tokens.set(0, (String)tokens.get(0) + peek);
            } else if (!StringUtils.isEmpty((String)peek)) {
                tokens.add(peek);
            }
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (StringUtils.isEmpty((String)token)) continue;
            tokens.add(token);
        }
        Object normalizedQuery = "";
        for (int i = 0; i < tokens.size(); ++i) {
            String token = (String)tokens.get(i);
            String lastItem = null;
            String nextItem = null;
            if (i - 1 >= 0) {
                lastItem = (String)tokens.get(i - 1);
            }
            if (i + 1 < tokens.size()) {
                nextItem = (String)tokens.get(i + 1);
            }
            if (this._routeShortNameToRouteBeanMap.containsKey(token.toUpperCase())) {
                if (lastItem != null && !this._routeShortNameToRouteBeanMap.containsKey(lastItem.toUpperCase()) || nextItem != null && !this._routeShortNameToRouteBeanMap.containsKey(nextItem.toUpperCase())) {
                    results.addRouteFilter(this._routeShortNameToRouteBeanMap.get(token.toUpperCase()).get(0));
                    continue;
                }
            } else if ((lastItem != null && this.stopsForId(lastItem, serviceInterval).size() > 0 && !this._routeShortNameToRouteBeanMap.containsKey(lastItem.toUpperCase()) || nextItem != null && this.stopsForId(nextItem, serviceInterval).size() > 0 && !this._routeShortNameToRouteBeanMap.containsKey(nextItem.toUpperCase())) && !token.contains("_")) continue;
            if (token.equals("+")) {
                if (this._routeShortNameToRouteBeanMap.containsKey(nextItem.toUpperCase())) continue;
                token = "and";
            }
            normalizedQuery = (String)normalizedQuery + token + " ";
        }
        if (results.getRouteFilter() != null && results.getRouteFilter().size() > 1) {
            results.getRouteFilter().clear();
        }
        return ((String)normalizedQuery).trim();
    }

    private Boolean configuredAgencyIdHasSpaces() {
        if (this._agencyIdHasSpaces == null) {
            Boolean agencyIdHasSpaces = Boolean.FALSE;
            for (String id : this.getAgencyIds()) {
                if (!id.contains(" ")) continue;
                agencyIdHasSpaces = Boolean.TRUE;
                break;
            }
            if (this._agencyIdHasSpaces == null) {
                this._agencyIdHasSpaces = agencyIdHasSpaces;
            }
        }
        return this._agencyIdHasSpaces;
    }

    private String matchAgencyIds(String q) {
        for (String id : this.filterToOnlySpaces(this.getAgencyIds())) {
            if (!q.contains(id)) continue;
            return id;
        }
        return null;
    }

    private List<String> filterToOnlySpaces(List<String> agencyIds) {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String agencyId : agencyIds) {
            if (!agencyId.contains(" ")) continue;
            filtered.add(agencyId);
        }
        return filtered;
    }

    private List<String> getAgencyIds() {
        if (this._agencyIds == null) {
            ArrayList<String> agencyIds = new ArrayList<String>();
            for (AgencyWithCoverageBean agenciesWithCoverage : this._transitDataService.getAgenciesWithCoverage()) {
                agencyIds.add(agenciesWithCoverage.getAgency().getId());
            }
            if (this._agencyIds == null) {
                this._agencyIds = agencyIds;
            }
        }
        return this._agencyIds;
    }

    private void tryAsLatLon(SearchResultCollection results, String rawQuery, SearchResultFactory resultFactory) {
        Object routesNearby = null;
        Matcher m = latLonPattern.matcher(rawQuery);
        if (m.find()) {
            String latStr = m.group(1) + m.group(2);
            String lonStr = m.group(5) + m.group(6);
            _log.info("parse lat/lon = " + latStr + ", " + lonStr);
            try {
                Double lat = Double.parseDouble(latStr);
                Double lon = Double.parseDouble(lonStr);
                SimpleEnterpriseGeocoderResult egr = new SimpleEnterpriseGeocoderResult(lat, lon);
                _log.info("found lat/lon");
                results.addMatch(resultFactory.getGeocoderResult(egr, results.getRouteFilter()));
                results.setHint("tryAsLatLon");
            }
            catch (Exception any) {
                _log.info("no results, exception=" + any);
            }
        }
    }

    private void tryAsExactRoute(SearchResultCollection results, String additionalTerm, String expectedTerm, SearchResultFactory resultFactory, AgencyServiceInterval serviceInterval) {
        AgencyAndId routeId;
        List<RouteBean> routeBeans;
        RouteBean testRouteBean = null;
        try {
            testRouteBean = this._transitDataService.getRouteForId(expectedTerm);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        if (testRouteBean != null) {
            results.addMatch(resultFactory.getRouteResult(testRouteBean));
            results.setHint("tryAsRoute");
            return;
        }
        if (this._routeShortNameToRouteBeanMap.get(expectedTerm) != null) {
            routeBeans = this._routeShortNameToRouteBeanMap.get(expectedTerm);
            if (routeBeans.size() == 1) {
                results.addMatch(resultFactory.getRouteResult(routeBeans.get(0)));
                results.setHint("tryAsRoute");
                return;
            }
            if (additionalTerm != null) {
                for (RouteBean routeBean : this._routeShortNameToRouteBeanMap.get(expectedTerm)) {
                    routeId = AgencyAndIdLibrary.convertFromString((String)routeBean.getId());
                    if (!routeId.getId().equalsIgnoreCase(additionalTerm)) continue;
                    results.addMatch(resultFactory.getRouteResult(routeBean));
                    results.setHint("tryAsRoute");
                    return;
                }
            }
        }
        if (this._routeLongNameToRouteBeanMap.get(expectedTerm) != null) {
            routeBeans = this._routeLongNameToRouteBeanMap.get(expectedTerm);
            if (routeBeans.size() == 1) {
                results.addMatch(resultFactory.getRouteResult(routeBeans.get(0)));
                results.setHint("tryAsRoute");
                return;
            }
            if (additionalTerm != null) {
                for (RouteBean routeBean : this._routeLongNameToRouteBeanMap.get(expectedTerm)) {
                    routeId = AgencyAndIdLibrary.convertFromString((String)routeBean.getId());
                    if (!routeId.getId().equalsIgnoreCase(additionalTerm)) continue;
                    results.addMatch(resultFactory.getRouteResult(routeBean));
                    results.setHint("tryAsRoute");
                    return;
                }
            }
        }
    }

    private void tryAsRoute(SearchResultCollection results, String routeQueryMixedCase, SearchResultFactory resultFactory, AgencyServiceInterval serviceInterval) {
        String routeQuery = new String(routeQueryMixedCase);
        if (routeQuery == null || StringUtils.isEmpty((String)routeQuery)) {
            return;
        }
        if ((routeQuery = routeQuery.toUpperCase().trim()).length() < 1) {
            return;
        }
        if (this._routeIdToRouteBeanMap.get(routeQueryMixedCase) != null) {
            RouteBean routeBean = this._routeIdToRouteBeanMap.get(routeQueryMixedCase);
            results.addMatch(resultFactory.getRouteResult(routeBean));
            results.setHint("tryAsRoute");
            return;
        }
        if (this._routeIdToRouteBeanMap.get(routeQuery) != null) {
            RouteBean routeBean = this._routeIdToRouteBeanMap.get(routeQuery);
            results.addMatch(resultFactory.getRouteResult(routeBean));
            results.setHint("tryAsRoute");
            return;
        }
        if (this._routeShortNameToRouteBeanMap.get(routeQuery) != null) {
            for (RouteBean routeBean : this._routeShortNameToRouteBeanMap.get(routeQuery)) {
                results.addMatch(resultFactory.getRouteResult(routeBean));
                results.setHint("tryAsRoute");
            }
        }
        for (String routeShortName : this._routeShortNameToRouteBeanMap.keySet()) {
            String leftOvers = routeShortName.replace(routeQuery, "");
            Matcher matcher = leftOverMatchPattern.matcher(leftOvers);
            Boolean leftOversAreDiscardable = matcher.find();
            if (routeQuery.equals(routeShortName) || (!routeShortName.startsWith(routeQuery) || !leftOversAreDiscardable.booleanValue()) && (!routeShortName.endsWith(routeQuery) || !leftOversAreDiscardable.booleanValue())) continue;
            try {
                for (RouteBean routeBean : this._routeShortNameToRouteBeanMap.get(routeShortName)) {
                    results.addSuggestion(resultFactory.getRouteResult(routeBean));
                    results.setHint("tryAsRoute");
                }
            }
            catch (OutOfServiceAreaServiceException outOfServiceAreaServiceException) {
            }
        }
        for (String routeLongName : this._routeLongNameToRouteBeanMap.keySet()) {
            if (!routeLongName.contains(routeQuery + " ") && !routeLongName.contains(" " + routeQuery)) continue;
            try {
                for (RouteBean routeBean : this._routeLongNameToRouteBeanMap.get(routeLongName)) {
                    results.addSuggestion(resultFactory.getRouteResult(routeBean));
                    results.setHint("tryAsRoute");
                }
            }
            catch (OutOfServiceAreaServiceException outOfServiceAreaServiceException) {
            }
        }
    }

    private void tryAsRoutes(SearchResultCollection results, String routeQueryMixedCase, SearchResultFactory resultFactory) {
        String routeQuery = new String(routeQueryMixedCase);
        if (routeQuery == null || StringUtils.isEmpty((String)routeQuery)) {
            return;
        }
        if ((routeQuery = routeQuery.toUpperCase().trim()).length() < 1) {
            return;
        }
        ArrayList<String> routeTokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(routeQuery, " ", true);
        while (tokenizer.hasMoreTokens()) {
            String routeToken = tokenizer.nextToken().trim();
            if (StringUtils.isEmpty((String)routeToken)) continue;
            routeTokens.add(routeToken);
        }
        for (String route : routeTokens) {
            if (this._routeIdToRouteBeanMap.get(route) != null) {
                RouteBean routeBean = this._routeIdToRouteBeanMap.get(route);
                results.addMatch(resultFactory.getRouteResult(routeBean));
                results.setHint("tryAsRoute");
            }
            if (this._routeShortNameToRouteBeanMap.get(route) == null) continue;
            for (RouteBean routeBean : this._routeShortNameToRouteBeanMap.get(route)) {
                results.addMatch(resultFactory.getRouteResult(routeBean));
                results.setHint("tryAsRoute");
            }
        }
    }

    private void tryAsStop(SearchResultCollection results, String stopQuery, SearchResultFactory resultFactory, AgencyServiceInterval serviceInterval) {
        if (stopQuery == null || StringUtils.isEmpty((String)stopQuery)) {
            return;
        }
        List<StopBean> matches = this.stopsForId(stopQuery = stopQuery.trim(), serviceInterval);
        if (matches.size() > 0) {
            for (StopBean stopBean : matches) {
                String agencyId = AgencyAndIdLibrary.convertFromString((String)stopBean.getId()).getAgencyId();
                if (!this._transitDataService.stopHasRevenueService(agencyId, stopBean.getId()).booleanValue()) continue;
                results.addMatch(resultFactory.getStopResult(stopBean, results.getRouteFilter()));
                results.setHint("tryAsStop");
            }
        } else {
            for (StopBean match : matches) {
                String agencyId = AgencyAndIdLibrary.convertFromString((String)match.getId()).getAgencyId();
                if (!this._transitDataService.stopHasRevenueService(agencyId, match.getId()).booleanValue()) continue;
                results.addSuggestion(resultFactory.getStopResult(match, results.getRouteFilter()));
                results.setHint("tryAsStop");
            }
        }
    }

    private void tryAsGeocode(SearchResultCollection results, String query, SearchResultFactory resultFactory) {
        List geocoderResults = this._geocoderService.enterpriseGeocode(query);
        if (geocoderResults == null) {
            return;
        }
        for (EnterpriseGeocoderResult result : geocoderResults) {
            if (geocoderResults.size() == 1) {
                results.addMatch(resultFactory.getGeocoderResult(result, results.getRouteFilter()));
                results.setGeocode(true);
                results.setHint("tryAsGeocode");
                continue;
            }
            results.addSuggestion(resultFactory.getGeocoderResult(result, results.getRouteFilter()));
            results.setGeocode(true);
            results.setHint("tryAsGeocode");
        }
    }

    private List<StopBean> stopsForId(String id, AgencyServiceInterval serviceInterval) {
        ArrayList<StopBean> matches = new ArrayList<StopBean>();
        if (id.contains("_")) {
            try {
                StopBean potentialStop = serviceInterval != null ? this._transitDataService.getStopForServiceDate(id, serviceInterval) : this._transitDataService.getStop(id);
                if (potentialStop != null) {
                    matches.add(potentialStop);
                    return matches;
                }
            }
            catch (NoSuchStopServiceException noSuchStopServiceException) {
                // empty catch block
            }
        }
        for (AgencyWithCoverageBean agency : this._transitDataService.getAgenciesWithCoverage()) {
            AgencyAndId potentialStopId = new AgencyAndId(agency.getAgency().getId(), id);
            try {
                StopBean potentialStop = serviceInterval == null ? this._transitDataService.getStop(potentialStopId.toString()) : this._transitDataService.getStopForServiceDate(potentialStopId.toString(), serviceInterval);
                if (potentialStop == null) continue;
                matches.add(potentialStop);
            }
            catch (NoSuchStopServiceException ex) {
                try {
                    StopBean potentialStop;
                    if (!matches.isEmpty() || (potentialStop = serviceInterval == null ? this._transitDataService.getStop(this.getStopIdFromStopCode(potentialStopId.toString())) : this._transitDataService.getStopForServiceDate(this.getStopIdFromStopCode(potentialStopId.toString()), serviceInterval)) == null) continue;
                    matches.add(potentialStop);
                }
                catch (NoSuchStopServiceException ex2) {}
            }
        }
        return matches;
    }

    private String getStopIdFromStopCode(String code) {
        if (code != null && this._stopCodeToStopIdMap.containsKey(code.toUpperCase())) {
            return this._stopCodeToStopIdMap.get(code.toUpperCase());
        }
        return code;
    }

    public static class SimpleEnterpriseGeocoderResult
    implements EnterpriseGeocoderResult {
        private Double lat = null;
        private Double lon = null;

        public SimpleEnterpriseGeocoderResult(Double lat, Double lon) {
            this.lat = lat;
            this.lon = lon;
        }

        public Double getLatitude() {
            return this.lat;
        }

        public Double getLongitude() {
            return this.lon;
        }

        public String getNeighborhood() {
            return null;
        }

        public String getFormattedAddress() {
            return this.lat + ", " + this.lon;
        }

        public CoordinateBounds getBounds() {
            return new CoordinateBounds(this.lat.doubleValue(), this.lon.doubleValue());
        }

        public boolean isRegion() {
            return false;
        }
    }

    private class RouteDistanceFromPointComparator
    implements Comparator<RouteBean> {
        private double lat;
        private double lon;

        public RouteDistanceFromPointComparator(double lat, double lon) {
            this.lat = lat;
            this.lon = lon;
        }

        @Override
        public int compare(RouteBean o1, RouteBean o2) {
            Double d1 = this.getDistanceToNearestStopOnRoute(o1);
            Double d2 = this.getDistanceToNearestStopOnRoute(o2);
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }

        private Double getDistanceToNearestStopOnRoute(RouteBean route) {
            StopsForRouteBean stopsBean = SearchServiceImpl.this._transitDataService.getStopsForRoute(route.getId());
            Double minDistanceToRoute = null;
            for (StopBean stop : stopsBean.getStops()) {
                Double distance = SphericalGeometryLibrary.distanceFaster((double)stop.getLat(), (double)stop.getLon(), (double)this.lat, (double)this.lon);
                if (minDistanceToRoute == null) {
                    minDistanceToRoute = distance;
                    continue;
                }
                if (!(distance < minDistanceToRoute)) continue;
                minDistanceToRoute = distance;
            }
            return minDistanceToRoute;
        }
    }

    private class StopDistanceFromPointComparator
    implements Comparator<StopBean> {
        private double lat;
        private double lon;

        public StopDistanceFromPointComparator(double lat, double lon) {
            this.lat = lat;
            this.lon = lon;
        }

        @Override
        public int compare(StopBean o1, StopBean o2) {
            double d2;
            double d1 = SphericalGeometryLibrary.distanceFaster((double)this.lat, (double)this.lon, (double)o1.getLat(), (double)o1.getLon());
            if (d1 < (d2 = SphericalGeometryLibrary.distanceFaster((double)this.lat, (double)this.lon, (double)o2.getLat(), (double)o2.getLon()))) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

