/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.service_alerts;

import org.onebusaway.exceptions.NoSuchStopServiceException;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.presentation.impl.service_alerts.NotificationStrategy;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NameBasedNotificationStrategyImpl
implements NotificationStrategy {
    private static Logger _log = LoggerFactory.getLogger(NameBasedNotificationStrategyImpl.class);
    @Autowired
    private TransitDataService _tds;

    @Override
    public String summarizeRoute(String routeIdStr) {
        if (routeIdStr == null) {
            return null;
        }
        try {
            AgencyAndId routeId = AgencyAndIdLibrary.convertFromString((String)routeIdStr);
            RouteBean route = this._tds.getRouteForId(routeIdStr);
            if (route == null || route.getShortName() == null) {
                return routeIdStr;
            }
            return route.getShortName();
        }
        catch (IllegalStateException ise) {
            return routeIdStr;
        }
    }

    @Override
    public String summarizeStop(String stopIdStr) {
        try {
            AgencyAndId routeId = AgencyAndIdLibrary.convertFromString((String)stopIdStr);
            StopBean stop = this._tds.getStop(routeId.toString());
            if (stop == null || stop.getName() == null) {
                return stopIdStr;
            }
            return stop.getName();
        }
        catch (IllegalStateException ise) {
            return stopIdStr;
        }
        catch (NoSuchStopServiceException nsse) {
            _log.error("couldn't find stop for stopId=|" + stopIdStr + "|");
            return stopIdStr;
        }
    }
}

