/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.service_alerts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.presentation.services.realtime.RealtimeService;
import org.onebusaway.siri.OneBusAwayConsequence;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopGroupBean;
import org.onebusaway.transit_data.model.StopGroupingBean;
import org.onebusaway.transit_data.model.StopsForRouteBean;
import org.onebusaway.transit_data.model.service_alerts.EEffect;
import org.onebusaway.transit_data.model.service_alerts.NaturalLanguageStringBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.SituationAffectsBean;
import org.onebusaway.transit_data.model.service_alerts.SituationConsequenceBean;
import org.onebusaway.transit_data.model.service_alerts.SituationQueryBean;
import org.onebusaway.transit_data.model.service_alerts.TimeRangeBean;
import org.onebusaway.transit_data.services.TransitDataService;
import uk.org.siri.siri.AffectedOperatorStructure;
import uk.org.siri.siri.AffectedStopPointStructure;
import uk.org.siri.siri.AffectedVehicleJourneyStructure;
import uk.org.siri.siri.AffectsScopeStructure;
import uk.org.siri.siri.DefaultedTextStructure;
import uk.org.siri.siri.DirectionRefStructure;
import uk.org.siri.siri.EntryQualifierStructure;
import uk.org.siri.siri.ExtensionsStructure;
import uk.org.siri.siri.HalfOpenTimestampRangeStructure;
import uk.org.siri.siri.InfoLinkStructure;
import uk.org.siri.siri.LineRefStructure;
import uk.org.siri.siri.MonitoredStopVisitStructure;
import uk.org.siri.siri.NaturalLanguageStringStructure;
import uk.org.siri.siri.PtConsequenceStructure;
import uk.org.siri.siri.PtConsequencesStructure;
import uk.org.siri.siri.PtSituationElementStructure;
import uk.org.siri.siri.RoadSituationElementStructure;
import uk.org.siri.siri.ServiceConditionEnumeration;
import uk.org.siri.siri.ServiceDelivery;
import uk.org.siri.siri.SeverityEnumeration;
import uk.org.siri.siri.SituationExchangeDeliveryStructure;
import uk.org.siri.siri.SituationRefStructure;
import uk.org.siri.siri.StopPointRefStructure;
import uk.org.siri.siri.VehicleActivityStructure;
import uk.org.siri.siri.WorkflowStatusEnumeration;

public class ServiceAlertsHelper {
    public void addSituationExchangeToSiriForStops(ServiceDelivery serviceDelivery, List<MonitoredStopVisitStructure> visits, TransitDataService transitDataService, List<AgencyAndId> stopIds) {
        HashMap<String, PtSituationElementStructure> ptSituationElements = new HashMap<String, PtSituationElementStructure>();
        for (MonitoredStopVisitStructure visit : visits) {
            if (visit.getMonitoredVehicleJourney() == null) continue;
            this.addSituationElement(transitDataService, ptSituationElements, visit.getMonitoredVehicleJourney().getSituationRef());
        }
        long time = System.currentTimeMillis();
        if (stopIds != null && stopIds.size() > 0) {
            for (AgencyAndId stopId : stopIds) {
                String stopIdString = stopId.toString();
                SituationQueryBean query = new SituationQueryBean();
                ArrayList<String> stopIdStrings = new ArrayList<String>();
                stopIdStrings.add(stopIdString);
                SituationQueryBean.AffectsBean affects = new SituationQueryBean.AffectsBean();
                query.getAffects().add(affects);
                affects.setStopId(stopIdString);
                query.setTime(time);
                this.addFromQuery(transitDataService, ptSituationElements, query);
                query = new SituationQueryBean();
                query.setTime(time);
                StopBean stopBean = transitDataService.getStop(stopIdString);
                List routes = stopBean.getRoutes();
                for (RouteBean route : routes) {
                    StopsForRouteBean stopsForRoute = transitDataService.getStopsForRoute(route.getId());
                    List stopGroupings = stopsForRoute.getStopGroupings();
                    for (StopGroupingBean stopGrouping : stopGroupings) {
                        if (!stopGrouping.getType().equalsIgnoreCase("direction")) continue;
                        for (StopGroupBean stopGroup : stopGrouping.getStopGroups()) {
                            this.handleStopGroupBean(stopIdString, query, route, stopGroup);
                        }
                    }
                }
                this.addFromQuery(transitDataService, ptSituationElements, query);
            }
        }
        this.addPtSituationElementsToServiceDelivery(serviceDelivery, ptSituationElements);
    }

    private void handleStopGroupBean(String stopIdString, SituationQueryBean query, RouteBean route, StopGroupBean stopGroup) {
        List subGroups = stopGroup.getSubGroups();
        if (subGroups != null && !subGroups.isEmpty()) {
            for (StopGroupBean stopSubGroup : subGroups) {
                this.handleStopGroupBean(stopIdString, query, route, stopSubGroup);
            }
        }
        String direction = stopGroup.getId();
        for (String groupStopId : stopGroup.getStopIds()) {
            if (!groupStopId.equals(stopIdString)) continue;
            SituationQueryBean.AffectsBean affects = new SituationQueryBean.AffectsBean();
            query.getAffects().add(affects);
            affects.setRouteId(route.getId());
            affects.setDirectionId(direction);
        }
    }

    private void addFromQuery(TransitDataService nycTransitDataService, Map<String, PtSituationElementStructure> ptSituationElements, SituationQueryBean queryBean) {
        ListBean serviceAlerts = nycTransitDataService.getServiceAlerts(queryBean);
        ServiceAlertsHelper helper = new ServiceAlertsHelper();
        for (ServiceAlertBean bean : serviceAlerts.getList()) {
            PtSituationElementStructure ptSit = helper.getServiceAlertBeanAsPtSituationElementStructure(bean);
            ptSituationElements.put(ptSit.getSituationNumber().getValue(), ptSit);
        }
    }

    public void addSituationExchangeToServiceDelivery(ServiceDelivery serviceDelivery, Collection<ServiceAlertBean> serviceAlerts) {
        SituationExchangeDeliveryStructure.Situations situations = new SituationExchangeDeliveryStructure.Situations();
        for (ServiceAlertBean serviceAlert : serviceAlerts) {
            situations.getPtSituationElement().add(this.getServiceAlertBeanAsPtSituationElementStructure(serviceAlert));
        }
        if (situations.getPtSituationElement().size() > 0) {
            SituationExchangeDeliveryStructure situationExchangeDelivery = new SituationExchangeDeliveryStructure();
            situationExchangeDelivery.setSituations(situations);
            serviceDelivery.getSituationExchangeDelivery().add(situationExchangeDelivery);
        }
    }

    public void addSituationExchangeToServiceDelivery(ServiceDelivery serviceDelivery, List<VehicleActivityStructure> activities, TransitDataService transitDataService) {
        this.addSituationExchangeToServiceDelivery(serviceDelivery, activities, transitDataService, null);
    }

    public void addSituationExchangeToServiceDelivery(ServiceDelivery serviceDelivery, List<VehicleActivityStructure> activities, TransitDataService transitDataService, List<AgencyAndId> routeIds) {
        HashMap<String, PtSituationElementStructure> ptSituationElements = new HashMap<String, PtSituationElementStructure>();
        if (activities != null) {
            for (VehicleActivityStructure activity : activities) {
                if (activity.getMonitoredVehicleJourney() == null) continue;
                this.addSituationElement(transitDataService, ptSituationElements, activity.getMonitoredVehicleJourney().getSituationRef());
            }
            this.addPtSituationElementsToServiceDelivery(serviceDelivery, ptSituationElements);
        }
        if (routeIds == null) {
            return;
        }
        ArrayList<ServiceAlertBean> serviceAlerts = new ArrayList<ServiceAlertBean>();
        long time = System.currentTimeMillis();
        SituationQueryBean agencyAlerts = new SituationQueryBean();
        SituationQueryBean.AffectsBean agencyAffects = new SituationQueryBean.AffectsBean();
        agencyAlerts.getAffects().add(agencyAffects);
        agencyAffects.setAgencyId(routeIds.get(0).getAgencyId());
        agencyAlerts.setTime(time);
        ListBean serviceAlertsForAgency = transitDataService.getServiceAlerts(agencyAlerts);
        if (serviceAlertsForAgency != null) {
            serviceAlerts.addAll(serviceAlertsForAgency.getList());
        }
        for (AgencyAndId routeId : routeIds) {
            SituationQueryBean query = new SituationQueryBean();
            SituationQueryBean.AffectsBean affects = new SituationQueryBean.AffectsBean();
            query.getAffects().add(affects);
            affects.setRouteId(routeId.toString());
            query.setTime(time);
            ListBean serviceAlertsForRoute = transitDataService.getServiceAlerts(query);
            StopsForRouteBean stopsForRoute = transitDataService.getStopsForRoute(routeId.toString());
            if (stopsForRoute != null) {
                for (StopBean stopBean : stopsForRoute.getStops()) {
                    SituationQueryBean stopRouteQuery = new SituationQueryBean();
                    stopRouteQuery.setTime(time);
                    SituationQueryBean.AffectsBean stopRouteAffects = new SituationQueryBean.AffectsBean();
                    stopRouteQuery.getAffects().add(stopRouteAffects);
                    stopRouteAffects.setRouteId(routeId.toString());
                    stopRouteAffects.setStopId(stopBean.getId());
                    ListBean serviceAlertsForRouteStop = transitDataService.getServiceAlerts(stopRouteQuery);
                    if (serviceAlertsForRouteStop == null) continue;
                    serviceAlerts.addAll(serviceAlertsForRouteStop.getList());
                }
            }
            if (serviceAlertsForRoute == null) continue;
            serviceAlerts.addAll(serviceAlertsForRoute.getList());
        }
        if (serviceAlerts.size() == 0) {
            return;
        }
        this.addSituationExchangeToServiceDelivery(serviceDelivery, serviceAlerts);
    }

    public void addSituationExchangeToServiceDelivery(ServiceDelivery serviceDelivery, Map<String, ServiceAlertBean> currentServiceAlerts) {
        this.addSituationExchangeToServiceDelivery(serviceDelivery, currentServiceAlerts.values());
    }

    public void addClosedSituationExchangesToSiri(ServiceDelivery serviceDelivery, Collection<String> deletedIds) {
        HashMap<String, PtSituationElementStructure> ptSituationElements = new HashMap<String, PtSituationElementStructure>();
        for (String id : deletedIds) {
            PtSituationElementStructure ptSit = new PtSituationElementStructure();
            EntryQualifierStructure value = new EntryQualifierStructure();
            value.setValue(id);
            ptSit.setSituationNumber(value);
            ptSit.setProgress(WorkflowStatusEnumeration.CLOSED);
            ptSituationElements.put(id, ptSit);
        }
        this.addPtSituationElementsToServiceDelivery(serviceDelivery, ptSituationElements);
    }

    private void addSituationElement(TransitDataService transitDataService, Map<String, PtSituationElementStructure> ptSituationElements, List<SituationRefStructure> situationRefs) {
        if (situationRefs == null) {
            return;
        }
        for (SituationRefStructure situationRef : situationRefs) {
            String situationId = situationRef.getSituationSimpleRef().getValue();
            ServiceAlertBean serviceAlert = transitDataService.getServiceAlertForId(situationId);
            PtSituationElementStructure e = this.getServiceAlertBeanAsPtSituationElementStructure(serviceAlert);
            ptSituationElements.put(situationId, e);
        }
    }

    private void addPtSituationElementsToServiceDelivery(ServiceDelivery serviceDelivery, Map<String, PtSituationElementStructure> ptSituationElements) {
        if (serviceDelivery == null || ptSituationElements == null) {
            return;
        }
        SituationExchangeDeliveryStructure situationExchangeDeliveryStructure = serviceDelivery.getSituationExchangeDelivery().size() > 0 ? (SituationExchangeDeliveryStructure)serviceDelivery.getSituationExchangeDelivery().get(0) : new SituationExchangeDeliveryStructure();
        SituationExchangeDeliveryStructure.Situations situations = situationExchangeDeliveryStructure.getSituations();
        if (situations == null) {
            situations = new SituationExchangeDeliveryStructure.Situations();
            situationExchangeDeliveryStructure.setSituations(situations);
        }
        for (PtSituationElementStructure p : ptSituationElements.values()) {
            situations.getPtSituationElement().add(p);
        }
        if (situationExchangeDeliveryStructure.getSituations() != null && situationExchangeDeliveryStructure.getSituations().getPtSituationElement() != null && !situationExchangeDeliveryStructure.getSituations().getPtSituationElement().isEmpty() && !serviceDelivery.getSituationExchangeDelivery().contains(situationExchangeDeliveryStructure)) {
            serviceDelivery.getSituationExchangeDelivery().add(situationExchangeDeliveryStructure);
        }
    }

    public void addGlobalServiceAlertsToServiceDelivery(ServiceDelivery serviceDelivery, RealtimeService realtimeService) {
        List<ServiceAlertBean> serviceAlertBeans = realtimeService.getServiceAlertsGlobal();
        if (serviceAlertBeans == null) {
            return;
        }
        HashMap<String, PtSituationElementStructure> ptSituationElements = new HashMap<String, PtSituationElementStructure>();
        for (ServiceAlertBean serviceAlertBean : serviceAlertBeans) {
            ptSituationElements.put(serviceAlertBean.getId(), this.getServiceAlertBeanAsPtSituationElementStructure(serviceAlertBean));
        }
        this.addPtSituationElementsToServiceDelivery(serviceDelivery, ptSituationElements);
    }

    public PtSituationElementStructure getServiceAlertBeanAsPtSituationElementStructure(ServiceAlertBean serviceAlert) {
        PtSituationElementStructure ptSit = new PtSituationElementStructure();
        EntryQualifierStructure value = new EntryQualifierStructure();
        if (serviceAlert == null) {
            return ptSit;
        }
        value.setValue(serviceAlert.getId());
        ptSit.setSituationNumber(value);
        if (serviceAlert.getCreationTime() != 0L) {
            ptSit.setCreationTime(new Date(serviceAlert.getCreationTime()));
        }
        this.handleDescriptions(serviceAlert, ptSit);
        this.handleOtherFields(serviceAlert, ptSit);
        this.handleAffects(serviceAlert, ptSit);
        this.handleConsequences(serviceAlert, ptSit);
        return ptSit;
    }

    private void handleDescriptions(ServiceAlertBean serviceAlert, PtSituationElementStructure ptSituation) {
        if (serviceAlert == null) {
            return;
        }
        if (serviceAlert.getSummaries() != null) {
            for (NaturalLanguageStringBean summary : serviceAlert.getSummaries()) {
                ptSituation.setSummary(this.createDefaultedTextStructure(summary));
            }
        }
        if (serviceAlert.getDescriptions() != null) {
            for (NaturalLanguageStringBean description : serviceAlert.getDescriptions()) {
                ptSituation.setDescription(this.createDefaultedTextStructure(description));
            }
        }
    }

    private DefaultedTextStructure createDefaultedTextStructure(NaturalLanguageStringBean summary) {
        DefaultedTextStructure d = new DefaultedTextStructure();
        d.setLang(summary.getLang());
        d.setValue(summary.getValue());
        return d;
    }

    private DefaultedTextStructure createDefaultedTextStructure(String text) {
        DefaultedTextStructure d = new DefaultedTextStructure();
        d.setLang("EN");
        d.setValue(text);
        return d;
    }

    private void handleOtherFields(ServiceAlertBean serviceAlert, PtSituationElementStructure ptSituation) {
        if (serviceAlert == null) {
            return;
        }
        if (serviceAlert.getUrls() != null && !serviceAlert.getUrls().isEmpty()) {
            RoadSituationElementStructure.InfoLinks infoLinks = ptSituation.getInfoLinks();
            if (infoLinks == null) {
                infoLinks = new RoadSituationElementStructure.InfoLinks();
                ptSituation.setInfoLinks(infoLinks);
            }
            for (NaturalLanguageStringBean linkBean : serviceAlert.getUrls()) {
                InfoLinkStructure infoLinkStructure = new InfoLinkStructure();
                infoLinkStructure.setUri(linkBean.getValue());
                infoLinks.getInfoLink().add(infoLinkStructure);
            }
        }
        if (serviceAlert.getPublicationWindows() == null) {
            return;
        }
        ptSituation.setSeverity(SeverityEnumeration.UNDEFINED);
        HalfOpenTimestampRangeStructure timestampRangeStructure = new HalfOpenTimestampRangeStructure();
        if (serviceAlert.getPublicationWindows() != null && !serviceAlert.getPublicationWindows().isEmpty()) {
            timestampRangeStructure.setStartTime(this.serviceAlertTimeToDate(((TimeRangeBean)serviceAlert.getPublicationWindows().get(0)).getFrom()));
            timestampRangeStructure.setEndTime(this.serviceAlertTimeToDate(((TimeRangeBean)serviceAlert.getPublicationWindows().get(0)).getTo()));
            ptSituation.setPublicationWindow(timestampRangeStructure);
        }
    }

    public Date serviceAlertTimeToDate(long time) {
        if (time == 0L) {
            return null;
        }
        return new Date(time);
    }

    private void handleAffects(ServiceAlertBean serviceAlert, PtSituationElementStructure ptSituation) {
        if (serviceAlert.getAllAffects() == null) {
            return;
        }
        boolean hasOperators = false;
        AffectsScopeStructure affectsStructure = new AffectsScopeStructure();
        AffectsScopeStructure.VehicleJourneys vehicleJourneys = new AffectsScopeStructure.VehicleJourneys();
        for (SituationAffectsBean affects : serviceAlert.getAllAffects()) {
            String agencyId = affects.getAgencyId();
            if (agencyId != null) {
                AffectsScopeStructure.Operators operators = new AffectsScopeStructure.Operators();
                if (StringUtils.equals((String)agencyId, (String)"__ALL_OPERATORS__")) {
                    operators.setAllOperators("");
                } else {
                    AffectedOperatorStructure affectedOperator = new AffectedOperatorStructure();
                    affectedOperator.setOperatorName((NaturalLanguageStringStructure)this.createDefaultedTextStructure(agencyId));
                    operators.getAffectedOperator().add(affectedOperator);
                }
                affectsStructure.setOperators(operators);
                hasOperators = true;
            }
            String routeId = affects.getRouteId();
            String directionId = affects.getDirectionId();
            String stopId = affects.getStopId();
            if (!StringUtils.isBlank((String)routeId)) {
                AffectedVehicleJourneyStructure affectedVehicleJourneyStructure = new AffectedVehicleJourneyStructure();
                LineRefStructure lineRefStructure = new LineRefStructure();
                lineRefStructure.setValue(routeId);
                affectedVehicleJourneyStructure.setLineRef(lineRefStructure);
                if (!StringUtils.isBlank((String)directionId)) {
                    DirectionRefStructure directionRefStructure = new DirectionRefStructure();
                    directionRefStructure.setValue(directionId);
                    affectedVehicleJourneyStructure.setDirectionRef(directionRefStructure);
                }
                vehicleJourneys.getAffectedVehicleJourney().add(affectedVehicleJourneyStructure);
            }
            if (StringUtils.isBlank((String)stopId)) continue;
            AffectedStopPointStructure stop = new AffectedStopPointStructure();
            StopPointRefStructure stopRef = new StopPointRefStructure();
            stopRef.setValue(stopId);
            stop.setStopPointRef(stopRef);
            if (affectsStructure.getStopPoints() == null) {
                affectsStructure.setStopPoints(new AffectsScopeStructure.StopPoints());
            }
            affectsStructure.getStopPoints().getAffectedStopPoint().add(stop);
        }
        if (vehicleJourneys.getAffectedVehicleJourney().size() > 0) {
            affectsStructure.setVehicleJourneys(vehicleJourneys);
        }
        if (vehicleJourneys.getAffectedVehicleJourney().size() > 0 || hasOperators || affectsStructure.getStopPoints().getAffectedStopPoint().size() > 0) {
            ptSituation.setAffects(affectsStructure);
        }
    }

    private void handleConsequences(ServiceAlertBean serviceAlert, PtSituationElementStructure ptSituation) {
        if (serviceAlert == null) {
            return;
        }
        List consequences = serviceAlert.getConsequences();
        if (consequences == null || consequences.isEmpty()) {
            return;
        }
        PtConsequencesStructure ptConsequences = new PtConsequencesStructure();
        ptSituation.setConsequences(ptConsequences);
        for (SituationConsequenceBean consequence : consequences) {
            String detourPath;
            EEffect effect = consequence.getEffect();
            PtConsequenceStructure ptConsequenceStructure = new PtConsequenceStructure();
            if (effect != null) {
                ServiceConditionEnumeration serviceCondition = this.getEFfectAsCondition(effect);
                ptConsequenceStructure.setCondition(serviceCondition);
            }
            if (!StringUtils.isBlank((String)(detourPath = consequence.getDetourPath()))) {
                ExtensionsStructure extensionStructure = new ExtensionsStructure();
                OneBusAwayConsequence oneBusAwayConsequence = new OneBusAwayConsequence();
                oneBusAwayConsequence.setDiversionPath(detourPath);
                extensionStructure.setAny((Object)oneBusAwayConsequence);
                ptConsequenceStructure.setExtensions(extensionStructure);
            }
            ptConsequences.getConsequence().add(ptConsequenceStructure);
        }
    }

    private ServiceConditionEnumeration getEFfectAsCondition(EEffect effect) {
        switch (effect) {
            case NO_SERVICE: {
                return ServiceConditionEnumeration.NO_SERVICE;
            }
            case SIGNIFICANT_DELAYS: {
                return ServiceConditionEnumeration.DELAYED;
            }
            case DETOUR: {
                return ServiceConditionEnumeration.DIVERTED;
            }
            case ADDITIONAL_SERVICE: {
                return ServiceConditionEnumeration.ADDITIONAL_SERVICE;
            }
            case REDUCED_SERVICE: {
                return ServiceConditionEnumeration.DISRUPTED;
            }
            case MODIFIED_SERVICE: {
                return ServiceConditionEnumeration.ALTERED;
            }
            case OTHER_EFFECT: {
                return ServiceConditionEnumeration.NORMAL_SERVICE;
            }
            case UNKNOWN_EFFECT: {
                return ServiceConditionEnumeration.UNKNOWN;
            }
        }
        return ServiceConditionEnumeration.UNKNOWN;
    }
}

