/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.service_alerts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.CollectionsLibrary;
import org.onebusaway.presentation.impl.service_alerts.RecentSituationComparator;
import org.onebusaway.transit_data.model.service_alerts.ESeverity;
import org.onebusaway.transit_data.model.service_alerts.NaturalLanguageStringBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.SituationAffectsBean;
import org.onebusaway.transit_data.model.service_alerts.TimeRangeBean;
import org.onebusaway.users.client.model.UserBean;
import org.onebusaway.util.SystemTime;

public class SituationsPresentation {
    private static RecentSituationComparator _comparator = new RecentSituationComparator();
    private List<ServiceAlertBean> _situations;
    private UserBean _user;
    private long _time = SystemTime.currentTimeMillis();
    private long _redisplayIfNowActiveThhreshold = 86400000L;
    private String _apiKey = "web";

    public void setApiKey(String apiKey) {
        this._apiKey = apiKey;
    }

    public String getApiKey() {
        return this._apiKey;
    }

    public void setSituations(List<ServiceAlertBean> situations) {
        this._situations = this.determineApplicationSituations(situations);
    }

    public void setUser(UserBean user) {
        this._user = user;
    }

    public void setRedisplayIfNowActiveThreshold(long redisplayIfNowActiveThhreshold) {
        this._redisplayIfNowActiveThhreshold = redisplayIfNowActiveThhreshold;
    }

    public int getTotalCount() {
        return this._situations.size();
    }

    public int getUnreadCount() {
        int unreadServiceAlertCount = 0;
        Map readServiceAlerts = this._user.getReadServiceAlerts();
        for (ServiceAlertBean situation : this._situations) {
            if (!this.isSituationUnread(readServiceAlerts, situation)) continue;
            ++unreadServiceAlertCount;
        }
        return unreadServiceAlertCount;
    }

    public String getUnreadServiceAlertsClass() {
        ESeverity severity = this.getHighestUnreadSeverity();
        if (severity == ESeverity.NO_IMPACT) {
            return "unreadServiceAlertsNoImpactSeverity";
        }
        return "unreadServiceAlertsNormalSeverity";
    }

    public List<ServiceAlertBean> getUnreadSituations() {
        ArrayList<ServiceAlertBean> situations = new ArrayList<ServiceAlertBean>();
        Map readServiceAlerts = this._user.getReadServiceAlerts();
        for (ServiceAlertBean situation : this._situations) {
            if (!this.isSituationUnread(readServiceAlerts, situation)) continue;
            situations.add(situation);
        }
        Collections.sort(situations, _comparator);
        return situations;
    }

    public List<ServiceAlertBean> getReadSituations() {
        ArrayList<ServiceAlertBean> situations = new ArrayList<ServiceAlertBean>();
        Map readServiceAlerts = this._user.getReadServiceAlerts();
        for (ServiceAlertBean situation : this._situations) {
            if (!readServiceAlerts.containsKey(situation.getId())) continue;
            situations.add(situation);
        }
        Collections.sort(situations, _comparator);
        return situations;
    }

    public String getTitle(ServiceAlertBean situation) {
        if (!CollectionsLibrary.isEmpty((Collection)situation.getSummaries())) {
            return this.getValue((NaturalLanguageStringBean)situation.getSummaries().get(0));
        }
        if (!CollectionsLibrary.isEmpty((Collection)situation.getDescriptions())) {
            return this.getValue((NaturalLanguageStringBean)situation.getDescriptions().get(0));
        }
        return null;
    }

    public boolean isSet(NaturalLanguageStringBean bean) {
        return bean != null && bean.getValue() != null && !bean.getValue().trim().isEmpty();
    }

    private String getValue(NaturalLanguageStringBean nls) {
        String value = nls.getValue();
        return value;
    }

    private boolean isSituationUnread(Map<String, Long> readServiceAlerts, ServiceAlertBean situation) {
        if (!this.isSituationInActivePublicationWindow(situation)) {
            return false;
        }
        Long readTime = readServiceAlerts.get(situation.getId());
        if (readTime == null) {
            return true;
        }
        return readTime + this._redisplayIfNowActiveThhreshold < this._time && !this.isSituationActiveAtTime(situation, readTime) && this.isSituationActiveAtTime(situation, this._time);
    }

    private boolean isSituationInActivePublicationWindow(ServiceAlertBean situation) {
        if (CollectionsLibrary.isEmpty((Collection)situation.getPublicationWindows())) {
            return true;
        }
        for (TimeRangeBean window : situation.getPublicationWindows()) {
            if (!this.isTimeRangeActive(window, this._time, true)) continue;
            return true;
        }
        return false;
    }

    private boolean isSituationActiveAtTime(ServiceAlertBean situation, long time) {
        if (CollectionsLibrary.isEmpty((Collection)situation.getActiveWindows())) {
            return true;
        }
        for (TimeRangeBean window : situation.getActiveWindows()) {
            if (!this.isTimeRangeActive(window, this._time, true)) continue;
            return true;
        }
        return false;
    }

    private boolean isTimeRangeActive(TimeRangeBean window, long time, boolean defaultOnUnspecified) {
        if (window == null) {
            return defaultOnUnspecified;
        }
        long from = window.getFrom();
        long to = window.getTo();
        if (from == 0L && to == 0L) {
            return defaultOnUnspecified;
        }
        if (from == 0L && this._time <= to) {
            return true;
        }
        if (to == 0L && from <= this._time) {
            return true;
        }
        return from <= this._time && this._time <= to;
    }

    private ESeverity getHighestUnreadSeverity() {
        ESeverity maxSeverity = null;
        Map readServiceAlerts = this._user.getReadServiceAlerts();
        for (ServiceAlertBean situation : this._situations) {
            if (!this.isSituationUnread(readServiceAlerts, situation)) continue;
            ESeverity s = situation.getSeverity();
            if (s == null) {
                s = ESeverity.UNDEFINED;
            }
            if (maxSeverity != null && maxSeverity.getNumericValue() >= s.getNumericValue()) continue;
            maxSeverity = s;
        }
        return maxSeverity;
    }

    private List<ServiceAlertBean> determineApplicationSituations(List<ServiceAlertBean> situations) {
        ArrayList<ServiceAlertBean> applicable = new ArrayList<ServiceAlertBean>();
        for (ServiceAlertBean situation : situations) {
            if (!this.isSituationApplicable(situation)) continue;
            applicable.add(situation);
        }
        return applicable;
    }

    private boolean isSituationApplicable(ServiceAlertBean situation) {
        HashSet<String> applicationIds = new HashSet<String>();
        for (SituationAffectsBean affects : situation.getAllAffects()) {
            if (affects.getApplicationId() == null) continue;
            applicationIds.add(affects.getApplicationId());
        }
        if (CollectionsLibrary.isEmpty(applicationIds)) {
            return true;
        }
        if (this._apiKey == null) {
            return false;
        }
        return applicationIds.contains(this._apiKey);
    }
}

