/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.struts;

import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.mapper.DefaultActionMapper;
import org.onebusaway.presentation.impl.struts.Prefixed;

public class MultiActionMapper
extends DefaultActionMapper {
    public static final String MAPPINGS = "org.onebusaway.presentation.impl.struts.MultiActionMapper.mapping";
    private List<Prefixed<ActionMapper>> _prefixedActionMappers = new ArrayList<Prefixed<ActionMapper>>();

    @Inject(value="org.onebusaway.presentation.impl.struts.MultiActionMapper.mapping")
    public void setActionMappers(String list) {
        if (list != null) {
            String[] tokens;
            for (String token : tokens = list.split(",")) {
                String[] kvp = token.split("=");
                String key = kvp[0];
                String name = kvp[1];
                ActionMapper mapper = (ActionMapper)this.container.getInstance(ActionMapper.class, name);
                if (mapper == null) {
                    throw new IllegalStateException("unknown ActionMapper " + name);
                }
                this._prefixedActionMappers.add(new Prefixed<ActionMapper>(key, mapper));
            }
        }
    }

    public ActionMapping getMapping(HttpServletRequest request, ConfigurationManager configManager) {
        String uri = request.getRequestURI();
        for (Prefixed<ActionMapper> prefixedActionMapper : this._prefixedActionMappers) {
            String prefix = prefixedActionMapper.getPrefix();
            if (!uri.startsWith(prefix)) continue;
            ActionMapper actionMapper = prefixedActionMapper.getValue();
            return actionMapper.getMapping(request, configManager);
        }
        throw new IllegalArgumentException("no ActionMapper for uri: " + uri);
    }
}

