/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.users;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import org.onebusaway.presentation.impl.users.SetupAction;
import org.onebusaway.presentation.services.InitialSetupService;
import org.springframework.beans.factory.annotation.Autowired;

public class IsSetupInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    private InitialSetupService _initialSetupService;

    @Autowired
    public void setInitialSetupService(InitialSetupService initialSetupService) {
        this._initialSetupService = initialSetupService;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        Class<?> actionType = action.getClass();
        SetupAction annotation = actionType.getAnnotation(SetupAction.class);
        boolean needsSetup = this._initialSetupService.isInitialSetupRequired(false);
        if (annotation != null) {
            if (annotation.onlyAllowIfNotSetup() && !needsSetup) {
                return "AlreadySetup";
            }
            return invocation.invoke();
        }
        if (needsSetup) {
            return "NotSetup";
        }
        return invocation.invoke();
    }
}

