/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.impl.users;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.users.impl.PhoneNumberLibrary;
import org.onebusaway.users.impl.authentication.DefaultUserAuthenticationToken;
import org.onebusaway.users.model.IndexedUserDetails;
import org.onebusaway.users.model.UserIndexKey;
import org.onebusaway.users.services.IndexedUserDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class PhoneNumberLoginInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;
    public static final String RESET_USER = PhoneNumberLoginInterceptor.class.getName() + ".resetUser";
    private IndexedUserDetailsService _indexedUserDetailsService;
    private String _phoneNumberParameterName = "phoneNumber";

    @Autowired
    public void setIndexedUserDetailsService(IndexedUserDetailsService indexedUserDetailsService) {
        this._indexedUserDetailsService = indexedUserDetailsService;
    }

    public void setPhoneNumberParameterName(String phoneNumberParameterName) {
        this._phoneNumberParameterName = phoneNumberParameterName;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        ActionContext context = invocation.getInvocationContext();
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String key : context.getParameters().keySet()) {
            params.put(key, context.getParameters().get((Object)key).getValue());
        }
        String phoneNumber = this.getPhoneNumber(params);
        if ((phoneNumber = PhoneNumberLibrary.normalizePhoneNumber((String)phoneNumber)) != null && phoneNumber.length() > 0) {
            String key;
            key = new UserIndexKey("phoneNumber", phoneNumber);
            if (params.containsKey(RESET_USER)) {
                this._indexedUserDetailsService.resetUserForIndexKey((UserIndexKey)key);
            }
            if (!this.isCurrentUserLoggedInWithKey((UserIndexKey)key)) {
                IndexedUserDetails userDetails = this._indexedUserDetailsService.getOrCreateUserForIndexKey((UserIndexKey)key, "", false);
                DefaultUserAuthenticationToken token = new DefaultUserAuthenticationToken((UserDetails)userDetails);
                SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            }
        }
        return invocation.invoke();
    }

    private String getPhoneNumber(Map<String, Object> params) {
        Object value = params.get(this._phoneNumberParameterName);
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            String[] values = (String[])value;
            if (values.length > 0) {
                return values[0];
            }
        } else {
            return value.toString();
        }
        return null;
    }

    private boolean isCurrentUserLoggedInWithKey(UserIndexKey key) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return false;
        }
        Object principal = authentication.getPrincipal();
        if (!(principal instanceof IndexedUserDetails)) {
            return false;
        }
        IndexedUserDetails details = (IndexedUserDetails)principal;
        UserIndexKey indexKey = details.getUserIndexKey();
        return indexKey.equals((Object)key);
    }
}

