/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.services.cachecontrol;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.presentation.services.cachecontrol.CacheService;
import org.springframework.stereotype.Component;

@Component(value="CacheService")
public class SiriCacheServiceImpl
extends CacheService<Integer, String> {
    private static final int DEFAULT_CACHE_TIMEOUT = 30;
    private static final String SIRI_CACHE_TIMEOUT_KEY = "cache.expiry.siri";

    @Override
    public synchronized Cache<Integer, String> getCache() {
        return this.getCache(30, "SIRI");
    }

    @Override
    @Refreshable(dependsOn={"cache.expiry.siri"})
    protected synchronized void refreshCache() {
        if (this._cache == null) {
            return;
        }
        int timeout = 30;
        _log.info("rebuilding siri cache with " + this._cache.size() + " entries after refresh with timeout=" + timeout + "...");
        ConcurrentMap map = this._cache.asMap();
        this._cache = CacheBuilder.newBuilder().expireAfterWrite((long)timeout, TimeUnit.SECONDS).build();
        for (Map.Entry entry : map.entrySet()) {
            this._cache.put((Object)((Integer)entry.getKey()), (Object)((String)entry.getValue()));
        }
        _log.info("done");
    }

    private Integer hash(int maximumOnwardCalls, List<String> agencies, String outputType) {
        TreeSet<String> set = new TreeSet<String>(agencies);
        return maximumOnwardCalls + set.toString().hashCode() + outputType.hashCode();
    }

    @Override
    public Integer hash(Object ... factors) {
        return this.hash((Integer)factors[0], (List)factors[1], (String)factors[2]);
    }

    @Override
    public void store(Integer key, String value) {
        int timeout = 30;
        super.store(key, value, timeout);
    }
}

