/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.tags;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.struts2.components.ContextBean;
import org.apache.struts2.json.DefaultJSONWriter;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;

public class JsonComponent
extends ContextBean {
    private static final Logger LOG = LoggerFactory.getLogger(JsonComponent.class);
    private boolean _escapeJavaScript = false;
    private boolean _ignoreHierarchy = true;
    private boolean _excludeNullProperties = true;
    private String _value;

    public JsonComponent(ValueStack stack) {
        super(stack);
    }

    public void setValue(String value) {
        this._value = value;
    }

    public void setEscapeJavaScript(boolean escapeJavaScript) {
        this._escapeJavaScript = escapeJavaScript;
    }

    public void setIgnoreHierarchy(boolean ignoreHiearchy) {
        this._ignoreHierarchy = ignoreHiearchy;
    }

    public void setExcludeNullProperties(boolean excludeNullProperties) {
        this._excludeNullProperties = excludeNullProperties;
    }

    public boolean end(Writer writer, String body) {
        if (this._value == null) {
            this._value = "top";
        }
        Object value = this.findValue(this._value);
        String json = null;
        if (json != null) {
            if (this._escapeJavaScript) {
                json = StringEscapeUtils.escapeEcmaScript(json);
            }
            if (this.getVar() != null) {
                List empty = Collections.emptyList();
                try {
                    json = new DefaultJSONWriter().write(value, empty, empty, this._excludeNullProperties);
                }
                catch (JSONException e) {
                    LOG.error("Could not write out json value", (Throwable)e, new String[0]);
                }
                this.putInContext(json);
            } else {
                try {
                    List empty = Collections.emptyList();
                    new JSONUtil().serialize(writer, value, empty, empty, this._ignoreHierarchy, this._excludeNullProperties);
                }
                catch (IOException | JSONException e) {
                    LOG.error("Could not write out json value", e, new String[0]);
                }
            }
        }
        return super.end(writer, "");
    }
}

