/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.presentation.tags;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.struts2.components.ContextBean;
import org.apache.struts2.components.Param;
import org.onebusaway.presentation.services.resources.ResourceService;
import org.springframework.beans.factory.annotation.Autowired;

public class ResourcesUrlComponent
extends ContextBean
implements Param.UnnamedParametric {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesUrlComponent.class);
    private ResourceService _resourceService;
    private List<String> _resourcePaths = new ArrayList<String>();
    private String _id;

    public ResourcesUrlComponent(ValueStack stack) {
        super(stack);
    }

    @Autowired
    public void setResourceService(ResourceService resourceService) {
        this._resourceService = resourceService;
    }

    public void addParameter(Object value) {
        this._resourcePaths.add(value.toString());
    }

    public void setId(String id) {
        this._id = id;
    }

    public boolean end(Writer writer, String body) {
        String url;
        Locale locale = Locale.getDefault();
        ActionContext ctx = ActionContext.getContext();
        if (ctx != null) {
            locale = ctx.getLocale();
        }
        if ((url = this._resourceService.getExternalUrlForResources(this._id, this._resourcePaths, locale)) != null) {
            if (this.getVar() != null) {
                this.putInContext(url);
            } else {
                try {
                    writer.write(url);
                }
                catch (IOException e) {
                    LOG.error("Could not write out resource-url tag", (Throwable)e, new String[0]);
                }
            }
        }
        return super.end(writer, "");
    }
}

