/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.RegisterAlarmQueryBean;
import org.onebusaway.transit_data_federation.services.AlarmAction;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureAlarmService;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureQuery;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.realtime.ArrivalAndDepartureInstance;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocationListener;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ArrivalAndDepartureAlarmServiceImpl
implements ArrivalAndDepartureAlarmService,
BlockLocationListener {
    private static Logger _log = LoggerFactory.getLogger(ArrivalAndDepartureAlarmServiceImpl.class);
    private ArrivalAndDepartureService _arrivalAndDepartureService;
    private ConcurrentMap<BlockInstance, AlarmsForBlockInstance> _alarmsByBlockInstance = new ConcurrentHashMap<BlockInstance, AlarmsForBlockInstance>();
    private Map<AgencyAndId, AlarmForBlockInstance> _alarmsById = new HashMap<AgencyAndId, AlarmForBlockInstance>();
    private ScheduledExecutorService _executor;
    private int _threadPoolSize = 5;

    ArrivalAndDepartureAlarmServiceImpl() {
    }

    @Autowired
    public void setArrivalAndDepartureService(ArrivalAndDepartureService arrivalAndDepartureService) {
        this._arrivalAndDepartureService = arrivalAndDepartureService;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this._threadPoolSize = threadPoolSize;
    }

    @PostConstruct
    public void start() {
        this._executor = Executors.newScheduledThreadPool(this._threadPoolSize);
    }

    @PreDestroy
    public void stop() {
        if (this._executor != null) {
            this._executor.shutdownNow();
            this._executor = null;
        }
    }

    @Override
    public AgencyAndId registerAlarmForArrivalAndDepartureAtStop(ArrivalAndDepartureQuery query, RegisterAlarmQueryBean alarmBean) {
        ArrivalAndDepartureInstance instance = this._arrivalAndDepartureService.getArrivalAndDepartureForStop(query);
        if (instance == null) {
            throw new ServiceException("no arrival-departure found");
        }
        BlockInstance blockInstance = instance.getBlockInstance();
        AlarmsForBlockInstance alarms = this.getAlarmsForBlockInstance(blockInstance);
        int effectiveScheduleTime = this.computeEffectiveScheduleTimeForAlarm(alarmBean, instance);
        AlarmAction action = new AlarmAction();
        action.setUrl(alarmBean.getUrl());
        AlarmForBlockInstance alarm = alarms.registerAlarm(action, effectiveScheduleTime, instance);
        this._alarmsById.put(alarm.getId(), alarm);
        _log.debug("alarm created: {}", (Object)alarm.getId());
        return alarm.getId();
    }

    @Override
    public void cancelAlarmForArrivalAndDepartureAtStop(AgencyAndId alarmId) {
        _log.debug("cancelling alarm: {}", (Object)alarmId);
        AlarmForBlockInstance alarm = this._alarmsById.get(alarmId);
        if (alarm != null) {
            alarm.setCanceled();
        }
    }

    @Override
    public void handleBlockLocation(BlockLocation blockLocation) {
        if (blockLocation == null) {
            return;
        }
        BlockInstance blockInstance = blockLocation.getBlockInstance();
        AlarmsForBlockInstance alarms = (AlarmsForBlockInstance)this._alarmsByBlockInstance.get(blockInstance);
        if (alarms != null) {
            alarms.updateBlockLocation(blockLocation);
        }
    }

    private int computeEffectiveScheduleTimeForAlarm(RegisterAlarmQueryBean alarmBean, ArrivalAndDepartureInstance instance) {
        long scheduleTime = alarmBean.isOnArrival() ? instance.getScheduledArrivalTime() : instance.getScheduledDepartureTime();
        int effectiveScheduleTime = (int)((scheduleTime - instance.getServiceDate()) / 1000L);
        return effectiveScheduleTime - alarmBean.getAlarmTimeOffset();
    }

    private AlarmsForBlockInstance getAlarmsForBlockInstance(BlockInstance blockInstance) {
        AlarmsForBlockInstance alarms;
        do {
            AlarmsForBlockInstance newAlarms;
            if ((alarms = (AlarmsForBlockInstance)this._alarmsByBlockInstance.get(blockInstance)) != null || (alarms = this._alarmsByBlockInstance.putIfAbsent(blockInstance, newAlarms = new AlarmsForBlockInstance(blockInstance))) != null) continue;
            alarms = newAlarms;
        } while (alarms.isCanceled());
        return alarms;
    }

    private void fireAlarm(AlarmForBlockInstance alarm) {
        this._executor.submit(new FireAlarmTask(alarm.getId(), alarm.action));
    }

    private static class FireAlarmTask
    implements Runnable {
        private final AgencyAndId alarmId;
        private final AlarmAction action;

        public FireAlarmTask(AgencyAndId alarmId, AlarmAction action) {
            this.alarmId = alarmId;
            this.action = action;
        }

        @Override
        public void run() {
            try {
                String rawUrl = this.action.getUrl();
                String rawAlarmId = AgencyAndIdLibrary.convertToString((AgencyAndId)this.alarmId);
                rawUrl = rawUrl.replace("#ALARM_ID#", rawAlarmId);
                URL url = new URL(rawUrl);
                URLConnection connection = url.openConnection();
                InputStream in = connection.getInputStream();
                in.close();
            }
            catch (Throwable ex) {
                _log.warn("error firing alarm", ex);
            }
        }
    }

    private class AlarmForBlockInstance
    implements Comparable<AlarmForBlockInstance> {
        private final AgencyAndId id;
        private final AlarmAction action;
        private final int effectiveScheduleTime;
        private boolean canceled = false;

        public AlarmForBlockInstance(AgencyAndId id, AlarmAction action, int effectiveScheduleTime) {
            this.id = id;
            this.action = action;
            this.effectiveScheduleTime = effectiveScheduleTime;
        }

        public AgencyAndId getId() {
            return this.id;
        }

        public int getEffectiveScheduleTime() {
            return this.effectiveScheduleTime;
        }

        public void setCanceled() {
            this.canceled = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        @Override
        public int compareTo(AlarmForBlockInstance o) {
            return this.effectiveScheduleTime - o.effectiveScheduleTime;
        }
    }

    private class VehicleInfo {
        private final PriorityQueue<AlarmForBlockInstance> _queue = new PriorityQueue();
        private int _scheduleDeviation = 0;

        private VehicleInfo() {
        }

        public int getScheduleDeviation() {
            return this._scheduleDeviation;
        }

        public void setScheduleDeviation(int scheduleDeviation) {
            this._scheduleDeviation = scheduleDeviation;
        }

        public PriorityQueue<AlarmForBlockInstance> getQueue() {
            return this._queue;
        }
    }

    private class AlarmsForBlockInstance
    implements Runnable {
        private final BlockInstance _blockInstance;
        private PriorityQueue<AlarmForBlockInstance> _noVehicleIdQueue = new PriorityQueue();
        private Map<AgencyAndId, VehicleInfo> _vehicleInfoByVehicleId = new HashMap<AgencyAndId, VehicleInfo>();
        private Future<?> _alarmTask = null;
        private boolean _canceled = false;

        public AlarmsForBlockInstance(BlockInstance blockInstance) {
            this._blockInstance = blockInstance;
        }

        public synchronized boolean isCanceled() {
            return this._canceled;
        }

        public synchronized AlarmForBlockInstance registerAlarm(AlarmAction action, int effectiveScheduleTime, ArrivalAndDepartureInstance instance) {
            StopEntry stop = instance.getStop();
            AgencyAndId stopId = stop.getId();
            AgencyAndId alarmId = new AgencyAndId(stopId.getAgencyId(), UUID.randomUUID().toString());
            AlarmForBlockInstance alarm = new AlarmForBlockInstance(alarmId, action, effectiveScheduleTime);
            BlockLocation blockLocation = instance.getBlockLocation();
            if (blockLocation == null || blockLocation.getVehicleId() == null) {
                _log.debug("schedule only for alarm: {}", (Object)instance);
                this._noVehicleIdQueue.add(alarm);
            } else {
                _log.debug("real-time for alarm: {}", (Object)instance);
                AgencyAndId vehicleId = blockLocation.getVehicleId();
                VehicleInfo vehicleInfo = this.getVehicleInfoForVehicleId(vehicleId, true);
                if (blockLocation.isScheduleDeviationSet()) {
                    vehicleInfo.setScheduleDeviation((int)blockLocation.getScheduleDeviation());
                } else {
                    _log.warn("no schedule deviation for block location " + blockLocation);
                }
                PriorityQueue<AlarmForBlockInstance> queue = vehicleInfo.getQueue();
                queue.add(alarm);
            }
            this.processQueues();
            return alarm;
        }

        public synchronized void updateBlockLocation(BlockLocation blockLocation) {
            AgencyAndId vehicleId = blockLocation.getVehicleId();
            if (vehicleId == null) {
                _log.warn("expected a vehicle id with block location" + blockLocation);
                return;
            }
            if (!blockLocation.isScheduleDeviationSet()) {
                _log.warn("expected schedule deviation with block location" + blockLocation);
            }
            _log.debug("updating block location for vehicle: {}", (Object)blockLocation.getVehicleId());
            boolean create = !this._noVehicleIdQueue.isEmpty();
            VehicleInfo vehicleInfo = this.getVehicleInfoForVehicleId(vehicleId, create);
            if (vehicleInfo == null) {
                return;
            }
            vehicleInfo.setScheduleDeviation((int)blockLocation.getScheduleDeviation());
            this.moveNoVehicleAlarmsToVehicleAlarms();
            this.processQueues();
        }

        @Override
        public synchronized void run() {
            this._alarmTask = null;
            this.processQueues();
        }

        private VehicleInfo getVehicleInfoForVehicleId(AgencyAndId vehicleId, boolean create) {
            VehicleInfo vehicleInfo = this._vehicleInfoByVehicleId.get(vehicleId);
            if (vehicleInfo == null && create) {
                vehicleInfo = new VehicleInfo();
                this._vehicleInfoByVehicleId.put(vehicleId, vehicleInfo);
            }
            return vehicleInfo;
        }

        private void moveNoVehicleAlarmsToVehicleAlarms() {
            if (this._noVehicleIdQueue.isEmpty() || this._vehicleInfoByVehicleId.isEmpty()) {
                return;
            }
            VehicleInfo first = this._vehicleInfoByVehicleId.values().iterator().next();
            PriorityQueue<AlarmForBlockInstance> queue = first.getQueue();
            queue.addAll(this._noVehicleIdQueue);
            this._noVehicleIdQueue.clear();
        }

        private void processQueues() {
            if (this._alarmTask != null) {
                this._alarmTask.cancel(false);
            }
            boolean allQueuesAreEmpty = true;
            int minNextAlarmTime = Integer.MAX_VALUE;
            for (VehicleInfo vehicleInfo : this._vehicleInfoByVehicleId.values()) {
                int scheduleDeviation;
                PriorityQueue<AlarmForBlockInstance> queue = vehicleInfo.getQueue();
                int nextAlarmTime = this.processQueue(queue, scheduleDeviation = vehicleInfo.getScheduleDeviation());
                if (nextAlarmTime <= 0) continue;
                minNextAlarmTime = Math.min(minNextAlarmTime, nextAlarmTime);
                allQueuesAreEmpty = false;
            }
            int nextAlarmTime = this.processQueue(this._noVehicleIdQueue, 0);
            if (nextAlarmTime > 0) {
                minNextAlarmTime = Math.min(minNextAlarmTime, nextAlarmTime);
                allQueuesAreEmpty = false;
            }
            if (allQueuesAreEmpty) {
                _log.debug("all alarm queues are empty, cleaning up: {}", (Object)this._blockInstance);
                this._vehicleInfoByVehicleId.clear();
                this._canceled = true;
                ArrivalAndDepartureAlarmServiceImpl.this._alarmsByBlockInstance.remove(this._blockInstance);
            } else {
                _log.debug("scheduling next alarm check in {} secs for {}", (Object)minNextAlarmTime, (Object)this._blockInstance);
                this._alarmTask = ArrivalAndDepartureAlarmServiceImpl.this._executor.schedule(this, (long)minNextAlarmTime, TimeUnit.SECONDS);
            }
        }

        private int processQueue(PriorityQueue<AlarmForBlockInstance> queue, int scheduleDeviation) {
            int effectiveScheduleTime = (int)((SystemTime.currentTimeMillis() - this._blockInstance.getServiceDate()) / 1000L - (long)scheduleDeviation);
            while (!queue.isEmpty()) {
                AlarmForBlockInstance alarm = queue.peek();
                if (alarm.isCanceled()) {
                    queue.poll();
                    continue;
                }
                if (effectiveScheduleTime < alarm.getEffectiveScheduleTime()) {
                    return alarm.getEffectiveScheduleTime() - effectiveScheduleTime;
                }
                queue.poll();
                ArrivalAndDepartureAlarmServiceImpl.this.fireAlarm(alarm);
            }
            return -1;
        }
    }
}

