/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.collections.Min;
import org.onebusaway.container.ConfigurationParameter;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.transit_data.model.TimeIntervalBean;
import org.onebusaway.transit_data_federation.model.StopTimeInstance;
import org.onebusaway.transit_data_federation.model.TargetTime;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureQuery;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureService;
import org.onebusaway.transit_data_federation.services.StopTimeService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockStatusService;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripInstanceLibrary;
import org.onebusaway.transit_data_federation.services.blocks.InstanceState;
import org.onebusaway.transit_data_federation.services.realtime.ArrivalAndDepartureInstance;
import org.onebusaway.transit_data_federation.services.realtime.ArrivalAndDepartureTime;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocationService;
import org.onebusaway.transit_data_federation.services.realtime.ScheduleDeviationSamples;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.utility.EInRangeStrategy;
import org.onebusaway.utility.EOutOfRangeStrategy;
import org.onebusaway.utility.InterpolationLibrary;
import org.onebusaway.utility.TransitInterpolationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class ArrivalAndDepartureServiceImpl
implements ArrivalAndDepartureService {
    private static Logger _log = LoggerFactory.getLogger(ArrivalAndDepartureServiceImpl.class);
    private StopTimeService _stopTimeService;
    private BlockLocationService _blockLocationService;
    private BlockStatusService _blockStatusService;
    private boolean removeFuturePredictionsWithoutRealtime = false;
    private boolean hideCanceledTrips = true;

    ArrivalAndDepartureServiceImpl() {
    }

    @Autowired
    public void setStopTimeService(StopTimeService stopTimeService) {
        this._stopTimeService = stopTimeService;
    }

    @Autowired
    public void setBlockLocationService(BlockLocationService blockLocationService) {
        this._blockLocationService = blockLocationService;
    }

    @Autowired
    public void setBlockStatusService(BlockStatusService blockStatusService) {
        this._blockStatusService = blockStatusService;
    }

    public void setRemoveFuturePredictionsWithoutRealtime(boolean remove) {
        this.removeFuturePredictionsWithoutRealtime = remove;
    }

    @ConfigurationParameter
    public void setHideCanceledTrips(boolean hide) {
        this.hideCanceledTrips = hide;
    }

    @Override
    public boolean getHideCanceledTrips() {
        return this.hideCanceledTrips;
    }

    @Override
    public List<ArrivalAndDepartureInstance> getArrivalsAndDeparturesForStopInTimeRange(StopEntry stop, TargetTime targetTime, long fromTime, long toTime) {
        Date fromTimeBuffered = new Date(fromTime - (long)(this._blockStatusService.getRunningLateWindow() * 1000));
        Date toTimeBuffered = new Date(toTime + (long)(this._blockStatusService.getRunningEarlyWindow() * 1000));
        List<StopTimeInstance> stis = this._stopTimeService.getStopTimeInstancesInTimeRange(stop, fromTimeBuffered, toTimeBuffered, StopTimeService.EFrequencyStopTimeBehavior.INCLUDE_UNSPECIFIED);
        long frequencyOffsetTime = Math.max(targetTime.getTargetTime(), fromTime);
        Map<BlockInstance, List<StopTimeInstance>> stisByBlockId = this.getStopTimeInstancesByBlockInstance(stis);
        ArrayList<ArrivalAndDepartureInstance> instances = new ArrayList<ArrivalAndDepartureInstance>();
        for (Map.Entry<BlockInstance, List<StopTimeInstance>> entry : stisByBlockId.entrySet()) {
            BlockInstance blockInstance = entry.getKey();
            List<BlockLocation> locations = this._blockLocationService.getLocationsForBlockInstance(blockInstance, targetTime);
            List<StopTimeInstance> stisForBlock = entry.getValue();
            for (StopTimeInstance sti : stisForBlock) {
                this.applyRealTimeToStopTimeInstance(sti, targetTime, fromTime, toTime, frequencyOffsetTime, blockInstance, locations, instances);
                if (sti.getFrequency() == null || sti.getFrequency().getExactTimes() != 0) continue;
                this.applyPostInterpolateForFrequencyNoSchedule(sti, fromTime, toTime, frequencyOffsetTime, blockInstance, instances);
            }
        }
        if (this.removeFuturePredictionsWithoutRealtime) {
            ArrayList<ArrivalAndDepartureInstance> filteredInstances = new ArrayList<ArrivalAndDepartureInstance>();
            for (ArrivalAndDepartureInstance instance : instances) {
                FrequencyEntry entry = instance.getFrequency();
                boolean toAdd = entry == null || instance.getServiceDate() + (long)(entry.getStartTime() * 1000) < targetTime.getTargetTime() || instance.getBlockLocation() != null && instance.getBlockLocation().isPredicted();
                if (!toAdd) continue;
                filteredInstances.add(instance);
            }
            return filteredInstances;
        }
        return instances;
    }

    @Override
    public List<ArrivalAndDepartureInstance> getScheduledArrivalsAndDeparturesForStopInTimeRange(StopEntry stop, long currentTime, long fromTime, long toTime) {
        List<StopTimeInstance> stis = this._stopTimeService.getStopTimeInstancesInTimeRange(stop, new Date(fromTime), new Date(toTime), StopTimeService.EFrequencyStopTimeBehavior.INCLUDE_UNSPECIFIED);
        ArrayList<ArrivalAndDepartureInstance> instances = new ArrayList<ArrivalAndDepartureInstance>();
        long prevFrequencyTime = Math.max(currentTime, fromTime);
        for (StopTimeInstance sti : stis) {
            BlockInstance blockInstance = sti.getBlockInstance();
            ArrivalAndDepartureInstance instance = this.createArrivalAndDepartureForStopTimeInstance(sti, prevFrequencyTime);
            if (sti.getFrequency() == null) {
                if (!this.isArrivalAndDepartureBeanInRange(instance, fromTime, toTime)) continue;
                BlockLocation scheduledLocation = this._blockLocationService.getScheduledLocationForBlockInstance(blockInstance, currentTime);
                if (scheduledLocation != null) {
                    this.applyBlockLocationToInstance(instance, scheduledLocation, currentTime);
                }
                instances.add(instance);
                continue;
            }
            if (!this.isFrequencyBasedArrivalInRange(blockInstance, sti.getFrequency(), fromTime, toTime)) continue;
            instances.add(instance);
        }
        return instances;
    }

    @Override
    public List<ArrivalAndDepartureInstance> getNextScheduledBlockTripDeparturesForStop(StopEntry stop, long time, boolean includePrivateService) {
        List<StopTimeInstance> stopTimes = this._stopTimeService.getNextBlockSequenceDeparturesForStop(stop, time, includePrivateService);
        ArrayList<ArrivalAndDepartureInstance> instances = new ArrayList<ArrivalAndDepartureInstance>();
        for (StopTimeInstance sti : stopTimes) {
            ArrivalAndDepartureInstance instance = this.createArrivalAndDepartureForStopTimeInstance(sti, time);
            instances.add(instance);
        }
        return instances;
    }

    @Override
    public ArrivalAndDepartureInstance getArrivalAndDepartureForStop(ArrivalAndDepartureQuery query) {
        StopEntry stop = query.getStop();
        int stopSequence = query.getStopSequence();
        TripEntry trip = query.getTrip();
        long serviceDate = query.getServiceDate();
        AgencyAndId vehicleId = query.getVehicleId();
        long time = query.getTime();
        Map<BlockInstance, List<BlockLocation>> locationsByInstance = this._blockStatusService.getBlocks(trip.getBlock().getId(), serviceDate, vehicleId, time);
        if (locationsByInstance.isEmpty()) {
            return null;
        }
        Map.Entry<BlockInstance, List<BlockLocation>> entry = locationsByInstance.entrySet().iterator().next();
        BlockInstance blockInstance = entry.getKey();
        List<BlockLocation> locations = entry.getValue();
        int timeOfServiceDate = (int)((time - serviceDate) / 1000L);
        ArrivalAndDepartureInstance instance = this.createArrivalAndDeparture(blockInstance, trip.getId(), stop.getId(), stopSequence, serviceDate, timeOfServiceDate, time);
        if (!locations.isEmpty()) {
            BlockLocation location = locations.get(0);
            this.applyBlockLocationToInstance(instance, location, time);
        }
        if (!instance.isPredictedArrivalTimeSet() && !instance.isPredictedDepartureTimeSet() && query.getAgenciesExcludingScheduled().contains(instance.getBlockInstance().getBlock().getBlock().getId().getAgencyId())) {
            return null;
        }
        return instance;
    }

    @Override
    public ArrivalAndDepartureInstance getPreviousStopArrivalAndDeparture(ArrivalAndDepartureInstance instance) {
        BlockStopTimeEntry stopTime = instance.getBlockStopTime();
        BlockTripEntry trip = stopTime.getTrip();
        BlockConfigurationEntry blockConfig = trip.getBlockConfiguration();
        List<BlockStopTimeEntry> stopTimes = blockConfig.getStopTimes();
        int index = stopTime.getBlockSequence() - 1;
        if (index < 0) {
            return null;
        }
        BlockStopTimeEntry prevStopTime = stopTimes.get(index);
        InstanceState state = instance.getStopTimeInstance().getState();
        ArrivalAndDepartureTime scheduledTime = ArrivalAndDepartureTime.getScheduledTime(state, prevStopTime);
        if (instance.getFrequency() != null) {
            StopTimeEntry pStopTime = prevStopTime.getStopTime();
            int betweenStopDelta = stopTime.getStopTime().getArrivalTime() - pStopTime.getDepartureTime();
            int atStopDelta = pStopTime.getDepartureTime() - pStopTime.getArrivalTime();
            long scheduledDepartureTime = instance.getScheduledArrivalTime() - (long)(betweenStopDelta * 1000);
            long scheduledArrivalTime = scheduledDepartureTime - (long)(atStopDelta * 1000);
            scheduledTime.setArrivalTime(scheduledArrivalTime);
            scheduledTime.setDepartureTime(scheduledDepartureTime);
        }
        StopTimeInstance prevStopTimeInstance = new StopTimeInstance(prevStopTime, state);
        ArrivalAndDepartureInstance prevInstance = new ArrivalAndDepartureInstance(prevStopTimeInstance, scheduledTime);
        if (instance.isPredictedArrivalTimeSet()) {
            int scheduledDeviation = (int)((instance.getPredictedArrivalTime() - instance.getScheduledArrivalTime()) / 1000L);
            int departureDeviation = this.propagateScheduleDeviationBackwardBetweenStops(prevStopTime, stopTime, scheduledDeviation);
            int arrivalDeviation = this.propagateScheduleDeviationBackwardAcrossStop(prevStopTime, departureDeviation);
            this.setPredictedArrivalTimeForInstance(prevInstance, prevInstance.getScheduledArrivalTime() + (long)(arrivalDeviation * 1000));
            this.setPredictedDepartureTimeForInstance(prevInstance, prevInstance.getScheduledDepartureTime() + (long)(departureDeviation * 1000));
        }
        return prevInstance;
    }

    @Override
    public ArrivalAndDepartureInstance getNextStopArrivalAndDeparture(ArrivalAndDepartureInstance instance) {
        BlockStopTimeEntry stopTime = instance.getBlockStopTime();
        BlockTripEntry trip = stopTime.getTrip();
        BlockConfigurationEntry blockConfig = trip.getBlockConfiguration();
        List<BlockStopTimeEntry> stopTimes = blockConfig.getStopTimes();
        int index = stopTime.getBlockSequence() + 1;
        if (index >= stopTimes.size()) {
            return null;
        }
        BlockStopTimeEntry nextStopTime = stopTimes.get(index);
        InstanceState state = instance.getStopTimeInstance().getState();
        ArrivalAndDepartureTime scheduledTime = ArrivalAndDepartureTime.getScheduledTime(state, nextStopTime);
        if (state.getFrequency() != null) {
            StopTimeEntry nStopTime = nextStopTime.getStopTime();
            int betweenStopDelta = nStopTime.getArrivalTime() - stopTime.getStopTime().getDepartureTime();
            int atStopDelta = nStopTime.getDepartureTime() - nStopTime.getArrivalTime();
            long scheduledArrivalTime = instance.getScheduledDepartureTime() + (long)(betweenStopDelta * 1000);
            long scheduledDepartureTime = scheduledArrivalTime + (long)(atStopDelta * 1000);
            scheduledTime.setArrivalTime(scheduledArrivalTime);
            scheduledTime.setDepartureTime(scheduledDepartureTime);
        }
        StopTimeInstance nextStopTimeInstance = new StopTimeInstance(stopTime, state);
        ArrivalAndDepartureInstance nextInstance = new ArrivalAndDepartureInstance(nextStopTimeInstance, scheduledTime);
        if (instance.isPredictedDepartureTimeSet()) {
            int scheduledDeviation = (int)((instance.getPredictedDepartureTime() - instance.getScheduledDepartureTime()) / 1000L);
            int arrivalDeviation = this.propagateScheduleDeviationForwardBetweenStops(stopTime, nextStopTime, scheduledDeviation);
            int departureDeviation = this.propagateScheduleDeviationForwardAcrossStop(nextStopTime, arrivalDeviation);
            this.setPredictedArrivalTimeForInstance(nextInstance, nextInstance.getScheduledArrivalTime() + (long)(arrivalDeviation * 1000));
            this.setPredictedDepartureTimeForInstance(nextInstance, nextInstance.getScheduledDepartureTime() + (long)(departureDeviation * 1000));
        }
        return nextInstance;
    }

    private Map<BlockInstance, List<StopTimeInstance>> getStopTimeInstancesByBlockInstance(List<StopTimeInstance> stopTimes) {
        FactoryMap r = new FactoryMap(new ArrayList());
        for (StopTimeInstance stopTime : stopTimes) {
            BlockStopTimeEntry blockStopTime = stopTime.getStopTime();
            BlockTripEntry blockTrip = blockStopTime.getTrip();
            BlockConfigurationEntry blockConfiguration = blockTrip.getBlockConfiguration();
            long serviceDate = stopTime.getServiceDate();
            BlockInstance blockInstance = new BlockInstance(blockConfiguration, serviceDate, stopTime.getFrequency());
            ((List)r.get(blockInstance)).add(stopTime);
        }
        return r;
    }

    private void applyPostInterpolateForFrequencyNoSchedule(StopTimeInstance sti, long fromTime, long toTime, long frequencyOffsetTime, BlockInstance blockInstance, List<ArrivalAndDepartureInstance> results) {
        if (results == null || results.size() == 0) {
            return;
        }
        ArrivalAndDepartureInstance instance = ArrivalAndDepartureServiceImpl.findBestArrivalAndDepartureInstance(results);
        if (instance.getBlockLocation() == null || !instance.getBlockLocation().isPredicted()) {
            return;
        }
        BlockStopTimeEntry bst = sti.getStopTime();
        int d0 = bst.getTrip().getDepartureTimeForIndex(0);
        int d1 = bst.getStopTime().getDepartureTime();
        int stopDelta = d1 - d0;
        int stopEndTime = sti.getFrequency().getEndTime() + stopDelta;
        long stopEndTimeExact = sti.getServiceDate() + (long)(stopEndTime * 1000);
        int headwayMs = sti.getFrequency().getHeadwaySecs() * 1000;
        long time = instance.getBestDepartureTime();
        if (time == 0L) {
            time = instance.getBestArrivalTime();
        }
        stopEndTimeExact -= (long)headwayMs;
        while ((time += (long)headwayMs) < Math.min(toTime, stopEndTimeExact)) {
            ArrivalAndDepartureInstance newInstance = this.createArrivalAndDepartureForStopTimeInstanceWithTime(sti, time);
            results.add(newInstance);
        }
    }

    private static ArrivalAndDepartureInstance findBestArrivalAndDepartureInstance(List<ArrivalAndDepartureInstance> instances) {
        Comparator<ArrivalAndDepartureInstance> cmp = new Comparator<ArrivalAndDepartureInstance>(){

            @Override
            public int compare(ArrivalAndDepartureInstance a, ArrivalAndDepartureInstance b) {
                long l2;
                long l1;
                if (!this.isRealtime(a) && this.isRealtime(b)) {
                    return -1;
                }
                if (this.isRealtime(a) && !this.isRealtime(b)) {
                    return 1;
                }
                if (a.getBestDepartureTime() == 0L || b.getBestDepartureTime() == 0L) {
                    l1 = a.getBestArrivalTime();
                    l2 = b.getBestArrivalTime();
                } else {
                    l1 = a.getBestDepartureTime();
                    l2 = b.getBestDepartureTime();
                }
                return Long.valueOf(l1).compareTo(l2);
            }

            private boolean isRealtime(ArrivalAndDepartureInstance ad) {
                return ad.getBlockLocation() != null && ad.getBlockLocation().isPredicted();
            }
        };
        return Collections.max(instances, cmp);
    }

    private void applyRealTimeToStopTimeInstance(StopTimeInstance sti, TargetTime targetTime, long fromTime, long toTime, long frequencyOffsetTime, BlockInstance blockInstance, List<BlockLocation> locations, List<ArrivalAndDepartureInstance> results) {
        for (BlockLocation location : locations) {
            if (sti.isFrequencyOffsetSpecified() && blockInstance.getBlock().getDepartureTimeForIndex(0) + sti.getFrequencyOffset() != location.getBlockStartTime() || this.hideCanceledTrips && "CANCELED".equals(location.getStatus())) continue;
            ArrivalAndDepartureInstance instance = this.createArrivalAndDepartureForStopTimeInstance(sti, frequencyOffsetTime);
            this.applyBlockLocationToInstance(instance, location, targetTime.getTargetTime());
            if (!this.isArrivalAndDepartureBeanInRange(instance, fromTime, toTime)) continue;
            results.add(this.applyCanceledStatus(instance));
        }
        if (locations.isEmpty()) {
            ArrivalAndDepartureInstance instance = this.createArrivalAndDepartureForStopTimeInstance(sti, frequencyOffsetTime);
            if (sti.getFrequency() == null) {
                if (this.isArrivalAndDepartureBeanInRange(instance, fromTime, toTime)) {
                    BlockLocation scheduledLocation = this._blockLocationService.getScheduledLocationForBlockInstance(blockInstance, targetTime.getTargetTime());
                    if (scheduledLocation != null) {
                        this.applyBlockLocationToInstance(instance, scheduledLocation, targetTime.getTargetTime());
                    }
                    results.add(this.applyCanceledStatus(instance));
                }
            } else if (this.isFrequencyBasedArrivalInRange(blockInstance, sti.getFrequency(), fromTime, toTime)) {
                results.add(this.applyCanceledStatus(instance));
            }
        }
    }

    private ArrivalAndDepartureInstance applyCanceledStatus(ArrivalAndDepartureInstance instance) {
        if (this.hideCanceledTrips) {
            return instance;
        }
        if ("CANCELED".equals(instance.getStatus())) {
            instance.setStatus("CANCELED");
        }
        if (instance.getBlockLocation() != null && "CANCELED".equals(instance.getBlockLocation().getStatus())) {
            instance.setStatus("CANCELED");
        }
        return instance;
    }

    private void applyBlockLocationToInstance(ArrivalAndDepartureInstance instance, BlockLocation blockLocation, long targetTime) {
        Double scheduleDeviation;
        if (instance == null) {
            return;
        }
        instance.setBlockLocation(blockLocation);
        if ("CANCELED".equals(blockLocation.getStatus()) && !this.hideCanceledTrips) {
            this.applyCanceledAttributes(instance);
        }
        boolean success = this.setPredictedTimesFromTimepointPredictionRecords(instance, blockLocation, targetTime);
        if ((blockLocation.isScheduleDeviationSet() || blockLocation.areScheduleDeviationsSet()) && (scheduleDeviation = this.getBestScheduleDeviation(instance, blockLocation)) != null) {
            if (!success) {
                this.setPredictedTimesFromScheduleDeviation(instance, blockLocation, scheduleDeviation.intValue(), targetTime);
            }
            this.setPredictedTimeIntervals(instance, blockLocation, targetTime);
        }
    }

    private void applyCanceledAttributes(ArrivalAndDepartureInstance instance) {
        BlockLocation blockLocation = instance.getBlockLocation();
        blockLocation.setVehicleId(null);
        blockLocation.setInService(false);
        instance.setStatus(blockLocation.getStatus());
    }

    private Double getBestScheduleDeviation(ArrivalAndDepartureInstance instance, BlockLocation blockLocation) {
        ScheduleDeviationSamples scheduleDeviations = blockLocation.getScheduleDeviations();
        if (scheduleDeviations != null && !scheduleDeviations.isEmpty()) {
            Integer arrivalTime = instance.getBlockStopTime().getStopTime().getArrivalTime();
            return TransitInterpolationLibrary.interpolate((double[])scheduleDeviations.getScheduleTimes(), (double[])scheduleDeviations.getScheduleDeviationMus(), (double)arrivalTime.intValue(), (EOutOfRangeStrategy)EOutOfRangeStrategy.LAST_VALUE, (EInRangeStrategy)EInRangeStrategy.PREVIOUS_VALUE);
        }
        if (blockLocation.isScheduleDeviationSet()) {
            return blockLocation.getScheduleDeviation();
        }
        return 0.0;
    }

    private boolean setPredictedTimesFromTimepointPredictionRecords(ArrivalAndDepartureInstance instance, BlockLocation blockLocation, long targetTime) {
        List<TimepointPredictionRecord> records = blockLocation.getTimepointPredictions();
        if (records == null) {
            return false;
        }
        int stopSequence = instance.getBlockStopTime().getStopTime().getSequence();
        int gtfsSequence = instance.getBlockStopTime().getStopTime().getGtfsSequence();
        int totalCandidates = 0;
        int thisStopIndex = 0;
        List<BlockStopTimeEntry> stopTimes = instance.getBlockTrip().getStopTimes();
        for (int i = 0; i < stopTimes.size(); ++i) {
            BlockStopTimeEntry stopTime = stopTimes.get(i);
            StopTimeEntry stop = stopTime.getStopTime();
            if (!stop.getStop().getId().equals((Object)instance.getStop().getId())) continue;
            ++totalCandidates;
            if (stop.getSequence() >= stopSequence) continue;
            ++thisStopIndex;
        }
        int tprTotalCandidates = 0;
        int tprStopIndex = 0;
        boolean success = false;
        for (TimepointPredictionRecord tpr : records) {
            boolean sequenceMatches;
            boolean tripMatches = tpr.getTripId().equals((Object)instance.getBlockTrip().getTrip().getId());
            boolean stopMatches = tpr.getTimepointId().equals((Object)instance.getStop().getId());
            boolean bl = sequenceMatches = tpr.getStopSequence() > 0 && tpr.getStopSequence() == gtfsSequence;
            if (!tripMatches) {
                _log.debug("unmatched trip on tpr: " + tpr.getTripId() + " != " + instance.getBlockTrip().getTrip().getId());
                continue;
            }
            if (!stopMatches) {
                _log.debug("unmatched stop on tpr: " + tpr.getTimepointId() + " != " + instance.getStop().getId());
                continue;
            }
            if (sequenceMatches || tprStopIndex == thisStopIndex) {
                success = true;
                long arrivalTime = tpr.getTimepointPredictedArrivalTime();
                long departureTime = tpr.getTimepointPredictedDepartureTime();
                if (departureTime <= 0L) {
                    int slack = instance.getBlockStopTime().getStopTime().getSlackTime();
                    departureTime = arrivalTime + (long)(slack * 1000);
                }
                this.setPredictedDepartureTimeForInstance(instance, departureTime);
                if (arrivalTime == -1L) {
                    this.setPredictedArrivalTimeForInstance(instance, departureTime);
                } else {
                    this.setPredictedArrivalTimeForInstance(instance, arrivalTime);
                }
                instance.setScheduledTrack(tpr.getScheduledTrack());
                instance.setActualTrack(tpr.getActualTrack());
                instance.setStatus(tpr.getStatus());
                if (sequenceMatches) {
                    return true;
                }
            } else if (tprStopIndex < thisStopIndex) {
                ++tprStopIndex;
            }
            ++tprTotalCandidates;
        }
        if (success && totalCandidates == tprTotalCandidates && tprStopIndex == thisStopIndex) {
            return true;
        }
        this.setPredictedArrivalTimeForInstance(instance, 0L);
        this.setPredictedDepartureTimeForInstance(instance, 0L);
        return false;
    }

    private void setPredictedTimesFromScheduleDeviation(ArrivalAndDepartureInstance instance, BlockLocation blockLocation, int scheduleDeviation, long targetTime) {
        BlockStopTimeEntry blockStopTime = instance.getBlockStopTime();
        int effectiveScheduleTime = (int)((targetTime - instance.getServiceDate()) / 1000L - (long)scheduleDeviation);
        int arrivalDeviation = this.calculateArrivalDeviation(blockLocation.getNextStop(), blockStopTime, effectiveScheduleTime, scheduleDeviation);
        int departureDeviation = this.calculateDepartureDeviation(blockLocation.getNextStop(), blockStopTime, effectiveScheduleTime, scheduleDeviation);
        InstanceState state = instance.getStopTimeInstance().getState();
        ArrivalAndDepartureTime schedule = ArrivalAndDepartureTime.getScheduledTime(state, instance.getBlockStopTime());
        long arrivalTime = schedule.getArrivalTime() + (long)(arrivalDeviation * 1000);
        this.setPredictedArrivalTimeForInstance(instance, arrivalTime);
        long departureTime = schedule.getDepartureTime() + (long)(departureDeviation * 1000);
        this.setPredictedDepartureTimeForInstance(instance, departureTime);
    }

    private void setPredictedTimeIntervals(ArrivalAndDepartureInstance instance, BlockLocation blockLocation, long targetTime) {
        TimeIntervalBean predictedArrivalTimeInterval = this.computePredictedArrivalTimeInterval(instance, blockLocation, targetTime);
        instance.setPredictedArrivalInterval(predictedArrivalTimeInterval);
        TimeIntervalBean predictedDepartureTimeInterval = this.computePredictedDepartureTimeInterval(instance, blockLocation, targetTime);
        instance.setPredictedDepartureInterval(predictedDepartureTimeInterval);
    }

    private void setPredictedArrivalTimeForInstance(ArrivalAndDepartureInstance instance, long arrivalTime) {
        instance.setPredictedArrivalTime(arrivalTime);
        if (instance.getFrequency() != null) {
            instance.setScheduledArrivalTime(arrivalTime);
        }
    }

    private void setPredictedDepartureTimeForInstance(ArrivalAndDepartureInstance instance, long departureTime) {
        instance.setPredictedDepartureTime(departureTime);
        if (instance.getFrequency() != null) {
            instance.setScheduledDepartureTime(departureTime);
        }
    }

    private int calculateArrivalDeviation(BlockStopTimeEntry nextBlockStopTime, BlockStopTimeEntry targetBlockStopTime, int effectiveScheduleTime, int scheduleDeviation) {
        if (nextBlockStopTime == null || nextBlockStopTime.getBlockSequence() > targetBlockStopTime.getBlockSequence()) {
            return scheduleDeviation;
        }
        int a = targetBlockStopTime.getAccumulatedSlackTime();
        int b = nextBlockStopTime.getAccumulatedSlackTime();
        double slack = a - b;
        StopTimeEntry nextStopTime = nextBlockStopTime.getStopTime();
        if (nextStopTime.getArrivalTime() <= effectiveScheduleTime && effectiveScheduleTime <= nextStopTime.getDepartureTime()) {
            slack -= (double)(effectiveScheduleTime - nextStopTime.getArrivalTime());
        }
        if ((slack = Math.max(slack, 0.0)) > 0.0 && scheduleDeviation > 0) {
            scheduleDeviation = (int)((double)scheduleDeviation - Math.min((double)scheduleDeviation, slack));
        }
        return scheduleDeviation;
    }

    private int calculateDepartureDeviation(BlockStopTimeEntry nextBlockStopTime, BlockStopTimeEntry targetBlockStopTime, int effectiveScheduleTime, int scheduleDeviation) {
        if (nextBlockStopTime == null || nextBlockStopTime.getBlockSequence() > targetBlockStopTime.getBlockSequence()) {
            return scheduleDeviation;
        }
        StopTimeEntry nextStopTime = nextBlockStopTime.getStopTime();
        StopTimeEntry targetStopTime = targetBlockStopTime.getStopTime();
        double slack = targetBlockStopTime.getAccumulatedSlackTime() - nextBlockStopTime.getAccumulatedSlackTime();
        slack += (double)targetStopTime.getSlackTime();
        if (nextStopTime.getArrivalTime() <= effectiveScheduleTime && effectiveScheduleTime <= nextStopTime.getDepartureTime()) {
            slack -= (double)(effectiveScheduleTime - nextStopTime.getArrivalTime());
        }
        if ((slack = Math.max(slack, 0.0)) > 0.0 && scheduleDeviation > 0) {
            scheduleDeviation = (int)((double)scheduleDeviation - Math.min((double)scheduleDeviation, slack));
        }
        return scheduleDeviation;
    }

    private int propagateScheduleDeviationForwardBetweenStops(BlockStopTimeEntry prevStopTime, BlockStopTimeEntry nextStopTime, int scheduleDeviation) {
        int slack = nextStopTime.getAccumulatedSlackTime() - prevStopTime.getAccumulatedSlackTime();
        return this.propagateScheduleDeviationForwardWithSlack(scheduleDeviation, slack -= prevStopTime.getStopTime().getSlackTime());
    }

    private int propagateScheduleDeviationForwardAcrossStop(BlockStopTimeEntry stopTime, int scheduleDeviation) {
        int slack = stopTime.getStopTime().getSlackTime();
        return this.propagateScheduleDeviationForwardWithSlack(scheduleDeviation, slack);
    }

    private int propagateScheduleDeviationBackwardBetweenStops(BlockStopTimeEntry prevStopTime, BlockStopTimeEntry nextStopTime, int scheduleDeviation) {
        return scheduleDeviation;
    }

    private int propagateScheduleDeviationBackwardAcrossStop(BlockStopTimeEntry stopTime, int scheduleDeviation) {
        return scheduleDeviation;
    }

    private int propagateScheduleDeviationForwardWithSlack(int scheduleDeviation, int slack) {
        if (scheduleDeviation < 0) {
            if (slack > 0) {
                return 0;
            }
            return scheduleDeviation;
        }
        return Math.max(0, scheduleDeviation - slack);
    }

    private TimeIntervalBean computePredictedArrivalTimeInterval(ArrivalAndDepartureInstance instance, BlockLocation blockLocation, long targetTime) {
        BlockStopTimeEntry blockStopTime = instance.getBlockStopTime();
        StopTimeEntry stopTime = blockStopTime.getStopTime();
        if (stopTime.getArrivalTime() <= blockLocation.getEffectiveScheduleTime()) {
            return null;
        }
        ScheduleDeviationSamples samples = blockLocation.getScheduleDeviations();
        if (samples == null || samples.isEmpty()) {
            return null;
        }
        double mu = InterpolationLibrary.interpolate((double[])samples.getScheduleTimes(), (double[])samples.getScheduleDeviationMus(), (double)stopTime.getArrivalTime(), (EOutOfRangeStrategy)EOutOfRangeStrategy.LAST_VALUE, (EInRangeStrategy)EInRangeStrategy.INTERPOLATE);
        double sigma = InterpolationLibrary.interpolate((double[])samples.getScheduleTimes(), (double[])samples.getScheduleDeviationSigmas(), (double)stopTime.getArrivalTime(), (EOutOfRangeStrategy)EOutOfRangeStrategy.LAST_VALUE, (EInRangeStrategy)EInRangeStrategy.INTERPOLATE);
        long from = (long)((double)instance.getScheduledArrivalTime() + (mu - sigma) * 1000.0);
        long to = (long)((double)instance.getScheduledArrivalTime() + (mu + sigma) * 1000.0);
        return new TimeIntervalBean(from, to);
    }

    private TimeIntervalBean computePredictedDepartureTimeInterval(ArrivalAndDepartureInstance instance, BlockLocation blockLocation, long targetTime) {
        BlockStopTimeEntry blockStopTime = instance.getBlockStopTime();
        StopTimeEntry stopTime = blockStopTime.getStopTime();
        if (stopTime.getDepartureTime() <= blockLocation.getEffectiveScheduleTime()) {
            return null;
        }
        ScheduleDeviationSamples samples = blockLocation.getScheduleDeviations();
        if (samples == null || samples.isEmpty()) {
            return null;
        }
        double mu = InterpolationLibrary.interpolate((double[])samples.getScheduleTimes(), (double[])samples.getScheduleDeviationMus(), (double)stopTime.getDepartureTime(), (EOutOfRangeStrategy)EOutOfRangeStrategy.LAST_VALUE, (EInRangeStrategy)EInRangeStrategy.INTERPOLATE);
        double sigma = InterpolationLibrary.interpolate((double[])samples.getScheduleTimes(), (double[])samples.getScheduleDeviationSigmas(), (double)stopTime.getDepartureTime(), (EOutOfRangeStrategy)EOutOfRangeStrategy.LAST_VALUE, (EInRangeStrategy)EInRangeStrategy.INTERPOLATE);
        long from = (long)((double)instance.getScheduledDepartureTime() + (mu - sigma) * 1000.0);
        long to = (long)((double)instance.getScheduledDepartureTime() + (mu + sigma) * 1000.0);
        return new TimeIntervalBean(from, to);
    }

    private boolean isArrivalAndDepartureBeanInRange(ArrivalAndDepartureInstance instance, long timeFrom, long timeTo) {
        if (timeFrom <= instance.getScheduledArrivalTime() && instance.getScheduledArrivalTime() <= timeTo) {
            return true;
        }
        if (timeFrom <= instance.getScheduledDepartureTime() && instance.getScheduledDepartureTime() <= timeTo) {
            return true;
        }
        if (instance.isPredictedArrivalTimeSet() && timeFrom <= instance.getPredictedArrivalTime() && instance.getPredictedArrivalTime() <= timeTo) {
            return true;
        }
        return instance.isPredictedDepartureTimeSet() && timeFrom <= instance.getPredictedDepartureTime() && instance.getPredictedDepartureTime() <= timeTo;
    }

    private boolean isFrequencyBasedArrivalInRange(BlockInstance blockInstance, FrequencyEntry frequency, long fromReduced, long toReduced) {
        long startTime = blockInstance.getServiceDate() + (long)(frequency.getStartTime() * 1000);
        long endTime = blockInstance.getServiceDate() + (long)(frequency.getEndTime() * 1000);
        return fromReduced <= endTime && startTime <= toReduced;
    }

    private ArrivalAndDepartureInstance createArrivalAndDepartureForStopTimeInstanceWithTime(StopTimeInstance sti, long time) {
        ArrivalAndDepartureTime scheduledTime = new ArrivalAndDepartureTime(time, time);
        ArrivalAndDepartureInstance instance = new ArrivalAndDepartureInstance(sti, scheduledTime);
        instance.setBlockSequence(sti.getBlockSequence());
        return instance;
    }

    private ArrivalAndDepartureInstance createArrivalAndDepartureForStopTimeInstance(StopTimeInstance sti, long prevFrequencyTime) {
        ArrivalAndDepartureInstance instance = this.createArrivalAndDeparture(sti, prevFrequencyTime, sti.getFrequencyOffset());
        instance.setBlockSequence(sti.getBlockSequence());
        return instance;
    }

    private ArrivalAndDepartureInstance createArrivalAndDeparture(BlockInstance blockInstance, AgencyAndId tripId, AgencyAndId stopId, int stopSequence, long serviceDate, int timeOfServiceDate, long prevFrequencyTime) {
        BlockTripInstance blockTripInstance = BlockTripInstanceLibrary.getBlockTripInstance(blockInstance, tripId);
        if (blockTripInstance == null) {
            return null;
        }
        BlockStopTimeEntry blockStopTime = this.getBlockStopTime(blockTripInstance, stopId, stopSequence, timeOfServiceDate);
        if (blockStopTime == null) {
            _log.error("block stop time is null for stopid=" + stopId + " and blockTripInstance=" + blockTripInstance + " and timeOfServiceDate=" + timeOfServiceDate);
            return null;
        }
        StopTimeInstance stopTimeInstance = new StopTimeInstance(blockStopTime, blockTripInstance.getState());
        return this.createArrivalAndDeparture(stopTimeInstance, prevFrequencyTime, Integer.MIN_VALUE);
    }

    private BlockStopTimeEntry getBlockStopTime(BlockTripInstance blockTripInstance, AgencyAndId stopId, int stopSequence, int timeOfServiceDate) {
        BlockTripEntry blockTrip = blockTripInstance.getBlockTrip();
        TripEntry trip = blockTrip.getTrip();
        List<StopTimeEntry> stopTimes = trip.getStopTimes();
        if (stopSequence > -1) {
            int offset = 0;
            while (true) {
                int before;
                if (this.isMatch(stopTimes, stopId, before = stopSequence - offset)) {
                    return blockTrip.getStopTimes().get(before);
                }
                int after = stopSequence + offset;
                if (this.isMatch(stopTimes, stopId, after)) {
                    return blockTrip.getStopTimes().get(after);
                }
                if (before < 0 && after >= stopTimes.size()) {
                    return null;
                }
                ++offset;
            }
        }
        Min m = new Min();
        int index = 0;
        for (StopTimeEntry stopTime : stopTimes) {
            if (stopTime.getStop().getId().equals((Object)stopId)) {
                int a = Math.abs(timeOfServiceDate - stopTime.getArrivalTime());
                int b = Math.abs(timeOfServiceDate - stopTime.getDepartureTime());
                int delta = Math.min(a, b);
                m.add((double)delta, (Object)blockTrip.getStopTimes().get(index));
            }
            ++index;
        }
        if (m.isEmpty()) {
            return null;
        }
        return (BlockStopTimeEntry)m.getMinElement();
    }

    private boolean isMatch(List<StopTimeEntry> stopTimes, AgencyAndId stopId, int index) {
        if (index < 0 || index >= stopTimes.size()) {
            return false;
        }
        StopTimeEntry stopTime = stopTimes.get(index);
        StopEntry stop = stopTime.getStop();
        return stop.getId().equals((Object)stopId);
    }

    private ArrivalAndDepartureInstance createArrivalAndDeparture(StopTimeInstance stopTimeInstance, long prevFrequencyTime, int frequencyOffset) {
        ArrivalAndDepartureTime scheduledTime = this.getScheduledTime(stopTimeInstance, prevFrequencyTime, frequencyOffset);
        return new ArrivalAndDepartureInstance(stopTimeInstance, scheduledTime);
    }

    private ArrivalAndDepartureTime getScheduledTime(StopTimeInstance stopTimeInstance, long prevFrequencyTime, int frequencyOffset) {
        FrequencyEntry frequency = stopTimeInstance.getFrequency();
        if (frequency == null) {
            return ArrivalAndDepartureTime.getScheduledTime(stopTimeInstance);
        }
        if (StopTimeInstance.isFrequencyOffsetSpecified(frequencyOffset)) {
            return ArrivalAndDepartureTime.getScheduledTime(stopTimeInstance.getServiceDate(), stopTimeInstance.getStopTime(), frequencyOffset);
        }
        long departureTime = prevFrequencyTime + (long)(frequency.getHeadwaySecs() * 1000 / 2);
        long freqStartTime = stopTimeInstance.getServiceDate() + (long)(frequency.getStartTime() * 1000);
        long freqEndTime = stopTimeInstance.getServiceDate() + (long)(frequency.getEndTime() * 1000);
        if (departureTime < freqStartTime) {
            departureTime = freqStartTime;
        }
        if (departureTime > freqEndTime) {
            departureTime = freqEndTime;
        }
        BlockStopTimeEntry blockStopTime = stopTimeInstance.getStopTime();
        StopTimeEntry stopTime = blockStopTime.getStopTime();
        int delta = stopTime.getDepartureTime() - stopTime.getArrivalTime();
        long arrivalTime = departureTime - (long)(delta * 1000);
        return new ArrivalAndDepartureTime(arrivalTime, departureTime);
    }
}

