/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.geospatial.model.EncodedPolylineBean;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.NameBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.RouteGroupingBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopGroupBean;
import org.onebusaway.transit_data.model.StopGroupingBean;
import org.onebusaway.transit_data.model.StopsForRouteBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.impl.transit_graph.CanonicalRoutesEntryImpl;
import org.onebusaway.transit_data_federation.services.CanonicalRoutesService;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.transit_graph.CanonicalRoutesEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteStopCollectionEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CanonicalRoutesServiceImpl
implements CanonicalRoutesService {
    private static Logger _log = LoggerFactory.getLogger(CanonicalRoutesServiceImpl.class);
    @Autowired
    private FederatedTransitDataBundle _bundle;
    @Autowired
    public TransitDataService _transitDataService;
    private CanonicalRoutesEntry _entry;

    public void setTransitDataService(TransitDataService tds) {
        this._transitDataService = tds;
    }

    void setData(CanonicalRoutesEntry data) {
        this._entry = data;
    }

    @PostConstruct
    @Refreshable(dependsOn={"transitGraph"})
    public void setup() throws IOException, ClassNotFoundException {
        _log.info("bundle path=" + this._bundle.getPath());
        File path = this._bundle.getCanonicalRoutePath();
        if (path.exists()) {
            _log.info("loading optional canonical routes and shapes at {}", (Object)path);
            try {
                this._entry = (CanonicalRoutesEntry)ObjectSerializationLibrary.readObject((File)path);
            }
            catch (Throwable t) {
                this._entry = new CanonicalRoutesEntryImpl();
                _log.error("failed to load option canonical routes with exception {}", (Object)t, (Object)t);
                return;
            }
            _log.info("loading canonical routes and shapes...done");
        } else {
            _log.info("failed CanonicalRoutesServiceImpl load, path not found of " + path);
            this._entry = new CanonicalRoutesEntryImpl();
        }
    }

    @Override
    @Cacheable
    public ListBean<RouteGroupingBean> getCanonicalOrMergedRoute(AgencyServiceInterval serviceInterval, AgencyAndId routeId) {
        StopsForRouteBean stopsForRoute = serviceInterval != null ? this.copy(this._transitDataService.getStopsForRouteForServiceInterval(AgencyAndIdLibrary.convertToString((AgencyAndId)routeId), serviceInterval)) : this.copy(this._transitDataService.getStopsForRoute(AgencyAndIdLibrary.convertToString((AgencyAndId)routeId)));
        if (stopsForRoute == null || stopsForRoute.getStopGroupings() == null || stopsForRoute.getStopGroupings().isEmpty()) {
            return this.addReferences(this.createRouteDirectionBean(routeId, serviceInterval), serviceInterval);
        }
        return this.addReferences(this.merge(routeId, stopsForRoute, this.createRouteDirectionBean(routeId, serviceInterval)), serviceInterval);
    }

    private ListBean<RouteGroupingBean> addReferences(ListBean<RouteGroupingBean> bean, AgencyServiceInterval serviceInterval) {
        if (bean == null || bean.getList() == null) {
            return bean;
        }
        for (RouteGroupingBean routeGroupingBean : bean.getList()) {
            this.addReferences(routeGroupingBean, serviceInterval);
        }
        return bean;
    }

    private void addReferences(RouteGroupingBean bean, AgencyServiceInterval serviceInterval) {
        if (bean == null) {
            return;
        }
        HashSet<AgencyAndId> visitedRoutes = new HashSet<AgencyAndId>();
        HashSet<AgencyAndId> visitedStops = new HashSet<AgencyAndId>();
        if (bean.getRouteId() != null) {
            visitedRoutes.add(bean.getRouteId());
        }
        if (bean.getStopGroupings() == null) {
            this.loadReferences(bean, visitedRoutes, visitedStops, serviceInterval);
            return;
        }
        for (StopGroupingBean stopGrouping : bean.getStopGroupings()) {
            for (StopGroupBean stopGroup : stopGrouping.getStopGroups()) {
                for (String stopId : stopGroup.getStopIds()) {
                    try {
                        AgencyAndId stop = AgencyAndIdLibrary.convertFromString((String)stopId);
                        if (stop == null) continue;
                        visitedStops.add(stop);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        }
        this.loadReferences(bean, visitedRoutes, visitedStops, serviceInterval);
    }

    private void loadReferences(RouteGroupingBean bean, Set<AgencyAndId> visitedRoutes, Set<AgencyAndId> visitedStops, AgencyServiceInterval serviceInterval) {
        for (AgencyAndId visitedRoute : visitedRoutes) {
            RouteBean route = this._transitDataService.getRouteForId(AgencyAndIdLibrary.convertToString((AgencyAndId)visitedRoute));
            if (route == null) continue;
            bean.getRoutes().add(route);
        }
        for (AgencyAndId visitedStop : visitedStops) {
            StopBean stop = this._transitDataService.getStopForServiceDate(AgencyAndIdLibrary.convertToString((AgencyAndId)visitedStop), serviceInterval);
            if (stop == null) continue;
            bean.getStops().add(stop);
        }
    }

    private ListBean<RouteGroupingBean> merge(AgencyAndId routeId, StopsForRouteBean stopsForRoute, ListBean<RouteGroupingBean> beans) {
        RouteGroupingBean bean = null;
        List list = beans == null || beans.getList() == null ? new ArrayList() : beans.getList();
        if (list.isEmpty()) {
            bean = new RouteGroupingBean();
            bean.setRouteId(routeId);
            bean.setStopGroupings(new ArrayList());
            list.add(bean);
        } else {
            bean = (RouteGroupingBean)list.get(0);
        }
        bean.getStopGroupings().addAll(stopsForRoute.getStopGroupings());
        for (StopGroupingBean stopGrouping : bean.getStopGroupings()) {
            Collections.sort(stopGrouping.getStopGroups(), new Comparator<StopGroupBean>(){

                @Override
                public int compare(StopGroupBean o1, StopGroupBean o2) {
                    if (o1.getId() == null && o2.getId() == null) {
                        return 0;
                    }
                    if (o1.getId() == null) {
                        return -1;
                    }
                    if (o2.getId() == null) {
                        return 1;
                    }
                    return o1.getId().compareTo(o2.getId());
                }
            });
        }
        return beans;
    }

    private ListBean<RouteGroupingBean> createRouteDirectionBean(AgencyAndId routeId, AgencyServiceInterval serviceInterval) {
        ArrayList<RouteGroupingBean> results = new ArrayList<RouteGroupingBean>();
        RouteGroupingBean bean = null;
        List<RouteStopCollectionEntry> rscs = this._entry.getRouteStopCollectionEntries(routeId);
        if (rscs != null) {
            bean = this.createBeanFromBundle(routeId, rscs);
        }
        if (bean == null) {
            bean = this.createBeanFromHeuristic(routeId, serviceInterval);
        }
        if (bean == null) {
            bean = this.createBeanWithCanonicalShapes(routeId);
        } else {
            this.addCanonicalShapes(routeId, bean);
        }
        if (bean != null) {
            results.add(bean);
        }
        ListBean result = new ListBean(results, false);
        return result;
    }

    private boolean addCanonicalShapes(AgencyAndId routeId, RouteGroupingBean bean) {
        Map<String, String> directionToShapeMap = this._entry.getDirectionToShapeMap(routeId);
        if (directionToShapeMap == null) {
            return false;
        }
        for (String directionId : directionToShapeMap.keySet()) {
            StopGroupBean sg = this.findStopGroup(bean, routeId, directionId, "canonical");
            if (sg == null) {
                sg = this.createStopGroup(bean, routeId, directionId, "canonical");
            }
            EncodedPolylineBean epl = new EncodedPolylineBean();
            epl.setPoints(directionToShapeMap.get(directionId));
            if (sg.getPolylines() == null) {
                sg.setPolylines(new ArrayList());
            }
            sg.getPolylines().add(epl);
        }
        return true;
    }

    private StopGroupBean createStopGroup(RouteGroupingBean bean, AgencyAndId routeId, String directionId, String canonicalType) {
        StopGroupBean stopGroupBean = new StopGroupBean();
        stopGroupBean.setId(directionId);
        boolean found = false;
        for (StopGroupingBean stopGrouping : bean.getStopGroupings()) {
            if (!canonicalType.equals(stopGrouping.getType())) continue;
            if (stopGrouping.getStopGroups() == null) {
                stopGrouping.setStopGroups(new ArrayList());
            }
            stopGrouping.getStopGroups().add(stopGroupBean);
            found = true;
        }
        if (!found) {
            StopGroupingBean stopGroupingBean = new StopGroupingBean();
            stopGroupingBean.setType(canonicalType);
            stopGroupingBean.setOrdered(false);
            stopGroupingBean.setStopGroups(new ArrayList());
            stopGroupingBean.getStopGroups().add(stopGroupBean);
            bean.getStopGroupings().add(stopGroupingBean);
        }
        return stopGroupBean;
    }

    private StopGroupBean findStopGroup(RouteGroupingBean bean, AgencyAndId routeId, String directionId, String canonicalType) {
        for (StopGroupingBean stopGrouping : bean.getStopGroupings()) {
            if (!canonicalType.equals(stopGrouping.getType())) continue;
            if (stopGrouping.getStopGroups() == null) {
                stopGrouping.setStopGroups(new ArrayList());
            }
            for (StopGroupBean stopGroupBean : stopGrouping.getStopGroups()) {
                if (!directionId.equals(stopGroupBean.getId())) continue;
                return stopGroupBean;
            }
        }
        return null;
    }

    private RouteGroupingBean createBeanWithCanonicalShapes(AgencyAndId routeId) {
        RouteGroupingBean bean = new RouteGroupingBean();
        bean.setStopGroupings(new ArrayList());
        boolean foundShapes = this.addCanonicalShapes(routeId, bean);
        if (!foundShapes) {
            return null;
        }
        return bean;
    }

    private RouteGroupingBean createBeanFromHeuristic(AgencyAndId routeId, AgencyServiceInterval serviceInterval) {
        StopsForRouteBean stops = null;
        stops = serviceInterval != null ? this._transitDataService.getStopsForRouteForServiceInterval(AgencyAndIdLibrary.convertToString((AgencyAndId)routeId), serviceInterval) : this._transitDataService.getStopsForRoute(AgencyAndIdLibrary.convertToString((AgencyAndId)routeId));
        if (stops == null || stops.getStopGroupings() == null || stops.getStopGroupings().isEmpty()) {
            return null;
        }
        for (StopGroupingBean stopGrouping : stops.getStopGroupings()) {
            stopGrouping.setType("heuristic");
        }
        RouteGroupingBean bean = new RouteGroupingBean();
        bean.setRouteId(routeId);
        bean.setStopGroupings(stops.getStopGroupings());
        return bean;
    }

    private RouteGroupingBean createBeanFromBundle(AgencyAndId routeId, List<RouteStopCollectionEntry> rscs) {
        RouteGroupingBean bean = new RouteGroupingBean();
        bean.setStopGroupings(new ArrayList());
        if (rscs == null) {
            return null;
        }
        for (RouteStopCollectionEntry rsc : rscs) {
            if (rsc == null) continue;
            bean.setRouteId(rsc.getRouteId());
            List<StopGroupingBean> stopGroupings = this.createStopGroupings(rsc);
            if (stopGroupings == null || stopGroupings.isEmpty()) continue;
            bean.getStopGroupings().addAll(stopGroupings);
        }
        if (bean.getStopGroupings().isEmpty()) {
            return null;
        }
        return bean;
    }

    private List<StopGroupingBean> createStopGroupings(RouteStopCollectionEntry rsc) {
        ArrayList<StopGroupingBean> results = new ArrayList<StopGroupingBean>();
        if (rsc.getRouteStops() == null) {
            return results;
        }
        StopGroupingBean stopGroupingBean = new StopGroupingBean();
        stopGroupingBean.setStopGroups(new ArrayList());
        stopGroupingBean.setType("canonical");
        StopGroupBean stopGroupBean = new StopGroupBean();
        stopGroupBean.setId(this.nullSafeGet(rsc.getId()));
        stopGroupBean.setName(new NameBean("name", new String[]{rsc.getName()}));
        stopGroupBean.setStopIds(new ArrayList());
        stopGroupingBean.getStopGroups().add(stopGroupBean);
        results.add(stopGroupingBean);
        for (RouteStopCollectionEntry.StopAndSequence routeStop : rsc.getRouteStops()) {
            stopGroupBean.getStopIds().add(AgencyAndIdLibrary.convertToString((AgencyAndId)routeStop.getStopId()));
        }
        return results;
    }

    private StopsForRouteBean copy(StopsForRouteBean input) {
        if (input == null) {
            return null;
        }
        StopsForRouteBean output = new StopsForRouteBean();
        output.setRoute(input.getRoute());
        output.setStops(input.getStops());
        output.setPolylines(input.getPolylines());
        output.setStopGroupings(this.copyStopGroupingList(input.getStopGroupings()));
        return output;
    }

    private List<StopGroupingBean> copyStopGroupingList(List<StopGroupingBean> stopGroupings) {
        if (stopGroupings == null) {
            return null;
        }
        ArrayList<StopGroupingBean> output = new ArrayList<StopGroupingBean>();
        for (StopGroupingBean input : stopGroupings) {
            output.add(this.copy(input));
        }
        return output;
    }

    private StopGroupingBean copy(StopGroupingBean input) {
        if (input == null) {
            return null;
        }
        StopGroupingBean output = new StopGroupingBean();
        output.setType(input.getType());
        output.setOrdered(input.isOrdered());
        output.setStopGroups(this.copy(input.getStopGroups()));
        return output;
    }

    private List<StopGroupBean> copy(List<StopGroupBean> inputs) {
        if (inputs == null) {
            return null;
        }
        ArrayList<StopGroupBean> output = new ArrayList<StopGroupBean>();
        for (StopGroupBean input : inputs) {
            output.add(this.copy(input));
        }
        return output;
    }

    private StopGroupBean copy(StopGroupBean input) {
        if (input == null) {
            return null;
        }
        StopGroupBean output = new StopGroupBean();
        output.setId(input.getId());
        output.setName(input.getName());
        output.setPolylines(input.getPolylines());
        output.setStopIds(input.getStopIds());
        output.setSubGroups(this.copy(input.getSubGroups()));
        return output;
    }

    private String nullSafeGet(String id) {
        if (id == null) {
            return "";
        }
        return id;
    }
}

