/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.onebusaway.collections.CollectionsLibrary;
import org.onebusaway.container.cache.Cacheable;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.gtfs.services.calendar.CalendarService;
import org.onebusaway.transit_data_federation.services.ExtendedCalendarService;
import org.onebusaway.transit_data_federation.services.realtime.DynamicCalendarService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExtendedCalendarServiceImpl
implements ExtendedCalendarService {
    private CalendarService _calendarService;
    private DynamicCalendarService _dynamicCalendarService;
    private TransitGraphDao _transitGraphDao;
    private Map<ServiceIdActivation, List<Date>> _serviceDatesByServiceIds = new HashMap<ServiceIdActivation, List<Date>>();
    private double _serviceDateRangeCacheInterval = 14400.0;
    private Cache _serviceDateRangeCache;
    private int _serviceDateLowerBoundsInWeeks = -1;
    private int _serviceDateUpperBoundsInWeeks = -1;

    public void setServiceDateLowerBoundsInWeeks(int serviceDateLowerBoundsInWeeks) {
        this._serviceDateLowerBoundsInWeeks = serviceDateLowerBoundsInWeeks;
    }

    public void setServiceDateUpperBoundsInWeeks(int serviceDateUpperBoundsInWeeks) {
        this._serviceDateUpperBoundsInWeeks = serviceDateUpperBoundsInWeeks;
    }

    @Autowired
    public void setCalendarService(CalendarService calendarService) {
        this._calendarService = calendarService;
    }

    @Autowired
    public void setDynamicCalendarService(DynamicCalendarService dcs) {
        this._dynamicCalendarService = dcs;
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    public void setServiceDateRangeCacheInterval(int hours) {
        this._serviceDateRangeCacheInterval = hours * 60 * 60;
    }

    public void setServiceDateRangeCache(Cache serviceDateRangeCache) {
        this._serviceDateRangeCache = serviceDateRangeCache;
    }

    @PostConstruct
    @Refreshable(dependsOn={"calendarData"})
    public void start() {
        this.cacheServiceDatesForServiceIds();
    }

    @Override
    @Cacheable
    public Set<ServiceDate> getServiceDatesForServiceIds(ServiceIdActivation serviceIds) {
        Set dates;
        HashSet serviceDates = null;
        List<LocalizedServiceId> activeServiceIds = serviceIds.getActiveServiceIds();
        List<LocalizedServiceId> inactiveServiceIds = serviceIds.getInactiveServiceIds();
        for (LocalizedServiceId activeServiceId : activeServiceIds) {
            dates = this._calendarService.getServiceDatesForServiceId(activeServiceId.getId());
            if (dates.isEmpty()) {
                return Collections.emptySet();
            }
            if (serviceDates == null) {
                serviceDates = new HashSet(dates);
            } else {
                serviceDates.retainAll(dates);
            }
            if (!serviceDates.isEmpty()) continue;
            return Collections.emptySet();
        }
        for (LocalizedServiceId inactiveServiceId : inactiveServiceIds) {
            dates = this._calendarService.getServiceDatesForServiceId(inactiveServiceId.getId());
            serviceDates.removeAll(dates);
        }
        return serviceDates;
    }

    @Override
    @Cacheable
    public Set<Date> getDatesForServiceIds(ServiceIdActivation serviceIds) {
        List dates;
        HashSet serviceDates = null;
        List<LocalizedServiceId> activeServiceIds = serviceIds.getActiveServiceIds();
        List<LocalizedServiceId> inactiveServiceIds = serviceIds.getInactiveServiceIds();
        for (LocalizedServiceId activeServiceId : activeServiceIds) {
            dates = this._calendarService.getDatesForLocalizedServiceId(activeServiceId);
            if (dates.isEmpty()) {
                return Collections.emptySet();
            }
            if (serviceDates == null) {
                serviceDates = new HashSet(dates);
            } else {
                serviceDates.retainAll(dates);
            }
            if (!serviceDates.isEmpty()) continue;
            return Collections.emptySet();
        }
        for (LocalizedServiceId inactiveServiceId : inactiveServiceIds) {
            dates = this._calendarService.getDatesForLocalizedServiceId(inactiveServiceId);
            serviceDates.removeAll(dates);
        }
        return serviceDates;
    }

    @Override
    @Cacheable
    public List<Date> getDatesForServiceIdsAsOrderedList(ServiceIdActivation serviceIds) {
        Set<Date> dates = this.getDatesForServiceIds(serviceIds);
        ArrayList<Date> list = new ArrayList<Date>(dates);
        Collections.sort(list);
        return list;
    }

    @Override
    public Collection<Date> getServiceDatesWithinRange(ServiceIdActivation serviceIds, ServiceInterval interval, Date from, Date to) {
        if (this._serviceDateRangeCache == null) {
            return this.getServiceDatesWithinRangeExact(serviceIds, interval, from, to);
        }
        ServiceDateRangeKey key = this.getCacheKey(serviceIds, interval, from, to);
        Element element = this._serviceDateRangeCache.get((Object)key);
        if (element == null) {
            serviceIds = key.getServiceIds();
            interval = key.getInterval();
            from = key.getFromTime();
            to = key.getToTime();
            Collection<Date> values = this.getServiceDatesWithinRangeExact(serviceIds, interval, from, to);
            element = new Element((Object)key, values);
            this._serviceDateRangeCache.put(element);
        }
        return (Collection)((Object)element.getValue());
    }

    @Override
    @Cacheable
    public boolean areServiceIdsActiveOnServiceDate(ServiceIdActivation serviceIds, Date serviceDate) {
        List<LocalizedServiceId> activeServiceIds = serviceIds.getActiveServiceIds();
        List<LocalizedServiceId> inactiveServiceIds = serviceIds.getInactiveServiceIds();
        if (activeServiceIds.size() == 1 && inactiveServiceIds.isEmpty()) {
            LocalizedServiceId lsid = activeServiceIds.get(0);
            if (this._dynamicCalendarService != null && this._dynamicCalendarService.hasServiceId(lsid)) {
                return this._dynamicCalendarService.isLocalizedServiceIdActiveOnDate(lsid, serviceDate);
            }
            return this._calendarService.isLocalizedServiceIdActiveOnDate(lsid, serviceDate);
        }
        for (LocalizedServiceId lsid : activeServiceIds) {
            if (this._calendarService.isLocalizedServiceIdActiveOnDate(lsid, serviceDate)) continue;
            return false;
        }
        for (LocalizedServiceId lsid : inactiveServiceIds) {
            if (!this._calendarService.isLocalizedServiceIdActiveOnDate(lsid, serviceDate)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Date> getServiceDatesForInterval(ServiceIdActivation serviceIds, ServiceInterval serviceInterval, long time, boolean findDepartures) {
        if (findDepartures) {
            return this.getNextServiceDatesForDepartureInterval(serviceIds, serviceInterval, time);
        }
        return this.getPreviousServiceDatesForArrivalInterval(serviceIds, serviceInterval, time);
    }

    @Override
    public List<Date> getNextServiceDatesForDepartureInterval(ServiceIdActivation serviceIds, ServiceInterval serviceInterval, long time) {
        List<Date> serviceDates = this._serviceDatesByServiceIds.get(serviceIds);
        if (CollectionsLibrary.isEmpty(serviceDates)) {
            return Collections.emptyList();
        }
        int offset = (serviceInterval.getMaxDeparture() - serviceInterval.getMinDeparture()) * 1000;
        Date offsetDate = new Date(time - (long)offset);
        int startIndex = Collections.binarySearch(serviceDates, offsetDate);
        if (startIndex < 0) {
            startIndex = -(startIndex + 1);
        }
        startIndex = Math.max(0, startIndex - 1);
        ArrayList<Date> serviceDatesToReturn = new ArrayList<Date>();
        boolean directHit = false;
        for (int index = startIndex; index < serviceDates.size(); ++index) {
            Date serviceDate = serviceDates.get(index);
            long timeFrom = serviceDate.getTime() + (long)(serviceInterval.getMinDeparture() * 1000);
            long timeTo = serviceDate.getTime() + (long)(serviceInterval.getMaxDeparture() * 1000);
            if (time < timeFrom) {
                if (!directHit) {
                    serviceDatesToReturn.add(serviceDate);
                }
                return serviceDatesToReturn;
            }
            if (timeFrom > time || time > timeTo) continue;
            serviceDatesToReturn.add(serviceDate);
            directHit = true;
        }
        return serviceDatesToReturn;
    }

    @Override
    public List<Date> getPreviousServiceDatesForArrivalInterval(ServiceIdActivation serviceIds, ServiceInterval serviceInterval, long time) {
        List<Date> serviceDates = this._serviceDatesByServiceIds.get(serviceIds);
        if (CollectionsLibrary.isEmpty(serviceDates)) {
            return Collections.emptyList();
        }
        int offset = (serviceInterval.getMaxDeparture() - serviceInterval.getMinDeparture()) * 1000;
        Date offsetDate = new Date(time + (long)offset);
        int endIndex = Collections.binarySearch(serviceDates, offsetDate);
        if (endIndex < 0) {
            endIndex = -(endIndex + 1);
        }
        endIndex = Math.min(serviceDates.size() - 1, endIndex + 1);
        ArrayList<Date> serviceDatesToReturn = new ArrayList<Date>();
        boolean directHit = false;
        for (int index = endIndex; index >= 0; --index) {
            Date serviceDate = serviceDates.get(index);
            long timeFrom = serviceDate.getTime() + (long)(serviceInterval.getMinDeparture() * 1000);
            long timeTo = serviceDate.getTime() + (long)(serviceInterval.getMaxDeparture() * 1000);
            if (time > timeTo) {
                if (!directHit) {
                    serviceDatesToReturn.add(serviceDate);
                }
                return serviceDatesToReturn;
            }
            if (timeFrom > time || time > timeTo) continue;
            serviceDatesToReturn.add(serviceDate);
            directHit = true;
        }
        return serviceDatesToReturn;
    }

    private ServiceDateRangeKey getCacheKey(ServiceIdActivation serviceIds, ServiceInterval interval, Date from, Date to) {
        Serializable serviceIdsKey = this.getServiceIdsKey(serviceIds);
        int fromStopTime = (int)(Math.floor((double)interval.getMinArrival() / this._serviceDateRangeCacheInterval) * this._serviceDateRangeCacheInterval);
        int toStopTime = (int)(Math.ceil((double)interval.getMaxDeparture() / this._serviceDateRangeCacheInterval) * this._serviceDateRangeCacheInterval);
        double m = this._serviceDateRangeCacheInterval * 1000.0;
        long fromTime = (long)(Math.floor((double)from.getTime() / m) * m);
        long toTime = (long)(Math.ceil((double)to.getTime() / m) * m);
        return new ServiceDateRangeKey(serviceIdsKey, fromStopTime, toStopTime, fromTime, toTime);
    }

    private Serializable getServiceIdsKey(ServiceIdActivation serviceIds) {
        List<LocalizedServiceId> activeServiceIds = serviceIds.getActiveServiceIds();
        List<LocalizedServiceId> inactiveServiceIds = serviceIds.getInactiveServiceIds();
        if (activeServiceIds.size() == 1 && inactiveServiceIds.isEmpty()) {
            return (Serializable)activeServiceIds.get(0);
        }
        return serviceIds;
    }

    private Collection<Date> getServiceDatesWithinRangeExact(ServiceIdActivation serviceIds, ServiceInterval interval, Date from, Date to) {
        List dates;
        HashSet serviceDates = null;
        List<LocalizedServiceId> activeServiceIds = serviceIds.getActiveServiceIds();
        List<LocalizedServiceId> inactiveServiceIds = serviceIds.getInactiveServiceIds();
        if (activeServiceIds.size() == 1 && inactiveServiceIds.isEmpty()) {
            LocalizedServiceId localizedServiceId = activeServiceIds.get(0);
            if (this._dynamicCalendarService != null && this._dynamicCalendarService.hasServiceId(localizedServiceId)) {
                return this._dynamicCalendarService.getServiceDatesWithinRange(localizedServiceId, interval, from, to);
            }
            return this._calendarService.getServiceDatesWithinRange(localizedServiceId, interval, from, to);
        }
        for (LocalizedServiceId serviceId : activeServiceIds) {
            dates = this._calendarService.getServiceDatesWithinRange(serviceId, interval, from, to);
            if (dates.isEmpty()) {
                return Collections.emptyList();
            }
            if (serviceDates == null) {
                serviceDates = new HashSet(dates);
            } else {
                serviceDates.retainAll(serviceDates);
            }
            if (!serviceDates.isEmpty()) continue;
            return Collections.emptyList();
        }
        if (!inactiveServiceIds.isEmpty()) {
            for (LocalizedServiceId serviceId : inactiveServiceIds) {
                dates = this._calendarService.getServiceDatesWithinRange(serviceId, interval, from, to);
                serviceDates.removeAll(dates);
            }
        }
        return serviceDates;
    }

    private void cacheServiceDatesForServiceIds() {
        if (this._serviceDateRangeCache != null) {
            this._serviceDateRangeCache.removeAll();
        }
        this._serviceDatesByServiceIds.clear();
        Set<ServiceIdActivation> allServiceIds = this.determineAllServiceIds();
        Date lowerBounds = null;
        if (this._serviceDateLowerBoundsInWeeks != -1) {
            Calendar c = Calendar.getInstance();
            c.add(3, -this._serviceDateLowerBoundsInWeeks);
            lowerBounds = c.getTime();
        }
        Date upperBounds = null;
        if (this._serviceDateUpperBoundsInWeeks != -1) {
            Calendar c = Calendar.getInstance();
            c.add(3, this._serviceDateUpperBoundsInWeeks);
            upperBounds = c.getTime();
        }
        for (ServiceIdActivation serviceIds : allServiceIds) {
            List<Date> dates = this.computeServiceDatesForServiceIds(serviceIds, lowerBounds, upperBounds);
            this._serviceDatesByServiceIds.put(serviceIds, dates);
        }
    }

    private Set<ServiceIdActivation> determineAllServiceIds() {
        HashSet<ServiceIdActivation> allServiceIds = new HashSet<ServiceIdActivation>();
        for (BlockEntry block : this._transitGraphDao.getAllBlocks()) {
            for (BlockConfigurationEntry blockConfig : block.getConfigurations()) {
                ServiceIdActivation serviceIds = blockConfig.getServiceIds();
                allServiceIds.add(serviceIds);
            }
        }
        return allServiceIds;
    }

    private List<Date> computeServiceDatesForServiceIds(ServiceIdActivation serviceIds, Date lowerBounds, Date upperBounds) {
        List dates;
        HashSet serviceDates = null;
        for (LocalizedServiceId lsid : serviceIds.getActiveServiceIds()) {
            dates = this._calendarService.getDatesForLocalizedServiceId(lsid);
            if (dates == null) {
                dates = Collections.emptyList();
            }
            if (serviceDates == null) {
                serviceDates = new HashSet(dates);
                continue;
            }
            serviceDates.retainAll(dates);
        }
        for (LocalizedServiceId lsid : serviceIds.getInactiveServiceIds()) {
            dates = this._calendarService.getDatesForLocalizedServiceId(lsid);
            if (serviceDates == null) continue;
            serviceDates.removeAll(dates);
        }
        ArrayList<Date> dates2 = new ArrayList<Date>();
        if (serviceDates != null) {
            for (Date serviceDate : serviceDates) {
                if (lowerBounds != null && !lowerBounds.before(serviceDate) || upperBounds != null && !serviceDate.before(upperBounds)) continue;
                dates2.add(serviceDate);
            }
        }
        Collections.sort(dates2);
        return dates2;
    }

    private class ServiceDateRangeKey {
        private final Serializable _serviceIds;
        private final int _fromStopTime;
        private final int _toStopTime;
        private final long _fromTime;
        private final long _toTime;

        public ServiceDateRangeKey(Serializable serviceIds, int fromStopTime, int toStopTime, long fromTime, long toTime) {
            if (serviceIds == null) {
                throw new IllegalStateException("serviceIds cannot be null");
            }
            this._serviceIds = serviceIds;
            this._fromStopTime = fromStopTime;
            this._toStopTime = toStopTime;
            this._fromTime = fromTime;
            this._toTime = toTime;
        }

        public ServiceIdActivation getServiceIds() {
            if (this._serviceIds instanceof ServiceIdActivation) {
                return (ServiceIdActivation)this._serviceIds;
            }
            if (this._serviceIds instanceof LocalizedServiceId) {
                return new ServiceIdActivation((LocalizedServiceId)this._serviceIds);
            }
            throw new IllegalStateException("unknown service id type: " + this._serviceIds);
        }

        public ServiceInterval getInterval() {
            return new ServiceInterval(this._fromStopTime, this._toStopTime);
        }

        public Date getFromTime() {
            return new Date(this._fromTime);
        }

        public Date getToTime() {
            return new Date(this._toTime);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this._fromStopTime;
            result = 31 * result + (int)(this._fromTime ^ this._fromTime >>> 32);
            result = 31 * result + this._serviceIds.hashCode();
            result = 31 * result + this._toStopTime;
            result = 31 * result + (int)(this._toTime ^ this._toTime >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceDateRangeKey other = (ServiceDateRangeKey)obj;
            if (this._fromStopTime != other._fromStopTime) {
                return false;
            }
            if (this._fromTime != other._fromTime) {
                return false;
            }
            if (!this._serviceIds.equals(other._serviceIds)) {
                return false;
            }
            if (this._toStopTime != other._toStopTime) {
                return false;
            }
            return this._toTime == other._toTime;
        }
    }
}

