/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.transit_data.OccupancyStatusBean;
import org.onebusaway.transit_data_federation.model.bundle.HistoricalRidership;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.RidershipService;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RidershipServiceImpl
implements RidershipService {
    private static Logger _log = LoggerFactory.getLogger(RidershipServiceImpl.class);
    private FederatedTransitDataBundle _bundle;
    private List<HistoricalRidership> _riderships;
    private Map<AgencyAndId, List<HistoricalRidership>> _tripRiderships;
    private Map<AgencyAndId, List<HistoricalRidership>> _routeRiderships;
    private Map<AgencyAndId, List<HistoricalRidership>> _stopRiderships;
    private Map<String, List<HistoricalRidership>> _tuppleRiderships;

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    @PostConstruct
    @Refreshable(dependsOn={"transitGraph"})
    public void setup() throws IOException, ClassNotFoundException {
        File path = this._bundle.getHistoricalRidershipPath();
        if (path.exists()) {
            _log.info("loading historical riderships...");
            this._riderships = (List)ObjectSerializationLibrary.readObject((File)path);
            _log.info("loading historical riderships...done");
        } else {
            _log.info("historical riderships not found at " + path);
            this._riderships = new ArrayList<HistoricalRidership>();
        }
        this._tripRiderships = new HashMap<AgencyAndId, List<HistoricalRidership>>();
        this._routeRiderships = new HashMap<AgencyAndId, List<HistoricalRidership>>();
        this._stopRiderships = new HashMap<AgencyAndId, List<HistoricalRidership>>();
        this._tuppleRiderships = new HashMap<String, List<HistoricalRidership>>();
        _log.info("generating historical ridership indexes");
        this.createIndexes();
        _log.info("complete with " + this._riderships.size() + " entries");
    }

    private void createIndexes() {
        for (HistoricalRidership hr : this._riderships) {
            AgencyAndId routeId = hr.getRouteId();
            AgencyAndId tripId = hr.getTripId();
            AgencyAndId stopId = hr.getStopId();
            String tupple = this.hash(routeId, tripId, stopId);
            if (this._routeRiderships.containsKey(routeId)) {
                this._routeRiderships.get(routeId).add(hr);
            } else {
                this._routeRiderships.put(routeId, this.createList(hr));
            }
            if (this._tripRiderships.containsKey(tripId)) {
                this._tripRiderships.get(tripId).add(hr);
            } else {
                this._tripRiderships.put(tripId, this.createList(hr));
            }
            if (this._stopRiderships.containsKey(stopId)) {
                this._stopRiderships.get(stopId).add(hr);
            } else {
                this._stopRiderships.put(stopId, this.createList(hr));
            }
            if (tupple == null) continue;
            if (this._tuppleRiderships.containsKey(tupple)) {
                this._tuppleRiderships.get(tupple).add(hr);
                continue;
            }
            this._tuppleRiderships.put(tupple, this.createList(hr));
        }
    }

    private List<HistoricalRidership> createList(HistoricalRidership hr) {
        ArrayList<HistoricalRidership> list = new ArrayList<HistoricalRidership>();
        list.add(hr);
        return list;
    }

    private String hash(AgencyAndId a1, AgencyAndId a2, AgencyAndId a3) {
        if (a1 != null && a2 != null && a3 != null) {
            return a1.toString() + "." + a2.toString() + "." + a3.toString();
        }
        return null;
    }

    @Override
    public List<HistoricalRidership> getAllHistoricalRiderships(long serviceDate) {
        return this.filterByServiceDate(this._riderships, serviceDate);
    }

    @Override
    public List<HistoricalRidership> getHistoricalRidershipsForTrip(AgencyAndId tripId, long serviceDate) {
        return this.filterByServiceDate(this._tripRiderships.get(tripId), serviceDate);
    }

    @Override
    public List<HistoricalRidership> getHistoricalRidershipsForStop(AgencyAndId stopId, long serviceDate) {
        return this.filterByServiceDate(this._stopRiderships.get(stopId), serviceDate);
    }

    @Override
    public List<HistoricalRidership> getHistoricalRidershipsForRoute(AgencyAndId routeId, long serviceDate) {
        return this.filterByServiceDate(this._routeRiderships.get(routeId), serviceDate);
    }

    @Override
    public List<HistoricalRidership> getHistoricalRiderships(AgencyAndId routeId, AgencyAndId tripId, AgencyAndId stopId, long serviceDate) {
        String hash = this.hash(routeId, tripId, stopId);
        if (hash == null) {
            return new ArrayList<HistoricalRidership>();
        }
        return this.filterByServiceDate(this._tuppleRiderships.get(hash), serviceDate);
    }

    @Override
    public List<OccupancyStatusBean> convertToOccupancyStatusBeans(List<HistoricalRidership> hrs) {
        ArrayList<OccupancyStatusBean> beans = new ArrayList<OccupancyStatusBean>();
        if (hrs != null) {
            for (HistoricalRidership hr : hrs) {
                OccupancyStatusBean bean = new OccupancyStatusBean();
                bean.setStopId(hr.getStopId());
                bean.setTripId(hr.getTripId());
                bean.setRouteId(hr.getRouteId());
                bean.setOccpancyStatus(OccupancyStatus.toEnum((double)hr.getLoadFactor()));
                beans.add(bean);
            }
        }
        return beans;
    }

    private List<HistoricalRidership> filterByServiceDate(List<HistoricalRidership> input, long sd) {
        if (sd == 0L || input == null) {
            return input;
        }
        ArrayList<HistoricalRidership> results = new ArrayList<HistoricalRidership>();
        for (HistoricalRidership hr : input) {
            if (this.isWeekday(sd)) {
                if (hr.getCalendarType() != HistoricalRidership.CalendarType.WEEKDAY) continue;
                results.add(hr);
                continue;
            }
            if (hr.getCalendarType() != HistoricalRidership.CalendarType.SATURDAY && hr.getCalendarType() != HistoricalRidership.CalendarType.SUNDAY) continue;
            results.add(hr);
        }
        return results;
    }

    private boolean isWeekday(long sd) {
        Calendar cal = new ServiceDate(new Date(sd)).getAsCalendar(TimeZone.getDefault());
        return cal.get(7) != 7 && cal.get(7) != 1;
    }
}

