/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.transit_data_federation.impl.DirectedGraph;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;

public class StopGraphComparator
implements Comparator<StopEntry> {
    private DirectedGraph<StopEntry> _graph;
    private Map<StopEntry, Double> _maxDistance = new HashMap<StopEntry, Double>();

    public StopGraphComparator(DirectedGraph<StopEntry> graph) {
        this._graph = graph;
    }

    @Override
    public int compare(StopEntry o1, StopEntry o2) {
        double d2;
        double d1 = this.getMaxDistance(o1);
        return d1 == (d2 = this.getMaxDistance(o2)) ? 0 : (d1 < d2 ? 1 : -1);
    }

    private double getMaxDistance(StopEntry stop) {
        return this.getMaxDistance(stop, new HashSet<StopEntry>());
    }

    private double getMaxDistance(StopEntry stop, Set<StopEntry> visited) {
        Double d = this._maxDistance.get(stop);
        if (d != null) {
            return d;
        }
        if (!visited.add(stop)) {
            throw new IllegalStateException("cycle");
        }
        double dMax = 0.0;
        for (StopEntry next : this._graph.getOutboundNodes(stop)) {
            double potential = SphericalGeometryLibrary.distance((double)stop.getStopLat(), (double)stop.getStopLon(), (double)next.getStopLat(), (double)next.getStopLon()) + this.getMaxDistance(next, visited);
            if (!(potential > dMax)) continue;
            dMax = potential;
        }
        this._maxDistance.put(stop, dMax);
        return dMax;
    }
}

